/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database.event;

import edu.sc.seis.fissuresUtil.database.ConnMgr;
import edu.sc.seis.fissuresUtil.database.DBUtil;
import edu.sc.seis.fissuresUtil.database.JDBCSequence;
import edu.sc.seis.fissuresUtil.database.NotFound;
import edu.sc.seis.fissuresUtil.database.event.EventTable;
import edu.sc.seis.fissuresUtil.database.event.JDBCContributor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class JDBCCatalog
extends EventTable {
    protected JDBCContributor jdbcContributor;
    protected PreparedStatement getDBId;
    protected PreparedStatement get;
    protected PreparedStatement put;
    protected PreparedStatement getAll;
    private JDBCSequence seq;

    public JDBCCatalog(Connection conn) throws SQLException {
        this(conn, new JDBCContributor(conn));
    }

    public JDBCCatalog(Connection conn, JDBCContributor jdbcContributor) throws SQLException {
        super("catalog", conn);
        this.jdbcContributor = jdbcContributor;
        this.seq = new JDBCSequence(conn, "CatalogSeq");
        Statement stmt = conn.createStatement();
        if (!DBUtil.tableExists("catalog", conn)) {
            stmt.executeUpdate(ConnMgr.getSQL("catalog.create"));
        }
        this.put = conn.prepareStatement(" INSERT INTO catalog (catalog_id, catalog_contributor_id, catalog_name ) VALUES( ?, ?, ?) ");
        this.get = conn.prepareStatement("SELECT catalog_name, catalog_contributor_id FROM catalog WHERE catalog_id = ?");
        this.getDBId = conn.prepareStatement("SELECT catalog_id FROM catalog WHERE catalog_name = ? ");
        this.getAll = conn.prepareStatement("SELECT DISTINCT catalog_name FROM catalog");
    }

    public int insert(String catalog, PreparedStatement stmt, int index, int contributorid) throws SQLException {
        stmt.setInt(index++, contributorid);
        stmt.setString(index++, catalog);
        return index;
    }

    public int put(String catalog, String contributor) throws SQLException {
        try {
            return this.getDBId(catalog);
        }
        catch (NotFound nfe) {
            int id = this.seq.next();
            this.put.setInt(1, id);
            int contributorid = this.jdbcContributor.put(contributor);
            this.insert(catalog, this.put, 2, contributorid);
            this.put.executeUpdate();
            return id;
        }
    }

    public int getDBId(String catalog) throws SQLException, NotFound {
        this.getDBId.setString(1, catalog);
        ResultSet rs = this.getDBId.executeQuery();
        if (rs.next()) {
            return rs.getInt("catalog_id");
        }
        throw new NotFound("the entry for the given origin object is not found");
    }

    public String get(int id) throws SQLException, NotFound {
        this.get.setInt(1, id);
        ResultSet rs = this.get.executeQuery();
        if (rs.next()) {
            this.extract(rs);
        }
        throw new NotFound(" there is no Catalog name is associated  to the id " + id);
    }

    public String[] getAllCatalogs() throws SQLException {
        ArrayList<String> aList = new ArrayList<String>();
        ResultSet rs = this.getAll.executeQuery();
        while (rs.next()) {
            aList.add(this.extract(rs));
        }
        String[] catalogs = new String[aList.size()];
        catalogs = aList.toArray(catalogs);
        return catalogs;
    }

    public String getContributorOnContributorId(int id) throws SQLException, NotFound {
        return this.jdbcContributor.get(id);
    }

    public String getContributor(int id) throws SQLException, NotFound {
        this.get.setInt(1, id);
        ResultSet rs = this.get.executeQuery();
        if (rs.next()) {
            return this.jdbcContributor.get(rs.getInt("catalog_contributor_id"));
        }
        throw new NotFound(" there is no Catalog name is associated  to the id " + id);
    }

    public String extract(ResultSet rs) throws SQLException {
        return rs.getString("catalog_name");
    }

    public JDBCContributor getJDBCContributor() {
        return this.jdbcContributor;
    }
}

