/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database.event;

import edu.iris.Fissures.Area;
import edu.iris.Fissures.BoxArea;
import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfEvent.EventAttr;
import edu.iris.Fissures.IfEvent.NoPreferredOrigin;
import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.PointDistanceAreaImpl;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.bag.AreaUtil;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.cache.EventUtil;
import edu.sc.seis.fissuresUtil.database.ConnMgr;
import edu.sc.seis.fissuresUtil.database.JDBCSequence;
import edu.sc.seis.fissuresUtil.database.NotFound;
import edu.sc.seis.fissuresUtil.database.event.EventTable;
import edu.sc.seis.fissuresUtil.database.event.JDBCEventAttr;
import edu.sc.seis.fissuresUtil.database.event.JDBCOrigin;
import edu.sc.seis.fissuresUtil.database.util.TableSetup;
import edu.sc.seis.fissuresUtil.display.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.flow.querier.EventFinderQuery;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class JDBCEventAccess
extends EventTable {
    private JDBCOrigin jdbcOrigin;
    private JDBCEventAttr jdbcAttr;
    private JDBCSequence seq;
    private static Map idsToEvents = Collections.synchronizedMap(new HashMap());
    private static Map eventsToIds = Collections.synchronizedMap(new HashMap());
    private static List eventAccessList = Collections.synchronizedList(new ArrayList());
    private static int MAX_EVENTS = 5000;
    private static final Logger logger = Logger.getLogger((Class)JDBCEventAccess.class);
    public static final float INCONCEIVABLY_SMALL_MAGNITUDE = -99.0f;
    public static final float INCONCEIVABLY_LARGE_MAGNITUDE = 12.0f;
    public static final float INCONCEIVABLY_SMALL_DEPTH = -99.0f;
    public static final float INCONCEIVABLY_LARGE_DEPTH = 7000.0f;
    private PreparedStatement put;
    private PreparedStatement getDBIdStmt;
    private PreparedStatement getAttrAndOrigin;
    private PreparedStatement getEventIds;
    private PreparedStatement finderQueryAvoidDateline;
    private PreparedStatement finderQueryAroundDateline;
    private PreparedStatement getByNameStmt;
    private PreparedStatement getLast;

    public JDBCEventAccess() throws SQLException {
        this(ConnMgr.createConnection());
    }

    public JDBCEventAccess(Connection conn) throws SQLException {
        this(conn, new JDBCOrigin(conn), new JDBCEventAttr(conn));
    }

    public JDBCEventAccess(Connection conn, JDBCOrigin origins, JDBCEventAttr attrs) throws SQLException {
        super("eventaccess", conn);
        this.jdbcOrigin = origins;
        this.jdbcAttr = attrs;
        this.seq = new JDBCSequence(conn, "EventAccessSeq");
        TableSetup.setup(this, "edu/sc/seis/fissuresUtil/database/props/event/eventaccess.props");
    }

    public CacheEvent getEvent(int dbid) throws SQLException, NotFound {
        CacheEvent ev = (CacheEvent)idsToEvents.get(new Integer(dbid));
        if (ev != null) {
            JDBCEventAccess.touchEventId(dbid);
            ev.setDbId(dbid);
            return ev;
        }
        this.getAttrAndOrigin.setInt(1, dbid);
        ResultSet rs = this.getAttrAndOrigin.executeQuery();
        if (rs.next()) {
            return this.getEvent(rs, dbid);
        }
        throw new NotFound();
    }

    public CacheEvent[] getEvents(int[] dbIds) throws SQLException, NotFound {
        CacheEvent[] events = new CacheEvent[dbIds.length];
        for (int i = 0; i < dbIds.length; ++i) {
            events[i] = this.getEvent(dbIds[i]);
        }
        return events;
    }

    private CacheEvent getEvent(ResultSet rs, int dbid) throws NotFound, SQLException {
        Origin preferredOrigin = this.jdbcOrigin.get(rs.getInt("origin_id"));
        Origin[] allOrigins = this.jdbcOrigin.getOrigins(dbid);
        EventAttr attr = this.jdbcAttr.get(rs.getInt("eventattr_id"));
        CacheEvent ev = new CacheEvent(attr, allOrigins, preferredOrigin);
        idsToEvents.put(new Integer(dbid), ev);
        JDBCEventAccess.touchEventId(dbid);
        ev.setDbId(dbid);
        return ev;
    }

    public CacheEvent[] getAllEvents() throws SQLException, SQLException {
        List events = this.getAllEventsList();
        return events.toArray(new CacheEvent[events.size()]);
    }

    public List getAllEventsList() throws SQLException, SQLException {
        return this.extractEvents(this.getEventIds.executeQuery());
    }

    public List extractEvents(ResultSet rs) throws SQLException {
        ArrayList<CacheEvent> events = new ArrayList<CacheEvent>();
        while (rs.next()) {
            try {
                int id = rs.getInt("event_id");
                CacheEvent ev = (CacheEvent)idsToEvents.get(new Integer(id));
                JDBCEventAccess.touchEventId(id);
                if (ev != null) {
                    events.add(ev);
                    continue;
                }
                events.add(this.getEvent(rs, id));
            }
            catch (NotFound e) {
                throw new RuntimeException("This shouldn't happen.  I just got that id", e);
            }
        }
        return events;
    }

    public int put(EventAccessOperations eao, String IOR, String server, String dns) throws SQLException {
        if (!(eao instanceof CacheEvent)) {
            eao = new CacheEvent(eao);
        }
        try {
            return this.getDBId(eao);
        }
        catch (NotFound e) {
            return this.insert(eao, IOR, server, dns);
        }
    }

    public int insert(EventAccessOperations eao, String IOR, String server, String dns) throws SQLException {
        int originId;
        int id = this.seq.next();
        int attrId = this.jdbcAttr.put(eao.get_attributes());
        for (int i = 0; i < eao.get_origins().length; ++i) {
            this.jdbcOrigin.put(eao.get_origins()[i], id);
        }
        try {
            originId = this.jdbcOrigin.getDBId(eao.get_preferred_origin());
        }
        catch (NotFound ex) {
            throw new RuntimeException("The preferred origin wasn't found right after all origins were inserted.  This shouldn't ever happen.  If you're seeing this, I imagine very bad things are happening to the database right now");
        }
        catch (NoPreferredOrigin ee) {
            throw new IllegalArgumentException("Events passed in must have preferred origins");
        }
        this.put.setInt(1, id);
        this.put.setString(2, IOR);
        this.put.setInt(3, originId);
        this.put.setInt(4, attrId);
        this.put.setString(5, server);
        this.put.setString(6, dns);
        this.put.executeUpdate();
        eventsToIds.put(eao, new Integer(id));
        idsToEvents.put(new Integer(id), eao);
        JDBCEventAccess.touchEventId(id);
        return id;
    }

    public boolean contains(EventAccessOperations eao) throws SQLException {
        try {
            this.getDBId(eao);
        }
        catch (NotFound e) {
            return false;
        }
        return true;
    }

    public int getDBId(EventAccessOperations eao) throws SQLException, NotFound {
        Integer id;
        if (!(eao instanceof CacheEvent)) {
            eao = new CacheEvent(eao);
        }
        if ((id = (Integer)eventsToIds.get(eao)) != null) {
            JDBCEventAccess.touchEventId(id);
            return id;
        }
        this.getDBIdStmt.setInt(1, this.jdbcAttr.getDBId(eao.get_attributes()));
        try {
            this.getDBIdStmt.setInt(2, this.jdbcOrigin.getDBId(eao.get_preferred_origin()));
        }
        catch (NoPreferredOrigin e) {
            throw new IllegalArgumentException("The event access passed into getDBId must have a preferred origin");
        }
        ResultSet rs = this.getDBIdStmt.executeQuery();
        if (rs.next()) {
            int dbid = rs.getInt("event_id");
            eventsToIds.put(eao, new Integer(dbid));
            JDBCEventAccess.touchEventId(dbid);
            return dbid;
        }
        throw new NotFound("The event wasn't found in the db!");
    }

    public int[] query(EventFinderQuery q) throws SQLException {
        return JDBCEventAccess.query(q, this.finderQueryAvoidDateline, this.finderQueryAroundDateline);
    }

    public static int[] query(EventFinderQuery q, PreparedStatement avoidDatelineStatement, PreparedStatement aroundDatelineStatement) throws SQLException {
        int index = 1;
        BoxArea ba = AreaUtil.makeContainingBox(q.getArea());
        PreparedStatement finderQuery = ba.min_longitude <= ba.max_longitude ? avoidDatelineStatement : aroundDatelineStatement;
        finderQuery.setFloat(index++, ba.min_latitude);
        finderQuery.setFloat(index++, ba.max_latitude);
        finderQuery.setFloat(index++, q.getMinMag());
        finderQuery.setFloat(index++, q.getMaxMag());
        MicroSecondTimeRange range = q.getTime();
        finderQuery.setTimestamp(index++, range.getBeginTime().getTimestamp());
        finderQuery.setTimestamp(index++, range.getEndTime().getTimestamp());
        finderQuery.setDouble(index++, q.getMinDepth());
        finderQuery.setDouble(index++, q.getMaxDepth());
        finderQuery.setFloat(index++, ba.min_longitude);
        finderQuery.setFloat(index++, ba.max_longitude);
        ResultSet rs = finderQuery.executeQuery();
        ArrayList<Integer> out = new ArrayList<Integer>();
        while (rs.next()) {
            out.add(new Integer(rs.getInt(1)));
        }
        Integer[] bigInt = out.toArray(new Integer[out.size()]);
        int[] littleInt = new int[bigInt.length];
        for (int i = 0; i < bigInt.length; ++i) {
            littleInt[i] = bigInt[i];
        }
        return littleInt;
    }

    public CacheEvent[] getSimilarEvents(CacheEvent event, TimeInterval timeTolerance, QuantityImpl positionTolerance) throws SQLException, NotFound {
        EventFinderQuery query = new EventFinderQuery();
        Origin origin = EventUtil.extractOrigin(event);
        MicroSecondDate evTime = new MicroSecondDate(origin.origin_time);
        MicroSecondTimeRange timeRange = new MicroSecondTimeRange(evTime.subtract(timeTolerance), evTime.add(timeTolerance));
        PointDistanceAreaImpl area = new PointDistanceAreaImpl(origin.my_location.latitude, origin.my_location.longitude, (Quantity)new QuantityImpl(0.0, (Unit)UnitImpl.DEGREE), (Quantity)positionTolerance);
        query.setTime(timeRange);
        query.setArea((Area)area);
        query.setMinMag(-99.0f);
        query.setMaxMag(12.0f);
        query.setMinDepth(-99.0);
        query.setMaxDepth(7000.0);
        int[] eventIds = this.query(query);
        CacheEvent[] events = this.getEvents(eventIds);
        return events;
    }

    public int[] getByName(String name) throws SQLException, NotFound {
        this.getByNameStmt.setString(1, name);
        ResultSet rs = this.getByNameStmt.executeQuery();
        ArrayList<Integer> out = new ArrayList<Integer>();
        while (rs.next()) {
            out.add(new Integer(rs.getInt(1)));
        }
        if (out.size() == 0) {
            throw new NotFound("No events by name " + name);
        }
        Integer[] bigInt = out.toArray(new Integer[out.size()]);
        int[] littleInt = new int[bigInt.length];
        for (int i = 0; i < bigInt.length; ++i) {
            littleInt[i] = bigInt[i];
        }
        return littleInt;
    }

    public JDBCEventAttr getAttributeTable() {
        return this.jdbcAttr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void touchEventId(int dbid) {
        List list = eventAccessList;
        synchronized (list) {
            Integer id = new Integer(dbid);
            if (eventAccessList.contains(id)) {
                eventAccessList.remove(id);
            }
            eventAccessList.add(0, id);
            if (eventAccessList.size() > MAX_EVENTS) {
                Integer dbIdToRemove = (Integer)eventAccessList.remove(eventAccessList.size() - 1);
                EventAccessOperations eao = (EventAccessOperations)idsToEvents.remove(dbIdToRemove);
                eventsToIds.remove(eao);
            }
        }
    }

    public static void emptyCache() {
        idsToEvents.clear();
        eventsToIds.clear();
        eventAccessList.clear();
    }

    public JDBCEventAttr getJDBCAttr() {
        return this.jdbcAttr;
    }

    public JDBCOrigin getJDBCOrigin() {
        return this.jdbcOrigin;
    }

    public CacheEvent getLastEvent() throws SQLException, NotFound {
        ResultSet rs = this.getLast.executeQuery();
        if (rs.next()) {
            return this.getEvent(rs.getInt("event_id"));
        }
        throw new NotFound("No events!");
    }
}

