/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database.event;

import edu.iris.Fissures.FlinnEngdahlRegion;
import edu.iris.Fissures.IfEvent.EventAttr;
import edu.iris.Fissures.IfParameterMgr.ParameterRef;
import edu.iris.Fissures.event.EventAttrImpl;
import edu.sc.seis.fissuresUtil.database.ConnMgr;
import edu.sc.seis.fissuresUtil.database.DBUtil;
import edu.sc.seis.fissuresUtil.database.JDBCParameterRef;
import edu.sc.seis.fissuresUtil.database.JDBCSequence;
import edu.sc.seis.fissuresUtil.database.NotFound;
import edu.sc.seis.fissuresUtil.database.event.EventTable;
import edu.sc.seis.fissuresUtil.database.event.JDBCFlinnEngdahl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class JDBCEventAttr
extends EventTable {
    private JDBCFlinnEngdahl flinnEngdahl;
    private JDBCParameterRef paramRef;
    private PreparedStatement getDBIdStmt;
    private PreparedStatement getEvent;
    private PreparedStatement getParameterRefs;
    private PreparedStatement getByNameStmt;
    private PreparedStatement putStmt;
    private PreparedStatement putEventParamRefStmt;
    private PreparedStatement getAllStmt;
    private PreparedStatement updateRegionStmt;
    private JDBCSequence seq;
    private static Logger logger = Logger.getLogger((Class)JDBCEventAttr.class);

    public JDBCEventAttr(Connection conn) throws SQLException {
        this(conn, new JDBCParameterRef(conn), new JDBCFlinnEngdahl(conn));
    }

    public JDBCEventAttr(Connection conn, JDBCParameterRef paramRef, JDBCFlinnEngdahl flinnEngdahl) throws SQLException {
        super("eventattr", conn);
        this.paramRef = paramRef;
        this.flinnEngdahl = flinnEngdahl;
        this.seq = new JDBCSequence(conn, "EventAttrSeq");
        Statement stmt = conn.createStatement();
        if (!DBUtil.tableExists("eventattr", conn)) {
            stmt.executeUpdate(ConnMgr.getSQL("eventattr.create"));
        }
        if (!DBUtil.tableExists("eventparameterreference", conn)) {
            stmt.executeUpdate(ConnMgr.getSQL("eventparameterreference.create"));
        }
        this.putStmt = conn.prepareStatement(" INSERT INTO eventattr (eventattr_id, eventattr_name , flinnengdahlid) VALUES( ?,?,?)");
        this.putEventParamRefStmt = conn.prepareStatement(" INSERT INTO eventparameterreference (eventparameterreferenceid,  parameterid )  VALUES(?,?)");
        this.getDBIdStmt = conn.prepareStatement(" SELECT eventattr_id FROM eventattr WHERE eventattr_name = ? AND flinnengdahlid = ? ");
        this.getEvent = conn.prepareStatement(" SELECT * FROM eventattr WHERE eventattr_id = ?");
        this.getParameterRefs = conn.prepareStatement(" SELECT parametera_id, parametercreator FROM " + paramRef.getTableName() + ", " + "eventparameterreference, " + "eventattr " + " WHERE " + " parameterref.parameterid = " + " eventparameterreference.parameterid" + " AND " + "eventparameterreferenceid = " + " eventattr_id AND " + " eventattr_id = ?");
        this.getAllStmt = conn.prepareStatement(" SELECT eventattr_id FROM eventattr");
        this.getByNameStmt = conn.prepareStatement(" select distinct eventattr_id FROM eventattr WHERE eventattr_name = ?");
        this.updateRegionStmt = conn.prepareStatement(" UPDATE eventattr SET flinnengdahlid = ?  WHERE eventattr_id = ?");
    }

    private int insert(EventAttr eventAttr, PreparedStatement stmt, int index) throws SQLException {
        stmt.setString(index++, eventAttr.name);
        stmt.setInt(index++, this.flinnEngdahl.put(eventAttr.region));
        return index;
    }

    public int getDBId(EventAttr eventAttr) throws SQLException, NotFound {
        this.insert(eventAttr, this.getDBIdStmt, 1);
        ResultSet rs = this.getDBIdStmt.executeQuery();
        if (rs.next()) {
            return rs.getInt("eventattr_id");
        }
        throw new NotFound("id for this eventAttr is not found");
    }

    public EventAttr[] getEventAttrs() throws SQLException, NotFound {
        ResultSet rs = this.getAllStmt.executeQuery();
        ArrayList<EventAttr> aList = new ArrayList<EventAttr>();
        while (rs.next()) {
            aList.add(this.get(rs.getInt("eventattr_id")));
        }
        EventAttr[] eventAttrs = new EventAttr[aList.size()];
        eventAttrs = aList.toArray(eventAttrs);
        return eventAttrs;
    }

    public Integer[] getByName(String name) throws SQLException, NotFound {
        this.getByNameStmt.setString(1, name);
        ResultSet rs = this.getByNameStmt.executeQuery();
        ArrayList<Integer> aList = new ArrayList<Integer>();
        while (rs.next()) {
            aList.add(new Integer(rs.getInt("eventattr_id")));
        }
        Integer[] eventIds = new Integer[aList.size()];
        eventIds = aList.toArray(eventIds);
        return eventIds;
    }

    public int put(EventAttr eventAttr) throws SQLException {
        try {
            return this.getDBId(eventAttr);
        }
        catch (NotFound notFound) {
            int id = this.seq.next();
            this.putStmt.setInt(1, id);
            this.insert(eventAttr, this.putStmt, 2);
            this.putStmt.executeUpdate();
            this.insertParameters(eventAttr.parm_ids, id);
            return id;
        }
    }

    public EventAttr get(int eventid) throws SQLException, NotFound {
        this.getEvent.setInt(1, eventid);
        ResultSet rs = this.getEvent.executeQuery();
        if (rs.next()) {
            return this.extract(rs);
        }
        throw new NotFound("No EventAttr Found for eventid = " + eventid);
    }

    public void insertParameters(ParameterRef[] params, int eventid) throws SQLException {
        for (int i = 0; i < params.length; ++i) {
            int paramid = this.paramRef.put(params[i]);
            this.putEventParameterRef(eventid, paramid);
        }
    }

    public void putEventParameterRef(int eventid, int parameterid) throws SQLException {
        this.putEventParamRefStmt.setInt(1, eventid);
        this.putEventParamRefStmt.setInt(2, parameterid);
        this.putEventParamRefStmt.executeUpdate();
    }

    public ParameterRef[] getParameters(int id) throws SQLException {
        ArrayList<ParameterRef> ids = new ArrayList<ParameterRef>();
        this.getParameterRefs.setInt(1, id);
        ResultSet rs = this.getParameterRefs.executeQuery();
        while (rs.next()) {
            ids.add(new ParameterRef(rs.getString("parametera_id"), rs.getString("parametercreator")));
        }
        ParameterRef[] params = new ParameterRef[ids.size()];
        return ids.toArray(params);
    }

    public EventAttr extract(ResultSet rs) throws SQLException, NotFound {
        int id = rs.getInt("eventattr_id");
        ParameterRef[] params = this.getParameters(id);
        FlinnEngdahlRegion region = this.flinnEngdahl.get(rs.getInt("flinnengdahlid"));
        return new EventAttrImpl(rs.getString("eventattr_name"), region, params);
    }

    public void updateFlinnEngdahlRegion(int id, FlinnEngdahlRegion region) throws SQLException, NotFound {
        this.updateRegionStmt.setInt(1, this.flinnEngdahl.getDBId(region));
        this.updateRegionStmt.setInt(2, this.getDBId(this.get(id)));
        this.updateRegionStmt.executeUpdate();
    }
}

