/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database.event;

import edu.iris.Fissures.IfEvent.Magnitude;
import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.IfParameterMgr.ParameterRef;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.event.OriginImpl;
import edu.sc.seis.fissuresUtil.database.JDBCLocation;
import edu.sc.seis.fissuresUtil.database.JDBCParameterRef;
import edu.sc.seis.fissuresUtil.database.JDBCSequence;
import edu.sc.seis.fissuresUtil.database.JDBCTime;
import edu.sc.seis.fissuresUtil.database.NotFound;
import edu.sc.seis.fissuresUtil.database.event.EventTable;
import edu.sc.seis.fissuresUtil.database.event.JDBCCatalog;
import edu.sc.seis.fissuresUtil.database.event.JDBCEventAttr;
import edu.sc.seis.fissuresUtil.database.event.JDBCMagnitude;
import edu.sc.seis.fissuresUtil.database.util.TableSetup;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class JDBCOrigin
extends EventTable {
    protected JDBCLocation jdbcLocation;
    protected JDBCMagnitude jdbcMagnitude;
    protected JDBCParameterRef jdbcParamRef;
    protected JDBCEventAttr jdbcEventAttr;
    protected JDBCCatalog jdbcCatalog;
    private JDBCTime timeTable;
    protected String magnitudeSubTableName = "originmagnitude";
    private PreparedStatement putStmt;
    private PreparedStatement getStmt;
    private PreparedStatement getDBIdStmt;
    private PreparedStatement getParamsStmt;
    private PreparedStatement putOriginParamRefStmt;
    private PreparedStatement deleteOriginParamRefStmt;
    private PreparedStatement updateEventIdStmt;
    private PreparedStatement getAllStmt;
    private PreparedStatement deleteOriginStmt;
    private JDBCSequence seq;

    public JDBCOrigin(Connection conn) throws SQLException {
        this(conn, new JDBCLocation(conn), new JDBCEventAttr(conn), new JDBCParameterRef(conn), new JDBCMagnitude(conn), new JDBCCatalog(conn), new JDBCTime(conn));
    }

    public JDBCOrigin(Connection conn, JDBCLocation jdbcLocation, JDBCEventAttr jdbcEventAttr, JDBCParameterRef jdbcParameterRef, JDBCMagnitude jdbcMagnitude, JDBCCatalog jdbcCatalog, JDBCTime time) throws SQLException {
        super("origin", conn);
        this.jdbcLocation = jdbcLocation;
        this.jdbcParamRef = jdbcParameterRef;
        this.jdbcMagnitude = jdbcMagnitude;
        this.jdbcCatalog = jdbcCatalog;
        this.timeTable = time;
        String parameterSubTableName = "originparamref";
        this.jdbcEventAttr = jdbcEventAttr;
        this.seq = new JDBCSequence(conn, "OriginSeq");
        String props = "edu/sc/seis/fissuresUtil/database/props/event/default.props";
        TableSetup.setup(this.getTableName(), conn, (Object)this, props, new String[]{parameterSubTableName});
    }

    public int put(Origin origin) throws SQLException {
        try {
            return this.getDBId(origin);
        }
        catch (NotFound ex) {
            return this.insertOrigin(origin);
        }
    }

    private int insertOrigin(Origin o) throws SQLException {
        int id = this.seq.next();
        this.putStmt.setInt(1, id);
        this.insert(o, this.putStmt, 2);
        this.putStmt.executeUpdate();
        this.putParamRefs(o.parm_ids, id);
        this.putMagnitudes(o.magnitudes, id);
        return id;
    }

    public int put(Origin origin, int eventId) throws SQLException {
        int id = this.put(origin);
        this.setEventId(id, eventId);
        return id;
    }

    private void setEventId(int originId, int eventId) throws SQLException {
        this.updateEventIdStmt.setInt(1, eventId);
        this.updateEventIdStmt.setInt(2, originId);
        this.updateEventIdStmt.executeUpdate();
    }

    public void putParamRefs(ParameterRef[] params, int id) throws SQLException {
        for (int i = 0; i < params.length; ++i) {
            this.putParamRef(id, this.jdbcParamRef.put(params[i]));
        }
    }

    public void putParamRef(int id, int paramId) throws SQLException {
        this.putOriginParamRefStmt.setInt(1, id);
        this.putOriginParamRefStmt.setInt(2, paramId);
        this.putOriginParamRefStmt.executeUpdate();
    }

    public void deleteParamRef(int originid) throws SQLException {
        this.deleteOriginParamRefStmt.setInt(1, originid);
        this.deleteOriginParamRefStmt.executeUpdate();
    }

    public void putMagnitudes(Magnitude[] mags, int id) throws SQLException {
        this.jdbcMagnitude.put(mags, id);
    }

    public int getDBId(Origin origin) throws SQLException, NotFound {
        this.insert(origin, this.getDBIdStmt, 1);
        ResultSet rs = this.getDBIdStmt.executeQuery();
        if (rs.next()) {
            return rs.getInt("origin_id");
        }
        throw new NotFound('\n' + this.getDBIdStmt.toString());
    }

    public Origin[] getOrigins(int eventid) throws SQLException, NotFound {
        this.getAllStmt.setInt(1, eventid);
        ResultSet rs = this.getAllStmt.executeQuery();
        ArrayList<Origin> origins = new ArrayList<Origin>();
        while (rs.next()) {
            origins.add(this.get(rs.getInt("origin_id")));
        }
        return origins.toArray(new Origin[origins.size()]);
    }

    public Origin get(int originId) throws SQLException, NotFound {
        this.getStmt.setInt(1, originId);
        ResultSet rs = this.getStmt.executeQuery();
        if (rs.next()) {
            return this.extract(rs);
        }
        throw new NotFound(" there is no Origin object corresponding to the id " + originId);
    }

    public int insert(Origin origin, PreparedStatement stmt, int index) throws SQLException {
        stmt.setInt(index++, this.jdbcCatalog.put(origin.catalog, origin.contributor));
        stmt.setInt(index++, this.timeTable.put(origin.origin_time));
        stmt.setInt(index++, this.jdbcLocation.put(origin.my_location));
        stmt.setString(index++, origin.get_id());
        return index;
    }

    public ParameterRef[] getParams(int dbId) throws SQLException {
        ArrayList<ParameterRef> ids = new ArrayList<ParameterRef>();
        this.getParamsStmt.setInt(1, dbId);
        ResultSet rs = this.getParamsStmt.executeQuery();
        while (rs.next()) {
            ids.add(new ParameterRef(rs.getString("parametera_id"), rs.getString("parametercreator")));
        }
        return ids.toArray(new ParameterRef[ids.size()]);
    }

    public Magnitude[] getMags(int originId) throws SQLException, NotFound {
        return this.jdbcMagnitude.get(originId);
    }

    public Origin extract(ResultSet rs) throws SQLException, NotFound {
        int originId = rs.getInt("origin_id");
        ParameterRef[] params = this.getParams(originId);
        Magnitude[] magnitudes = this.getMags(originId);
        Location location = this.jdbcLocation.extract(rs);
        if (location == null) {
            throw new NullPointerException("Location from database is NULL, originId=" + originId);
        }
        return new OriginImpl(rs.getString("origin_text_id"), this.jdbcCatalog.extract(rs), this.jdbcCatalog.getJDBCContributor().extract(rs), this.timeTable.get(rs.getInt("origin_time_id")), location, magnitudes, params);
    }
}

