/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database.network;

import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.database.ConnMgr;
import edu.sc.seis.fissuresUtil.database.JDBCLocation;
import edu.sc.seis.fissuresUtil.database.JDBCSequence;
import edu.sc.seis.fissuresUtil.database.JDBCTime;
import edu.sc.seis.fissuresUtil.database.NotFound;
import edu.sc.seis.fissuresUtil.database.network.JDBCNetwork;
import edu.sc.seis.fissuresUtil.database.network.NetworkTable;
import edu.sc.seis.fissuresUtil.database.util.TableSetup;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class JDBCStation
extends NetworkTable {
    private PreparedStatement getAllQuery;
    private PreparedStatement getAllForNet;
    private PreparedStatement getIfNameExists;
    private PreparedStatement getByDBId;
    private PreparedStatement getStationIdByDBId;
    private PreparedStatement getDBId;
    private PreparedStatement updateSta;
    private PreparedStatement putAll;
    private PreparedStatement putId;
    private PreparedStatement putChanIdBits;
    private PreparedStatement getByChanIdBits;
    private PreparedStatement getDBIdsForNetAndCode;
    private PreparedStatement deleteStation;
    private PreparedStatement getAllStations;
    private JDBCLocation locTable;
    private JDBCNetwork netTable;
    private JDBCSequence seq;
    private JDBCTime time;
    private static Map dbIdsToStations = Collections.synchronizedMap(new HashMap());
    private static Map stationIdsToDbIds = Collections.synchronizedMap(new HashMap());

    public JDBCStation() throws SQLException {
        this(ConnMgr.createConnection());
    }

    public JDBCStation(Connection conn) throws SQLException {
        this(conn, new JDBCLocation(conn), new JDBCNetwork(conn), new JDBCTime(conn));
    }

    public JDBCStation(Connection conn, JDBCLocation jdbcLocation, JDBCNetwork jdbcNetwork, JDBCTime time) throws SQLException {
        super("station", conn);
        this.locTable = jdbcLocation;
        this.netTable = jdbcNetwork;
        this.time = time;
        this.seq = new JDBCSequence(conn, "StationSeq");
        TableSetup.setup(this, "edu/sc/seis/fissuresUtil/database/props/network/default.props");
    }

    private StationId[] extractAll(PreparedStatement query) throws SQLException {
        ResultSet rs = query.executeQuery();
        ArrayList<StationId> aList = new ArrayList<StationId>();
        try {
            while (rs.next()) {
                aList.add(JDBCStation.extractId(rs, this.netTable, this.time));
            }
        }
        catch (NotFound e) {
            return new StationId[0];
        }
        return aList.toArray(new StationId[aList.size()]);
    }

    public Station[] extractAll(ResultSet rs) throws SQLException {
        ArrayList<Station> stations = new ArrayList<Station>();
        while (rs.next()) {
            try {
                stations.add(JDBCStation.extract(rs, this.locTable, this.netTable, this.time));
            }
            catch (NotFound e) {
                GlobalExceptionHandler.handle("Got a not found for a particular station", e);
            }
        }
        return stations.toArray(new Station[stations.size()]);
    }

    public Station get(int dbid) throws SQLException, NotFound {
        Station sta = (Station)dbIdsToStations.get(new Integer(dbid));
        if (sta != null) {
            return sta;
        }
        this.getByDBId.setInt(1, dbid);
        ResultSet rs = this.getByDBId.executeQuery();
        if (rs.next()) {
            return JDBCStation.extract(rs, this.locTable, this.netTable, this.time);
        }
        throw new NotFound("No Station found for database id = " + dbid);
    }

    public Station get(StationId id) throws SQLException, NotFound {
        return this.get(this.getDBId(id));
    }

    public StationId[] getAllStationIds() throws SQLException {
        return this.extractAll(this.getAllQuery);
    }

    public Station[] getAllStations() throws SQLException {
        ResultSet rs = this.getAllStations.executeQuery();
        return this.extractAll(rs);
    }

    public StationId[] getAllStationIds(int netDbId) throws SQLException {
        this.getAllForNet.setInt(1, netDbId);
        return this.extractAll(this.getAllForNet);
    }

    public StationId[] getAllStationIds(NetworkId net) throws SQLException {
        try {
            return this.getAllStationIds(this.netTable.getDbId(net));
        }
        catch (NotFound e) {
            return new StationId[0];
        }
    }

    public Station[] getAllStations(NetworkId myId) throws SQLException {
        StationId[] ids = this.getAllStationIds(myId);
        Station[] stations = new Station[ids.length];
        for (int i = 0; i < stations.length; ++i) {
            try {
                stations[i] = this.get(ids[i]);
                continue;
            }
            catch (NotFound e) {
                GlobalExceptionHandler.handle("Unable to extract a station right after getting its id from the db", e);
                return new Station[0];
            }
        }
        return stations;
    }

    public int getDBId(StationId id) throws SQLException, NotFound {
        Integer dbId = (Integer)stationIdsToDbIds.get(id);
        if (dbId != null) {
            return dbId;
        }
        JDBCStation.insertId(id, this.getDBId, 1, this.netTable, this.time);
        ResultSet rs = this.getDBId.executeQuery();
        if (rs.next()) {
            int dbid = rs.getInt("sta_id");
            stationIdsToDbIds.put(id, new Integer(dbid));
            return dbid;
        }
        throw new NotFound("No such station id in the db");
    }

    public int[] getDBIds(int netDbId, String station_code) throws SQLException, NotFound {
        this.getDBIdsForNetAndCode.setInt(1, netDbId);
        this.getDBIdsForNetAndCode.setString(2, station_code);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        ResultSet rs = this.getDBIdsForNetAndCode.executeQuery();
        while (rs.next()) {
            ids.add(new Integer(rs.getInt("sta_id")));
        }
        if (ids.size() > 0) {
            int[] intIds = new int[ids.size()];
            for (int i = 0; i < ids.size(); ++i) {
                intIds[i] = (Integer)ids.get(i);
            }
            return intIds;
        }
        throw new NotFound("No stations in the database of code " + station_code + " for netDbId " + netDbId);
    }

    public int[] getDBIds(NetworkId net, String stationCode) throws SQLException, NotFound {
        return this.getDBIds(this.netTable.getDbId(net), stationCode);
    }

    public JDBCLocation getLocationTable() {
        return this.locTable;
    }

    public JDBCNetwork getNetTable() {
        return this.netTable;
    }

    public StationId getStationId(int dbid) throws SQLException, NotFound {
        Station sta = (Station)dbIdsToStations.get(new Integer(dbid));
        if (sta != null) {
            return sta.get_id();
        }
        this.getStationIdByDBId.setInt(1, dbid);
        ResultSet rs = this.getStationIdByDBId.executeQuery();
        if (rs.next()) {
            return JDBCStation.extractId(rs, this.netTable, this.time);
        }
        throw new NotFound("No StationId found for database id = " + dbid);
    }

    public int put(ChannelId id) throws SQLException {
        int netDbId = this.netTable.put(id.network_id);
        this.getByChanIdBits.setInt(1, netDbId);
        this.getByChanIdBits.setString(2, id.station_code);
        ResultSet rs = this.getByChanIdBits.executeQuery();
        if (rs.next()) {
            return rs.getInt(1);
        }
        int dbId = this.seq.next();
        this.putChanIdBits.setInt(1, dbId);
        this.putChanIdBits.setInt(2, netDbId);
        this.putChanIdBits.setString(3, id.station_code);
        this.putChanIdBits.executeUpdate();
        return dbId;
    }

    public int put(Station sta) throws SQLException {
        int dbid;
        try {
            dbid = this.getDBId(sta.get_id());
            this.getIfNameExists.setInt(1, dbid);
            ResultSet rs = this.getIfNameExists.executeQuery();
            if (!rs.next()) {
                this.updateStation(sta, dbid);
            }
        }
        catch (NotFound notFound) {
            try {
                int[] dbidForCode = this.getDBIds(sta.get_id().network_id, sta.get_code());
                MicroSecondDate staBeginDate = new MicroSecondDate(sta.effective_time.start_time);
                MicroSecondDate staEndDate = new MicroSecondDate(sta.effective_time.end_time);
                MicroSecondDate nowPlusTen = ClockUtil.now().add(new TimeInterval(10.0, UnitImpl.GREGORIAN_YEAR));
                for (int i = 0; i < dbidForCode.length; ++i) {
                    Station dbsta = this.get(dbidForCode[i]);
                    MicroSecondDate dbEndDate = new MicroSecondDate(dbsta.effective_time.end_time);
                    MicroSecondDate dbBeginDate = new MicroSecondDate(dbsta.effective_time.start_time);
                    if (!dbBeginDate.before((Date)staBeginDate) || !dbEndDate.after((Date)nowPlusTen) || !staEndDate.after((Date)nowPlusTen)) continue;
                    dbsta.effective_time.end_time = sta.effective_time.start_time;
                    this.updateStation(dbsta, dbidForCode[i]);
                }
            }
            catch (NotFound e) {
                // empty catch block
            }
            dbid = this.seq.next();
            this.putAll.setInt(1, dbid);
            JDBCStation.insertAll(sta, this.putAll, 2, this.netTable, this.locTable, this.time);
            dbIdsToStations.put(new Integer(dbid), sta);
            this.putAll.executeUpdate();
        }
        return dbid;
    }

    public void updateStation(Station sta, int dbid) throws SQLException {
        int index = JDBCStation.insertOnlyStation(sta, this.updateSta, 1, this.netTable, this.locTable, this.time);
        this.updateSta.setInt(index, dbid);
        this.updateSta.executeUpdate();
    }

    public int put(StationId id) throws SQLException {
        int dbid;
        try {
            dbid = this.getDBId(id);
        }
        catch (NotFound e) {
            dbid = this.seq.next();
            this.putId.setInt(1, dbid);
            JDBCStation.insertId(id, this.putId, 2, this.netTable, this.time);
            this.putId.executeUpdate();
        }
        return dbid;
    }

    public static void emptyCache() {
        stationIdsToDbIds.clear();
        dbIdsToStations.clear();
    }

    public static Station extract(ResultSet rs, JDBCLocation locTable, JDBCNetwork netTable, JDBCTime time) throws SQLException, NotFound {
        Station sta = (Station)dbIdsToStations.get(new Integer(rs.getInt("sta_id")));
        if (sta != null) {
            return sta;
        }
        StationId id = JDBCStation.extractId(rs, netTable, time);
        Time endTime = time.get(rs.getInt("sta_end_id"));
        boolean netChan = true;
        try {
            rs.findColumn("sta_loc_lat");
        }
        catch (SQLException e) {
            netChan = false;
        }
        sta = new StationImpl(id, rs.getString("sta_name"), netChan ? locTable.extract(rs, "sta_") : locTable.get(rs.getInt("loc_id")), new TimeRange(id.begin_time, endTime), rs.getString("sta_operator"), rs.getString("sta_description"), rs.getString("sta_comment"), netTable.get(rs.getInt("net_id")));
        dbIdsToStations.put(new Integer(rs.getInt("sta_id")), sta);
        return sta;
    }

    public static StationId extractId(ResultSet rs, JDBCNetwork netTable, JDBCTime time) throws SQLException, NotFound {
        Time begin_time = time.get(rs.getInt("sta_begin_id"));
        try {
            NetworkId netId = netTable.getNetworkId(rs.getInt("net_id"));
            StationId id = new StationId(netId, rs.getString("sta_code"), begin_time);
            stationIdsToDbIds.put(id, new Integer(rs.getInt("sta_id")));
            return id;
        }
        catch (NotFound e) {
            throw new RuntimeException("There is a foreign key constraint requiring that a net_id be in the network table, but it just returned a not found for one such key.  This probably indicates a db problem!", e);
        }
    }

    public static String getNeededForStation() {
        return JDBCStation.getNeededForStationId() + ", sta_end_id, sta_name, station.loc_id, sta_operator, sta_description, sta_comment";
    }

    public static String getNeededForStationId() {
        return "sta_id, station.net_id, sta_code, sta_begin_id";
    }

    public static int insertAll(Station sta, PreparedStatement stmt, int index, JDBCNetwork netTable, JDBCLocation locTable, JDBCTime time) throws SQLException {
        index = JDBCStation.insertId(sta.get_id(), stmt, index, netTable, time);
        index = JDBCStation.insertOnlyStation(sta, stmt, index, netTable, locTable, time);
        return index;
    }

    public static int insertId(StationId id, PreparedStatement stmt, int index, JDBCNetwork netTable, JDBCTime time) throws SQLException {
        stmt.setInt(index++, netTable.put(id.network_id));
        stmt.setString(index++, id.station_code);
        stmt.setInt(index++, time.put(id.begin_time));
        return index;
    }

    public static int insertOnlyStation(Station sta, PreparedStatement stmt, int index, JDBCNetwork netTable, JDBCLocation locTable, JDBCTime time) throws SQLException {
        netTable.put(sta.my_network);
        stmt.setInt(index++, time.put(sta.effective_time.end_time));
        stmt.setString(index++, sta.name);
        stmt.setString(index++, sta.operator);
        stmt.setString(index++, sta.description);
        stmt.setString(index++, sta.comment);
        stmt.setInt(index++, locTable.put(sta.my_location));
        return index;
    }

    public void cleanupVestigesOfLonelyChannelId(int sta_id) throws SQLException {
        this.deleteStation.setInt(1, sta_id);
        this.deleteStation.executeUpdate();
    }
}

