/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database.seismogram;

import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.StationIdUtil;
import edu.sc.seis.fissuresUtil.database.seismogram.RT130ReportFactory;
import edu.sc.seis.fissuresUtil.database.seismogram.StationDataSummary;
import edu.sc.seis.fissuresUtil.display.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.time.ReduceTool;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.IntervalCategoryDataset;
import org.jfree.data.gantt.Task;
import org.jfree.data.gantt.TaskSeries;
import org.jfree.data.gantt.TaskSeriesCollection;

public class RT130Report {
    private RT130ReportFactory reportFactory;
    private int numSacFiles;
    private int numMSeedFiles;
    private Map problemFiles = new HashMap();
    private Map channelIdWithTime = new HashMap();
    private Map channelIdToChannel = new HashMap();
    private Map channelToIDString = new HashMap();

    public void addRefTekSeismogram(Channel channel, MicroSecondDate beginTime, MicroSecondDate endTime) {
        String channelId = this.getIdString(channel);
        this.channelIdToChannel.put(channelId, channel);
        MicroSecondTimeRange timeRange = new MicroSecondTimeRange(beginTime, endTime);
        if (this.channelIdWithTime.containsKey(channelId)) {
            List list = (List)this.channelIdWithTime.get(channelId);
            list.add(timeRange);
            MicroSecondTimeRange[] timeRangeArray = ReduceTool.merge(list.toArray(new MicroSecondTimeRange[0]));
            LinkedList<MicroSecondTimeRange> newList = new LinkedList<MicroSecondTimeRange>();
            for (int i = 0; i < timeRangeArray.length; ++i) {
                newList.add(timeRangeArray[i]);
            }
            this.channelIdWithTime.put(channelId, newList);
        } else {
            LinkedList<MicroSecondTimeRange> list = new LinkedList<MicroSecondTimeRange>();
            list.add(timeRange);
            this.channelIdWithTime.put(channelId, list);
        }
    }

    public void addMSeedSeismogram() {
        ++this.numMSeedFiles;
    }

    public void addSacSeismogram() {
        ++this.numSacFiles;
    }

    public void makeReportImage() {
        RT130ReportFactory reportFactory = new RT130ReportFactory(this.channelIdWithTime, this.channelIdToChannel);
        TaskSeries taskSeries = new TaskSeries("Stations");
        List stationDataSummaryList = reportFactory.getSortedStationDataSummaryList();
        Iterator it = stationDataSummaryList.iterator();
        Task task = null;
        int i = 0;
        while (it.hasNext()) {
            StationDataSummary stationDataSummary = (StationDataSummary)it.next();
            Map channelsToTimeRanges = stationDataSummary.getChannelsWithTimeRanges();
            String channelCodeWithMostGaps = stationDataSummary.getChannelCodeWithMostGaps();
            List timeRangeList = (List)channelsToTimeRanges.get(channelCodeWithMostGaps);
            Iterator ik = timeRangeList.iterator();
            MicroSecondTimeRange firstTimeRange = stationDataSummary.getEncompassingTimeRange();
            task = new Task(stationDataSummary.getStationCode(), (Date)firstTimeRange.getBeginTime(), (Date)firstTimeRange.getEndTime());
            while (ik.hasNext()) {
                MicroSecondTimeRange allOtherTimeRanges = (MicroSecondTimeRange)ik.next();
                task.addSubtask(new Task(stationDataSummary.getStationCode(), (Date)allOtherTimeRanges.getBeginTime(), (Date)allOtherTimeRanges.getEndTime()));
            }
            taskSeries.add(task);
            ++i;
        }
        TaskSeriesCollection dataset = new TaskSeriesCollection();
        dataset.add(taskSeries);
        JFreeChart chart = ChartFactory.createGanttChart((String)"RT130 Report", (String)"Station", (String)"Time", (IntervalCategoryDataset)dataset, (boolean)false, (boolean)false, (boolean)false);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        CategoryItemRenderer renderer = plot.getRenderer();
        renderer.setSeriesPaint(0, (Paint)Color.PINK);
        renderer.setOutlinePaint((Paint)Color.BLACK);
        this.printChartToPDF(chart, 1024, 768, "RT130Report.pdf");
    }

    private void printChartToPDF(JFreeChart chart, int width, int height, String fileName) {
        try {
            Document document = new Document(new Rectangle((float)width, (float)height));
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(fileName));
            document.addAuthor("University of South Carolina, United States of America, Geological Sciences");
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            PdfTemplate tp = cb.createTemplate((float)width, (float)height);
            Graphics2D g2 = tp.createGraphics((float)width, (float)height, (FontMapper)new DefaultFontMapper());
            Rectangle2D.Double rectangle2D = new Rectangle2D.Double(0.0, 0.0, width, height);
            chart.draw(g2, (Rectangle2D)rectangle2D);
            g2.dispose();
            cb.addTemplate(tp, 0.0f, 0.0f);
            document.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printReport() {
        FileWriter report = null;
        try {
            report = new FileWriter("RT130Report.txt");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PrintWriter reportStream = new PrintWriter(report);
        reportStream.println("Report");
        reportStream.println("-------");
        reportStream.println("  Number of stations read: " + this.getNumStations());
        reportStream.println("  Number of channels read: " + this.getNumChannels());
        reportStream.println("  Number of channels read with incontiguous data: " + this.getNumIncontiguousChannels());
        reportStream.println();
        reportStream.println("SAC Files");
        reportStream.println("----------");
        reportStream.println("  Number of files read: " + this.getNumSacFiles());
        reportStream.println();
        reportStream.println("MSEED Files");
        reportStream.println("------------");
        reportStream.println("  Number of files read: " + this.getNumMSeedFiles());
        reportStream.println();
        reportStream.println("RT130 Files");
        reportStream.println("------------");
        reportStream.println("  Days Of Coverage");
        reportStream.println("  -----------------");
        this.printRefTekDaysOfCoverage(reportStream);
        reportStream.println("  Gap Description");
        reportStream.println("  ----------------");
        this.printRefTekGapDescription(reportStream);
        reportStream.println();
        reportStream.println("Problem Files");
        reportStream.println("--------------");
        this.printProblemFiles(reportStream);
        reportStream.close();
        try {
            report.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addProblemFile(String fileLoc, String problemDescription) {
        this.problemFiles.put(fileLoc, problemDescription);
    }

    public int getNumStations() {
        int numStations = 0;
        HashSet<String> stations = new HashSet<String>();
        Iterator it = this.channelIdWithTime.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            stations.add(StationIdUtil.toString((StationId)((Channel)this.channelIdToChannel.get((Object)key)).my_site.my_station.get_id()));
        }
        numStations = stations.size();
        return numStations;
    }

    public int getNumChannels() {
        return this.channelIdWithTime.keySet().size();
    }

    public int getNumIncontiguousChannels() {
        int numIncontiguousChannels = 0;
        HashSet<String> incontiguousChannels = new HashSet<String>();
        Iterator it = this.channelIdWithTime.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (((List)this.channelIdWithTime.get(key)).size() <= 1) continue;
            incontiguousChannels.add(key);
        }
        numIncontiguousChannels = incontiguousChannels.size();
        return numIncontiguousChannels;
    }

    public int getNumSacFiles() {
        return this.numSacFiles;
    }

    public int getNumMSeedFiles() {
        return this.numMSeedFiles;
    }

    private void printProblemFiles(PrintWriter reportStream) {
        Iterator it = this.problemFiles.keySet().iterator();
        if (!it.hasNext()) {
            reportStream.println("No problem files.");
        }
        while (it.hasNext()) {
            String key = (String)it.next();
            reportStream.println("  " + key);
            reportStream.println("  " + this.problemFiles.get(key));
            reportStream.println();
        }
    }

    private void printRefTekGapDescription(PrintWriter reportStream) {
        if (this.reportFactory == null) {
            this.reportFactory = new RT130ReportFactory(this.channelIdWithTime, this.channelIdToChannel);
        }
        this.reportFactory.printGapDescription(reportStream);
    }

    private void printRefTekDaysOfCoverage(PrintWriter reportStream) {
        if (this.reportFactory == null) {
            this.reportFactory = new RT130ReportFactory(this.channelIdWithTime, this.channelIdToChannel);
        }
        this.reportFactory.printDaysOfCoverage(reportStream);
    }

    private String getIdString(Channel chan) {
        if (!this.channelToIDString.containsKey(chan)) {
            this.channelToIDString.put(chan, ChannelIdUtil.toString((ChannelId)chan.get_id()));
        }
        return (String)this.channelToIDString.get(chan);
    }
}

