/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database.seismogram;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.sc.seis.fissuresUtil.database.seismogram.StationDataSummary;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class RT130ReportFactory {
    private List stationDataSummaryList = new LinkedList();

    public RT130ReportFactory(Map channelIdWithTimeRanges, Map channelIdToChannel) {
        this.organizeByStationCode(channelIdWithTimeRanges, channelIdToChannel);
    }

    public void printGapDescription(PrintWriter reportStream) {
        Collections.sort(this.stationDataSummaryList);
        Iterator it = this.stationDataSummaryList.iterator();
        while (it.hasNext()) {
            ((StationDataSummary)it.next()).printGapDescription(reportStream);
            reportStream.println();
        }
    }

    public void printDaysOfCoverage(PrintWriter reportStream) {
        Collections.sort(this.stationDataSummaryList);
        Iterator it = this.stationDataSummaryList.iterator();
        while (it.hasNext()) {
            ((StationDataSummary)it.next()).printDaysOfCoverage(reportStream);
            reportStream.println();
        }
    }

    public List getStationCodes() {
        LinkedList<String> stationCodes = new LinkedList<String>();
        Iterator it = this.stationDataSummaryList.iterator();
        while (it.hasNext()) {
            stationCodes.add(((StationDataSummary)it.next()).getStationCode());
        }
        return stationCodes;
    }

    public List getStationDataSummaryList() {
        return this.stationDataSummaryList;
    }

    public List getSortedStationDataSummaryList() {
        Collections.sort(this.stationDataSummaryList);
        return this.stationDataSummaryList;
    }

    private void organizeByStationCode(Map channelIdWithTimeRanges, Map channelIdToChannel) {
        HashSet<String> stationCodes = new HashSet<String>();
        Iterator it = channelIdWithTimeRanges.keySet().iterator();
        while (it.hasNext()) {
            stationCodes.add(((Channel)channelIdToChannel.get((Object)((String)it.next()))).my_site.my_station.get_code());
        }
        Iterator jt = stationCodes.iterator();
        while (jt.hasNext()) {
            String setStationCode = (String)jt.next();
            HashMap<String, List> channelCodesWithTimeRanges = new HashMap<String, List>();
            Iterator kt = channelIdWithTimeRanges.keySet().iterator();
            while (kt.hasNext()) {
                String channelIdKey = (String)kt.next();
                String stationCode = ((Channel)channelIdToChannel.get((Object)channelIdKey)).my_site.my_station.get_code();
                if (!stationCode.equals(setStationCode)) continue;
                String channelCode = ((Channel)channelIdToChannel.get(channelIdKey)).get_code();
                List timeRanges = (List)channelIdWithTimeRanges.get(channelIdKey);
                channelCodesWithTimeRanges.put(channelCode, timeRanges);
            }
            StationDataSummary temp = new StationDataSummary(setStationCode, channelCodesWithTimeRanges);
            this.stationDataSummaryList.add(temp);
        }
    }
}

