/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database.seismogram;

import edu.sc.seis.fissuresUtil.database.ConnectionCreator;
import edu.sc.seis.fissuresUtil.database.seismogram.JDBCSeismogramFiles;
import edu.sc.seis.fissuresUtil.simple.Initializer;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.log4j.BasicConfigurator;

public class StationNamePopulator {
    public static void main(String[] args) throws SQLException, IOException {
        int i;
        BasicConfigurator.configure();
        Properties props = Initializer.loadProperties(args);
        ConnectionCreator connCreator = new ConnectionCreator(props);
        Connection conn = connCreator.createConnection();
        JDBCSeismogramFiles jdbcSeisFile = new JDBCSeismogramFiles(conn);
        boolean verbose = false;
        for (i = 1; i < args.length; ++i) {
            if (!args[i].equals("-h")) continue;
            StationNamePopulator.printHelp();
        }
        for (i = 1; i < args.length; ++i) {
            if (!args[i].equals("-v")) continue;
            verbose = true;
            System.out.println();
            System.out.println("/---------------Station Code Updater---");
            System.out.println();
            System.out.println("Verbose messages: ON");
        }
        for (i = 1; i < args.length - 1; ++i) {
            if (!verbose || !args[i].equals("-props")) continue;
            String propFileLocation = args[i + 1];
            File file = new File(propFileLocation);
            System.out.println("Properties file location: " + file.getCanonicalPath());
        }
        if (verbose) {
            System.out.println();
            System.out.println("\\------------------------------------");
        }
        if (args.length > 2) {
            jdbcSeisFile.populateStationName();
        } else {
            StationNamePopulator.printHelp();
        }
    }

    private static void printHelp() {
        System.out.println();
        System.out.println("    No arguments are needed.");
        System.out.println("    The default database properties file is server.properties.");
        System.out.println();
        System.out.println("    -props   | Accepts alternate database properties file");
        System.out.println("                Use the same prop file used for DB population");
        System.out.println("    -v       | Turn verbose messages on");
        System.out.println();
        System.out.println();
        System.out.println("Program finished before database population was completed.");
        System.out.println();
    }
}

