/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfEvent.EventAttr;
import edu.iris.Fissures.IfEvent.Magnitude;
import edu.iris.Fissures.IfEvent.NoPreferredOrigin;
import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.model.ISOTime;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.NoSuchLayerException;
import edu.sc.seis.TauP.NoSuchMatPropException;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.VelocityModel;
import edu.sc.seis.fissuresUtil.bag.TauPUtil;
import edu.sc.seis.fissuresUtil.display.ParseRegions;
import edu.sc.seis.fissuresUtil.display.TextInfoDisplay;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.apache.log4j.Logger;

public class EventInfoDisplay
extends TextInfoDisplay {
    static ParseRegions feRegions = ParseRegions.getInstance();
    TauPUtil taup;
    DecimalFormat twoDecimal = new DecimalFormat("0.00");
    SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd, yyyy HH:mm:ss.S z");
    static Logger logger = Logger.getLogger((Class)EventInfoDisplay.class);

    public EventInfoDisplay() {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.taup = TauPUtil.getTauPUtil();
    }

    public void displayEvent(EventAccessOperations event) {
        this.displayEventStation(event, null);
    }

    public void displayEventStation(EventAccessOperations event, Station[] station) {
        Document doc = this.textPane.getDocument();
        try {
            doc.remove(0, doc.getLength());
            this.appendEvent(event, doc);
            if (station != null) {
                this.appendEventStation(event, station, doc);
            }
            this.toTop();
        }
        catch (BadLocationException ble) {
            System.err.println("Couldn't insert message.");
        }
    }

    public void appendEvent(EventAccessOperations event) {
        try {
            this.appendEvent(event, this.getDocument());
        }
        catch (BadLocationException ble) {
            System.err.println("Couldn't insert message.");
        }
    }

    public void appendEventStation(EventAccessOperations event, Station[] station) {
        try {
            Document doc = this.getDocument();
            this.appendEvent(event, doc);
            this.appendEventStation(event, station, this.getDocument());
        }
        catch (BadLocationException ble) {
            System.err.println("Couldn't insert message.");
        }
    }

    protected void appendEvent(EventAccessOperations event, Document doc) throws BadLocationException {
        if (event != null) {
            this.appendEventAttr(event.get_attributes(), doc);
            try {
                this.appendOrigin(event.get_preferred_origin(), doc);
            }
            catch (NoPreferredOrigin noPreferredOrigin) {}
        } else {
            this.appendLine(doc, "No earthquake to display.");
        }
    }

    protected void appendEventStation(EventAccessOperations event, Station[] station, Document doc) throws BadLocationException {
        SphericalCoords sph = new SphericalCoords();
        try {
            station = EventInfoDisplay.sortStationsByDistance(station, event, sph);
        }
        catch (Exception e) {
            GlobalExceptionHandler.handle("Problem sorting stations by distance", e);
        }
        String[] stationNames = new String[station.length + 1];
        stationNames[0] = "Station Name";
        int longest = stationNames[0].length();
        for (int i = 0; i < station.length; ++i) {
            stationNames[i + 1] = station[i].name;
            if (stationNames[i + 1].length() <= longest) continue;
            longest = stationNames[i + 1].length();
        }
        this.appendLine(doc, "");
        this.appendHeader(doc, "Event to Station");
        double dist = -1.0;
        double baz = -1.0;
        double az = -1.0;
        this.appendLabelValue(doc, EventInfoDisplay.printTextLine(' ', longest), "\t\t\t\t\tAzimuth\tAzimuth\tFirst P\tFirst P\t");
        this.appendLabelValue(doc, stationNames[0] + EventInfoDisplay.printTextLine(' ', longest - stationNames[0].length()), "\t Lat\tLong\tDist\t Dist\t  to\t from\ttakeoff\tray");
        this.appendLabelValue(doc, EventInfoDisplay.printTextLine(' ', longest), "\t\t\t\t\t Event\t Event\tangle\tparam");
        this.appendLabelValue(doc, EventInfoDisplay.printTextLine(' ', longest), "\t(deg)\t(deg)\t(deg)\t (km)\t (deg)\t (deg)\t(deg)\t(s/deg)");
        this.appendLabelValue(doc, EventInfoDisplay.printTextLine('-', longest), "---------------------------------------------------------------------------------");
        for (int i = 0; i < station.length; ++i) {
            try {
                if (event != null) {
                    Origin origin = event.get_preferred_origin();
                    dist = SphericalCoords.distance((double)origin.my_location.latitude, (double)origin.my_location.longitude, (double)station[i].my_location.latitude, (double)station[i].my_location.longitude);
                    baz = SphericalCoords.azimuth((double)station[i].my_location.latitude, (double)station[i].my_location.longitude, (double)origin.my_location.latitude, (double)origin.my_location.longitude);
                    az = SphericalCoords.azimuth((double)origin.my_location.latitude, (double)origin.my_location.longitude, (double)station[i].my_location.latitude, (double)station[i].my_location.longitude);
                    String firstPTakeoff = "";
                    String firstPRayParam = "";
                    try {
                        Arrival[] a = this.taup.calcTravelTimes(station[i], origin, new String[]{"ttp"});
                        if (a.length > 0) {
                            firstPRayParam = this.twoDecimal.format(a[0].getRayParam() * Math.PI / 180.0);
                            double originDepth = QuantityImpl.createQuantityImpl((Quantity)origin.my_location.depth).convertTo(UnitImpl.KILOMETER).get_value();
                            VelocityModel vmod = this.taup.getTauModel().getVelocityModel();
                            firstPTakeoff = this.twoDecimal.format(57.29577951308232 * Math.asin(a[0].getRayParam() * vmod.evaluateBelow(originDepth, 'P') / (vmod.getRadiusOfEarth() - originDepth)));
                        }
                    }
                    catch (TauModelException e) {
                        GlobalExceptionHandler.handle("Trouble calculating travel times for " + station[i].get_code() + " " + event.get_attributes().name, e);
                    }
                    catch (NoSuchLayerException e) {
                        GlobalExceptionHandler.handle("Trouble calculating travel times for " + station[i].get_code() + " " + event.get_attributes().name, e);
                    }
                    catch (NoSuchMatPropException e) {
                        GlobalExceptionHandler.handle("Trouble calculating travel times for " + station[i].get_code() + " " + event.get_attributes().name, e);
                    }
                    this.appendLabelValue(doc, stationNames[i + 1] + EventInfoDisplay.printTextLine(' ', longest - stationNames[i + 1].length()), '\t' + this.twoDecimal.format(station[i].my_location.latitude) + '\t' + this.twoDecimal.format(station[i].my_location.longitude) + '\t' + this.twoDecimal.format(dist) + '\t' + this.twoDecimal.format(dist * 111.19) + '\t' + this.twoDecimal.format(baz) + '\t' + this.twoDecimal.format(az) + '\t' + firstPTakeoff + '\t' + firstPRayParam + '\t');
                    continue;
                }
                this.appendLabelValue(doc, stationNames[i + 1] + EventInfoDisplay.printTextLine(' ', longest - stationNames[i + 1].length()), this.twoDecimal.format(station[i].my_location.latitude) + " " + this.twoDecimal.format(station[i].my_location.longitude) + "--- ,  ---");
                continue;
            }
            catch (NoPreferredOrigin e) {
                this.appendLabelValue(doc, station[i].get_code(), this.twoDecimal.format(station[i].my_location.latitude) + " " + this.twoDecimal.format(station[i].my_location.longitude) + "--- ,  ---");
            }
        }
        this.appendLine(doc, "");
    }

    protected void appendEventAttr(EventAttr attr) throws BadLocationException {
        this.appendEventAttr(attr, this.getDocument());
    }

    protected void appendEventAttr(EventAttr attr, Document doc) throws BadLocationException {
        this.appendHeader(doc, "Event");
        this.appendLabelValue(doc, "Name\t", attr.name);
        if (attr.region.number > 0) {
            this.appendLabelValue(doc, "Region\t", feRegions.getRegionName(attr.region) + " (" + attr.region.number + ")");
        } else {
            this.appendLabelValue(doc, "Region\t", "Unknown (" + attr.region.number + ")");
        }
        this.appendLine(doc, "");
    }

    protected void appendOrigin(Origin origin) throws BadLocationException {
        this.appendOrigin(origin, this.getDocument());
    }

    protected void appendOrigin(Origin origin, Document doc) throws BadLocationException {
        this.appendHeader(doc, "Origin");
        this.appendLabelValue(doc, "Location\t", "latitude=" + this.twoDecimal.format(origin.my_location.latitude) + ",  longitude=" + this.twoDecimal.format(origin.my_location.longitude));
        MicroSecondDate oTime = new ISOTime(origin.origin_time.date_time).getDate();
        this.appendLabelValue(doc, "Time\t", this.dateFormat.format((Date)oTime));
        QuantityImpl depth = (QuantityImpl)origin.my_location.depth;
        depth = depth.convertTo(UnitImpl.KILOMETER);
        this.appendLabelValue(doc, "Depth\t", this.twoDecimal.format(depth.value) + " kilometers");
        this.appendLine(doc, "");
        for (int i = 0; i < origin.magnitudes.length; ++i) {
            this.appendMagnitude(origin.magnitudes[i], doc);
        }
    }

    protected void appendMagnitude(Magnitude mag) throws BadLocationException {
        this.appendMagnitude(mag, this.getDocument());
    }

    protected void appendMagnitude(Magnitude mag, Document doc) throws BadLocationException {
        this.appendLabelValue(doc, "Magnitude\t", mag.value + " " + mag.type + "  " + mag.contributor);
    }

    public static Magnitude getBestForDisplay(Magnitude[] mags) {
        if (mags == null || mags.length == 0) {
            logger.warn((Object)"mag array must not be empty");
            return null;
        }
        for (int i = 0; i < mags.length; ++i) {
            if (!mags[i].type.equalsIgnoreCase("mw")) continue;
            return mags[i];
        }
        return mags[0];
    }

    public static Station[] sortStationsByDistance(Station[] stations, EventAccessOperations event, SphericalCoords sph) throws NoPreferredOrigin {
        try {
            Station[] temp = new Station[stations.length];
            System.arraycopy(stations, 0, temp, 0, stations.length);
            for (int i = 0; i < temp.length - 1; ++i) {
                int indexOfNextSmallest = EventInfoDisplay.indexOfClosestStation(temp, i, event, sph);
                EventInfoDisplay.interchange(i, indexOfNextSmallest, temp);
            }
            return temp;
        }
        catch (NoPreferredOrigin n) {
            logger.warn((Object)"Stations not sorted because event has no origin.");
            return stations;
        }
    }

    public static String printTextLine(char c, int length) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            buf.append(c);
        }
        return buf.toString();
    }

    public static void interchange(int i, int j, Station[] s) {
        Station temp = s[i];
        s[i] = s[j];
        s[j] = temp;
    }

    public static int indexOfClosestStation(Station[] stations, int startIndex, EventAccessOperations event, SphericalCoords sph) throws NoPreferredOrigin {
        int index = startIndex;
        double currentDistance = Double.POSITIVE_INFINITY;
        double closestDistance = Double.POSITIVE_INFINITY;
        for (int i = startIndex; i < stations.length; ++i) {
            Station currentStation = stations[i];
            currentDistance = SphericalCoords.distance((double)event.get_preferred_origin().my_location.latitude, (double)event.get_preferred_origin().my_location.longitude, (double)currentStation.my_location.latitude, (double)currentStation.my_location.longitude);
            if (!(currentDistance < closestDistance)) continue;
            closestDistance = currentDistance;
            index = i;
        }
        return index;
    }
}

