/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.Instrumentation;
import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.Site;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.network.ResponsePrint;
import edu.sc.seis.fissuresUtil.display.TextInfoDisplay;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class NetInfoDisplay
extends TextInfoDisplay {
    public void displayNetwork(NetworkAttr attr) {
        Document doc = this.textPane.getDocument();
        try {
            doc.remove(0, doc.getLength());
            this.appendNetwork(attr, doc);
            this.toTop();
        }
        catch (BadLocationException ble) {
            System.err.println("Couldn't insert message.");
        }
    }

    protected void appendNetwork(NetworkAttr attr) throws BadLocationException {
        this.appendNetwork(attr, this.textPane.getDocument());
    }

    protected void appendNetwork(NetworkAttr attr, Document doc) throws BadLocationException {
        this.appendHeader(doc, "Network");
        this.appendLabelValue(doc, "Code", attr.get_code());
        this.appendLabelValue(doc, "Name", attr.name);
        this.appendLabelValue(doc, "Description", attr.description);
        this.appendLabelValue(doc, "Owner", attr.owner);
        this.appendLabelValue(doc, "Begin", attr.effective_time.start_time.date_time);
        this.appendLabelValue(doc, "End", attr.effective_time.end_time.date_time);
        this.appendLine(doc, "");
    }

    public void displayStation(Station sta) {
        Document doc = this.textPane.getDocument();
        try {
            doc.remove(0, doc.getLength());
            this.appendNetwork(sta.my_network, doc);
            this.appendStation(sta, doc);
            this.toTop();
        }
        catch (BadLocationException ble) {
            System.err.println("Couldn't insert message.");
        }
    }

    protected void appendStation(Station sta) throws BadLocationException {
        this.appendStation(sta, this.textPane.getDocument());
    }

    protected void appendStation(Station sta, Document doc) throws BadLocationException {
        this.appendHeader(doc, "Station");
        this.appendLabelValue(doc, "Code", sta.get_id().station_code);
        this.appendLabelValue(doc, "Name", sta.name);
        this.appendLabelValue(doc, "Location", "(" + sta.my_location.latitude + ", " + sta.my_location.longitude + ")");
        this.appendLabelValue(doc, "Begin", sta.effective_time.start_time.date_time);
        this.appendLabelValue(doc, "End", sta.effective_time.end_time.date_time);
        this.appendLabelValue(doc, "Operator", sta.operator);
        this.appendLabelValue(doc, "Description", sta.description);
        this.appendLabelValue(doc, "Comment", sta.comment);
        this.appendLine(doc, "");
    }

    public void displaySite(Site site) {
        Document doc = this.textPane.getDocument();
        try {
            doc.remove(0, doc.getLength());
            this.appendNetwork(site.my_station.my_network, doc);
            this.appendStation(site.my_station, doc);
            this.appendSite(site, doc);
            this.toTop();
        }
        catch (BadLocationException ble) {
            System.err.println("Couldn't insert message.");
        }
    }

    protected void appendSite(Site site) throws BadLocationException {
        this.appendSite(site, this.textPane.getDocument());
    }

    protected void appendSite(Site site, Document doc) throws BadLocationException {
        this.appendHeader(doc, "Site");
        this.appendLabelValue(doc, "Location", "(" + site.my_location.latitude + ", " + site.my_location.longitude + ")");
        this.appendLabelValue(doc, "Begin", site.effective_time.start_time.date_time);
        this.appendLabelValue(doc, "End", site.effective_time.end_time.date_time);
        this.appendLabelValue(doc, "Comment", site.comment);
        this.appendLine(doc, "");
    }

    public void displayChannel(Channel chan) {
        Document doc = this.textPane.getDocument();
        try {
            doc.remove(0, doc.getLength());
            this.appendNetwork(chan.my_site.my_station.my_network, doc);
            this.appendStation(chan.my_site.my_station, doc);
            this.appendSite(chan.my_site, doc);
            this.appendChannel(chan, doc);
            this.toTop();
        }
        catch (BadLocationException ble) {
            System.err.println("Couldn't insert message.");
        }
    }

    protected void appendChannel(Channel chan) throws BadLocationException {
        this.appendChannel(chan, this.textPane.getDocument());
    }

    protected void appendChannel(Channel chan, Document doc) throws BadLocationException {
        this.appendHeader(doc, "Channel");
        this.appendLabelValue(doc, "Chan Code", chan.get_code());
        this.appendLabelValue(doc, "Orientation", "(" + chan.an_orientation.azimuth + ", " + chan.an_orientation.dip + ")");
        if (chan.sampling_info != null) {
            this.appendLabelValue(doc, "Sampling", chan.sampling_info.numPoints + " points in " + chan.sampling_info.interval.toString());
        } else {
            this.appendLabelValue(doc, "Sampling", "null value");
        }
        this.appendLabelValue(doc, "Begin", chan.effective_time.start_time.date_time);
        this.appendLabelValue(doc, "End", chan.effective_time.end_time.date_time);
        this.appendLine(doc, "");
    }

    public void displayResponse(ChannelId chan, Instrumentation inst) {
        Document doc = this.textPane.getDocument();
        try {
            doc.remove(0, doc.getLength());
            doc.insertString(doc.getLength(), ResponsePrint.printResponse((ChannelId)chan, (Instrumentation)inst), this.textPane.getStyle("response"));
            this.toTop();
        }
        catch (BadLocationException ble) {
            System.err.println("Couldn't insert message.");
        }
    }
}

