/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import edu.sc.seis.fissuresUtil.display.BorderedDisplay;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplayListener;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplayProvider;
import edu.sc.seis.fissuresUtil.display.SeismogramPDFBuilder;
import edu.sc.seis.fissuresUtil.display.drawable.Drawable;
import edu.sc.seis.fissuresUtil.display.drawable.DrawableIterator;
import edu.sc.seis.fissuresUtil.display.drawable.DrawableSeismogram;
import edu.sc.seis.fissuresUtil.display.drawable.Selection;
import edu.sc.seis.fissuresUtil.display.mouse.SDMouseForwarder;
import edu.sc.seis.fissuresUtil.display.mouse.SDMouseMotionForwarder;
import edu.sc.seis.fissuresUtil.display.registrar.AmpConfig;
import edu.sc.seis.fissuresUtil.display.registrar.DataSetSeismogramReceptacle;
import edu.sc.seis.fissuresUtil.display.registrar.TimeConfig;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class SeismogramDisplay
extends BorderedDisplay
implements DataSetSeismogramReceptacle {
    private static final long TWO_MIN = 120000L;
    private int pdfSeismogramsPerPage = 1;
    private int i = 0;
    private static SDMouseMotionForwarder motionForwarder;
    private static SDMouseForwarder mouseForwarder;
    private List listeners = new ArrayList();
    private static boolean currentTimeFlag;
    protected static Set activeFilters;
    private Color[] colors;
    protected boolean drawNamesForNamedDrawables = true;
    public static final Color[] COLORS;
    private Map classToColor = new HashMap();
    private static final Logger logger;
    public static boolean PRINTING;

    public SeismogramDisplay() {
        this(mouseForwarder, motionForwarder);
    }

    public SeismogramDisplay(SDMouseForwarder mf, SDMouseMotionForwarder mmf) {
        mouseForwarder = mf;
        motionForwarder = mmf;
        if (mouseForwarder == null || motionForwarder == null) {
            mouseForwarder = new SDMouseForwarder();
            motionForwarder = new SDMouseMotionForwarder();
        }
        this.add(this.createCenter(), 4);
        this.colors = COLORS;
    }

    public void add(SeismogramDisplayListener listener) {
        this.listeners.add(listener);
    }

    public void remove(SeismogramDisplayListener listener) {
        this.listeners.remove(listener);
    }

    public SeismogramDisplayProvider getCenter() {
        return (SeismogramDisplayProvider)this.get(4);
    }

    public abstract SeismogramDisplayProvider createCenter();

    public void renderToGraphics(Graphics2D g, Dimension size) {
        DrawableSeismogram cur;
        PRINTING = true;
        boolean allHere = false;
        long totalWait = 0L;
        DrawableIterator seisIt = this.iterator(DrawableSeismogram.class);
        while (seisIt.hasNext()) {
            cur = (DrawableSeismogram)seisIt.next();
            cur.addToTimeAndAmp();
            if (cur.getDataStatus() != "Trying to get data") continue;
            cur.getData();
            allHere = false;
        }
        while (!allHere && totalWait < 120000L) {
            seisIt = this.iterator(class$edu$sc$seis$fissuresUtil$display$drawable$DrawableSeismogram == null ? SeismogramDisplay.class$("edu.sc.seis.fissuresUtil.display.drawable.DrawableSeismogram") : class$edu$sc$seis$fissuresUtil$display$drawable$DrawableSeismogram);
            allHere = true;
            while (seisIt.hasNext()) {
                cur = (DrawableSeismogram)seisIt.next();
                if (cur.getDataStatus() != "Trying to get data") continue;
                try {
                    Thread.sleep(100L);
                    if ((totalWait += 100L) % 10000L == 0L && totalWait != 0L) {
                        logger.debug((Object)("Waiting for data to show before rendering.  We've waited " + totalWait + " millis"));
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                allHere = false;
            }
        }
        logger.debug((Object)("Rendering to graphics after waiting " + totalWait + " millis for data to arrive"));
        if (totalWait >= 120000L) {
            logger.debug((Object)"GAVE UP WAITING ON DATA TO RENDER TO GRAPHICS!  SOMEONE IS LYING OR REALLY REALLY SLOW! OR BOTH!!");
        }
        super.renderToGraphics(g, size);
        PRINTING = false;
    }

    public Color getColor() {
        return null;
    }

    public void setColors(Color[] colors) {
        this.colors = colors;
    }

    protected boolean hasConfiguredColors(Class class1) {
        return this.classToColor.containsKey(class1);
    }

    public void setColors(Class colorGroupClass, Color[] colors) {
        this.classToColor.put(colorGroupClass, colors);
    }

    public Color getNextColor(Class colorGroupClass) {
        Color[] classColors = this.colors;
        if (this.classToColor.containsKey(colorGroupClass)) {
            classColors = (Color[])this.classToColor.get(colorGroupClass);
        }
        int[] usages = new int[classColors.length];
        for (int i = 0; i < classColors.length; ++i) {
            DrawableIterator it = this.iterator(colorGroupClass);
            while (it.hasNext()) {
                Drawable cur = (Drawable)it.next();
                if (cur.getColor().equals(classColors[i])) {
                    int n = i;
                    usages[n] = usages[n] + 1;
                }
                if (!(cur instanceof DrawableSeismogram)) continue;
                DrawableSeismogram curSeis = (DrawableSeismogram)cur;
                DrawableIterator childIterator = curSeis.iterator(colorGroupClass);
                while (childIterator.hasNext()) {
                    Drawable curChild = (Drawable)childIterator.next();
                    if (!curChild.getColor().equals(classColors[i])) continue;
                    int n = i;
                    usages[n] = usages[n] + 1;
                }
            }
        }
        for (int minUsage = 0; minUsage >= 0; ++minUsage) {
            for (int i = 0; i < usages.length; ++i) {
                if (usages[i] != minUsage) continue;
                return classColors[i];
            }
        }
        return classColors[this.i++ % classColors.length];
    }

    public DrawableSeismogram getDrawableSeismogram(DataSetSeismogram ds) {
        DrawableIterator it = this.iterator(DrawableSeismogram.class);
        while (it.hasNext()) {
            DrawableSeismogram cur = (DrawableSeismogram)it.next();
            if (!cur.getSeismogram().equals(ds)) continue;
            return cur;
        }
        throw new IllegalArgumentException("The passed in data set seismgoram must have a drawable seismogram using it in this display");
    }

    public void outputToPDF(String filename) throws FileNotFoundException {
        this.outputToPDF(new File(filename));
    }

    public void outputToPDF(File f) throws FileNotFoundException {
        SeismogramPDFBuilder.createPDF(this, f, this.pdfSeismogramsPerPage, true);
    }

    public abstract void add(Drawable var1);

    public abstract void remove(Drawable var1);

    public abstract DrawableIterator getDrawables(MouseEvent var1);

    public abstract DrawableIterator iterator(Class var1);

    public abstract void setTimeConfig(TimeConfig var1);

    public abstract TimeConfig getTimeConfig();

    public abstract void setAmpConfig(AmpConfig var1);

    public abstract void setGlobalizedAmpConfig(AmpConfig var1);

    public abstract void setIndividualizedAmpConfig(AmpConfig var1);

    public abstract AmpConfig getAmpConfig();

    public abstract DataSetSeismogram[] getSeismograms();

    public abstract void print();

    public void remove(Selection selection) {
    }

    public static void setMouseMotionForwarder(SDMouseMotionForwarder mf) {
        motionForwarder = mf;
    }

    public static SDMouseMotionForwarder getMouseMotionForwarder() {
        return motionForwarder;
    }

    public static void setMouseForwarder(SDMouseForwarder mf) {
        mouseForwarder = mf;
    }

    public static SDMouseForwarder getMouseForwarder() {
        return mouseForwarder;
    }

    public static Set getActiveFilters() {
        return activeFilters;
    }

    public static void setCurrentTimeFlag(boolean visible) {
        currentTimeFlag = visible;
    }

    public static boolean getCurrentTimeFlag() {
        return currentTimeFlag;
    }

    public int getPdfSeismogramsPerPage() {
        return this.pdfSeismogramsPerPage;
    }

    public void setPdfSeismogramsPerPage(int pdfSeismogramsPerPage) {
        this.pdfSeismogramsPerPage = pdfSeismogramsPerPage;
    }

    public void setDrawNamesForNamedDrawables(boolean drawNamesForNamedDrawables) {
        this.drawNamesForNamedDrawables = drawNamesForNamedDrawables;
    }

    static {
        currentTimeFlag = false;
        activeFilters = new HashSet();
        COLORS = new Color[]{Color.BLUE, new Color(217, 91, 23), new Color(179, 182, 46), new Color(141, 18, 69), new Color(65, 200, 115), new Color(27, 36, 138), new Color(130, 145, 230), new Color(54, 72, 21), new Color(119, 17, 136)};
        logger = Logger.getLogger((Class)SeismogramDisplay.class);
        PRINTING = false;
    }
}

