/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class TextTable {
    protected int columns;
    private boolean hasHeader;
    private String[] header = null;
    protected List rows = new ArrayList();
    protected int[] widths;
    private static Logger logger = Logger.getLogger((Class)TextTable.class);

    public TextTable(int columns) {
        this(columns, false);
    }

    public TextTable(int columns, boolean hasHeader) {
        this.columns = columns;
        this.hasHeader = hasHeader;
        this.initColWidthArray();
    }

    public boolean containsHeader() {
        return this.hasHeader;
    }

    public void addRow(String tabDelimitedData) {
        this.addRow(tabDelimitedData, false);
    }

    public void addRow(String tabDelimetedData, boolean isHeader) {
        StringTokenizer tok = new StringTokenizer(tabDelimetedData, "\t");
        String[] data = new String[tok.countTokens()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = tok.nextToken();
        }
        this.addRow(data, isHeader);
    }

    public void addRow(String[] data) {
        this.addRow(data, false);
    }

    public void addRow(String[] data, boolean isHeader) {
        if (data.length > this.columns) {
            String[] tmp = new String[this.columns];
            System.arraycopy(data, 0, tmp, 0, this.columns);
            data = tmp;
        } else if (data.length < this.columns) {
            return;
        }
        if (isHeader) {
            this.header = data;
        } else {
            this.rows.add(data);
        }
        this.updateWidths(data);
    }

    private void updateWidths(String[] data) {
        for (int i = 0; i < this.columns; ++i) {
            if (data[i].length() <= this.widths[i]) continue;
            this.widths[i] = data[i].length();
        }
    }

    public void clear() {
        this.rows.clear();
        this.initColWidthArray();
        if (this.hasHeader && this.header != null) {
            this.updateWidths(this.header);
        }
    }

    public String toString(String delimeter) {
        StringBuffer buf = new StringBuffer();
        if (this.hasHeader) {
            String headerString = this.getRow(this.header, delimeter);
            buf.append(headerString);
            if (delimeter == null) {
                buf.append(this.getHeaderHyphens(headerString.length()));
            }
        }
        for (int i = 0; i < this.rows.size(); ++i) {
            buf.append(this.getRow((String[])this.rows.get(i), delimeter));
        }
        return buf.toString();
    }

    public String toString() {
        return this.toString(null);
    }

    private String getRow(String[] rowCells, String delimeter) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < rowCells.length; ++i) {
            buf.append(rowCells[i]);
            if (delimeter == null) {
                buf.append(this.fillInWithSpaces(rowCells[i], i));
                continue;
            }
            if (i >= rowCells.length - 1) continue;
            buf.append(delimeter);
        }
        buf.append('\n');
        return buf.toString();
    }

    private String getHeaderHyphens(int length) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            buf.append('-');
        }
        buf.append('\n');
        return buf.toString();
    }

    private void initColWidthArray() {
        this.widths = new int[this.columns];
        for (int i = 0; i < this.columns; ++i) {
            this.widths[i] = 0;
        }
    }

    private int calculateTabs(int colWidth, int cellLength) {
        int space = colWidth - cellLength;
        int tab = 3;
        int numTabs = space / tab;
        if (numTabs < 0) {
            numTabs = 0;
        }
        if (space % tab == 0) {
            ++numTabs;
        }
        return numTabs;
    }

    private String fillInWithSpaces(String cellValue, int column) {
        StringBuffer buf = new StringBuffer();
        int width = this.widths[column];
        int numSpaces = width - cellValue.length() + 3;
        for (int i = 0; i < numSpaces; ++i) {
            buf.append(' ');
        }
        return buf.toString();
    }

    public TextTable join(TextTable table) {
        if (table.columns != this.columns) {
            return table;
        }
        this.rows.addAll(table.rows);
        for (int i = 0; i < this.columns; ++i) {
            if (table.widths[i] <= this.widths[i]) continue;
            this.widths[i] = table.widths[i];
        }
        return this;
    }

    public void printTableStats() {
        System.out.println("Column widths:");
        for (int i = 0; i < this.widths.length; ++i) {
            System.out.println(i + ": " + this.widths[i]);
        }
    }

    public int numRows() {
        return this.rows.size();
    }

    public int numColumns() {
        return this.columns;
    }
}

