/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.model.UnitRangeImpl;
import edu.sc.seis.fissuresUtil.display.AmpScaleMapper;
import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.display.ScaleMapper;
import edu.sc.seis.fissuresUtil.display.SimplePlotUtil;
import java.text.DecimalFormat;
import org.apache.log4j.Logger;

public class UnitRangeMapper
implements ScaleMapper {
    private int firstMajorTick = 0;
    private int majorTickStep = 10;
    private double tickInc;
    private double minTick;
    private double calcRange;
    private int numTicks = 0;
    private int totalPixels;
    private int hintPixels;
    private UnitRangeImpl range = DisplayUtils.ONE_RANGE;
    private final boolean ascending;
    static Logger logger = Logger.getLogger((Class)AmpScaleMapper.class);

    public UnitRangeMapper(int totalPixels, int hintPixels, boolean ascending) {
        this.totalPixels = totalPixels;
        this.hintPixels = hintPixels;
        this.ascending = ascending;
    }

    public int getPixelLocation(int i) {
        if (this.ascending) {
            return (int)Math.round(SimplePlotUtil.linearInterp(this.minTick, 0.0, this.calcRange, this.totalPixels, this.minTick + (double)i * this.tickInc));
        }
        return (int)Math.round(SimplePlotUtil.linearInterp(this.minTick, 0.0, this.calcRange, this.totalPixels, this.minTick + (double)(this.numTicks - i) * this.tickInc));
    }

    public String getLabel(int i) {
        if (this.isLabelTick(i)) {
            double absValue;
            double value = this.minTick + (double)i * this.tickInc;
            if (this.range.getUnit().equals((Object)UnitImpl.DEGREE)) {
                value %= 360.0;
            }
            DecimalFormat df = (absValue = Math.abs(value)) < 10.0 && absValue != 0.0 ? new DecimalFormat("0.00###") : new DecimalFormat("#.####");
            return df.format(value);
        }
        return "";
    }

    public String getAxisLabel() {
        return "";
    }

    public UnitImpl getUnit() {
        return this.range.getUnit();
    }

    public int getNumTicks() {
        return this.numTicks;
    }

    public boolean isMajorTick(int i) {
        return i % this.majorTickStep == this.firstMajorTick;
    }

    public boolean isLabelTick(int i) {
        return i % (2 * this.majorTickStep) == this.firstMajorTick;
    }

    protected void calculateTicks() {
        if (this.totalPixels == 0) {
            this.numTicks = 0;
            return;
        }
        double rangeWidth = this.range.getMaxValue() - this.range.getMinValue();
        if (rangeWidth == 0.0 || rangeWidth == Double.NaN) {
            this.numTicks = 0;
            return;
        }
        this.tickInc = Math.pow(10.0, Math.ceil(Math.log(rangeWidth) / Math.log(10.0)));
        double goalTickInc = rangeWidth / (double)this.totalPixels * (double)this.hintPixels;
        this.majorTickStep = 10;
        if (this.tickInc >= 8.0 * goalTickInc) {
            this.tickInc /= 10.0;
        }
        if (this.tickInc >= 4.0 * goalTickInc) {
            this.tickInc /= 4.0;
            this.majorTickStep = 4;
        }
        if (this.tickInc >= 2.0 * goalTickInc) {
            this.tickInc /= 2.0;
            this.majorTickStep = 2;
        }
        this.minTick = this.tickInc * Math.floor(this.range.getMinValue() / this.tickInc);
        double minMajorTick = (double)this.majorTickStep * this.tickInc * Math.floor(this.range.getMinValue() / ((double)this.majorTickStep * this.tickInc));
        this.firstMajorTick = (int)Math.round((this.minTick - minMajorTick) / this.tickInc);
        if (this.firstMajorTick < 0) {
            this.firstMajorTick += this.majorTickStep;
        }
        this.numTicks = 1;
        while (this.minTick + (double)this.numTicks * this.tickInc <= this.range.getMaxValue()) {
            ++this.numTicks;
        }
        this.calcRange = this.tickInc * (double)this.numTicks + this.minTick;
    }

    public void setTotalPixels(int p) {
        this.totalPixels = p;
        this.calculateTicks();
    }

    public int getTotalPixels() {
        return this.totalPixels;
    }

    public void setUnitRange(UnitRangeImpl r) {
        this.range = r;
        this.calculateTicks();
    }
}

