/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.borders;

import edu.iris.Fissures.model.UnitRangeImpl;
import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.display.borders.SelfDrawableTitleProvider;
import edu.sc.seis.fissuresUtil.display.borders.TitleProvider;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;

public abstract class Border
extends JComponent {
    private List titles = new ArrayList();
    protected List borderFormats;
    protected int side;
    protected int direction;
    protected int order;
    protected int labelTickHeight;
    protected int labelTickWidth;
    protected int tickHeight;
    protected int tickWidth;
    protected int type;
    protected double minTickValue = Double.NEGATIVE_INFINITY;
    protected double maxTickValue = Double.POSITIVE_INFINITY;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int TOP = 2;
    public static final int BOTTOM = 3;
    public static final int ASCENDING = 0;
    public static final int DESCENDING = 4;
    protected static final int VERTICAL = 0;
    protected static final int HORIZONTAL = 1;
    protected int tickPad = 3;
    protected int labelTickLength = 10;
    protected int tickLength = 4;
    protected Color color = Color.BLACK;

    public Border(int side, int order) {
        this.setSide(side);
        this.setOrder(order);
        this.borderFormats = this.createFormats();
    }

    public void setTitleAndTickColor(Color c) {
        this.color = c;
    }

    public void setOrder(int o) {
        this.order = o;
    }

    public void setSide(int s) {
        this.side = s;
        if (this.tickLength == 0 && this.labelTickLength == 0) {
            this.tickHeight = 0;
            this.tickWidth = 0;
            this.labelTickHeight = 0;
            this.labelTickWidth = 0;
        } else if (this.side == 2) {
            this.labelTickHeight = -this.labelTickLength;
            this.tickHeight = -this.tickLength;
        } else if (this.side == 3) {
            this.labelTickHeight = this.labelTickLength;
            this.tickHeight = this.tickLength;
        } else if (this.side == 1) {
            this.labelTickWidth = this.labelTickLength;
            this.tickWidth = this.tickLength;
        } else if (this.side == 0) {
            this.labelTickWidth = -this.labelTickLength;
            this.tickWidth = -this.tickLength;
        } else {
            throw new IllegalArgumentException("side must be LEFT, RIGHT, BOTTOM, or TOP as defined in Border");
        }
        if (this.side == 0 || this.side == 1) {
            this.direction = 0;
            this.labelTickHeight = 0;
            this.tickHeight = 0;
        } else {
            this.direction = 1;
            this.labelTickWidth = 0;
            this.tickWidth = 0;
        }
        this.fixSize();
    }

    public void setClipTicks(double minTickVal, double maxTickVal) {
        this.minTickValue = minTickVal;
        this.maxTickValue = maxTickVal;
    }

    public abstract String getMaxLengthFormattedString();

    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g.setColor(this.getBackground());
        g2d.fillRect(0, 0, this.getSize().width, this.getSize().height);
        this.paintBorder(g2d);
    }

    protected void paintBorder(Graphics2D g2d) {
        BorderFormat bf = this.getFormat(g2d);
        if (bf != null) {
            bf.draw(this.getRange(), g2d);
        }
    }

    public BorderFormat getFormat(Graphics2D g2d) {
        Iterator it = this.borderFormats.iterator();
        while (it.hasNext()) {
            BorderFormat cur = (BorderFormat)it.next();
            if (!cur.willFit(this.getRange(), g2d)) continue;
            return cur;
        }
        return null;
    }

    public void add(TitleProvider tp) {
        this.titles.add(0, tp);
        this.fixSize();
    }

    public void removeTitle(TitleProvider toBeRemoved) {
        if (this.titles.contains(toBeRemoved)) {
            this.titles.remove(toBeRemoved);
        }
    }

    protected void fixSize() {
        int tpHeight = 0;
        Iterator it = this.titles.iterator();
        while (it.hasNext()) {
            TitleProvider tp = (TitleProvider)it.next();
            tpHeight += tp.getTitleFont().getSize();
        }
        if (this.direction == 1) {
            int height = 25 + this.labelTickLength + tpHeight;
            if (this.labelTickLength == 0) {
                height = tpHeight + 10;
            }
            this.setMinimumSize(new Dimension(0, height));
            this.setPreferredSize(new Dimension(100, height));
        } else {
            int width = 6 * this.getMaxLengthFormattedString().length() + this.labelTickLength + tpHeight;
            if (this.labelTickLength == 0) {
                width = tpHeight + 10;
            }
            this.setMinimumSize(new Dimension(width, 0));
            this.setPreferredSize(new Dimension(width, 100));
        }
    }

    protected abstract List createFormats();

    protected abstract UnitRangeImpl getRange();

    public abstract class BorderFormat {
        protected double divSize;
        protected double ticksPerDiv;

        public BorderFormat(double divisionSize, int ticksPerDivision) {
            this.divSize = divisionSize;
            this.ticksPerDiv = ticksPerDivision;
        }

        public boolean willFit(UnitRangeImpl range, Graphics2D g2d) {
            double maxSize;
            double numDivisions = (range.max_value - range.min_value) / this.divSize;
            double labelSize = this.getLimitingLabelSize(g2d);
            int numTicks = (int)Math.ceil(numDivisions * this.ticksPerDiv);
            return (double)(numTicks * Border.this.tickPad) < (maxSize = this.getLimitingSize()) && labelSize * numDivisions < maxSize;
        }

        private double getLimitingLabelSize(Graphics2D g2d) {
            FontMetrics fm = g2d.getFontMetrics();
            Rectangle2D stringBounds = fm.getStringBounds(this.getMaxString(), g2d);
            if (Border.this.direction == 0) {
                return stringBounds.getHeight();
            }
            return stringBounds.getWidth();
        }

        protected double getLimitingSize() {
            if (Border.this.direction == 0) {
                return Border.this.getSize().getHeight();
            }
            return Border.this.getSize().getWidth();
        }

        public abstract String getMaxString();

        public void draw(UnitRangeImpl range, Graphics2D g2d) {
            Iterator it = Border.this.titles.iterator();
            int cumulativeTitleHeight = 0;
            while (it.hasNext()) {
                TitleProvider tp = (TitleProvider)it.next();
                g2d.setFont(tp.getTitleFont());
                if (tp.getTitleColor() != null) {
                    g2d.setColor(tp.getTitleColor());
                } else {
                    g2d.setColor(Border.this.color);
                }
                FontMetrics fm = g2d.getFontMetrics();
                Rectangle2D titleBounds = tp instanceof SelfDrawableTitleProvider ? ((SelfDrawableTitleProvider)tp).getBounds(g2d) : fm.getStringBounds(tp.getTitle(), g2d);
                cumulativeTitleHeight = (int)((double)cumulativeTitleHeight + titleBounds.getHeight());
                if (Border.this.direction == 0) {
                    double y = (int)((double)(Border.this.getSize().height / 2) + titleBounds.getWidth() / 2.0);
                    double x = Border.this.side == 0 ? (double)(cumulativeTitleHeight - 5) : (double)(Border.this.getWidth() - cumulativeTitleHeight + (int)titleBounds.getHeight() - 5);
                    g2d.translate(x, y);
                    g2d.rotate(-1.5707963267948966);
                    this.drawTitle(g2d, tp, 0, 0);
                    g2d.rotate(1.5707963267948966);
                    g2d.translate(-x, -y);
                    continue;
                }
                int x = (int)((double)(Border.this.getWidth() / 2) - titleBounds.getWidth() / 2.0);
                int y = Border.this.side == 2 ? cumulativeTitleHeight - 5 : Border.this.getHeight() - cumulativeTitleHeight + (int)titleBounds.getHeight() - 5;
                this.drawTitle(g2d, tp, x, y);
            }
            g2d.setColor(Border.this.color);
            if (range != null) {
                double numDivisions = (range.max_value - range.min_value) / this.divSize;
                double pixelsPerLabelTick = this.getLimitingSize() / numDivisions;
                double pixelsPerMinorTick = pixelsPerLabelTick / this.ticksPerDiv;
                double labelValPerTick = this.divSize / this.ticksPerDiv;
                int numLabelTicks = (int)Math.ceil(numDivisions) + 1;
                GeneralPath labelTickShape = new GeneralPath();
                GeneralPath minorTickShape = new GeneralPath();
                float[] nextLabelPoint = this.getFirstPoint();
                double labelValue = this.getFirstLabelValue(range);
                for (int i = 0; i < numLabelTicks; ++i) {
                    if (labelValue >= Border.this.minTickValue && labelValue <= Border.this.maxTickValue) {
                        labelTickShape.moveTo(nextLabelPoint[0], nextLabelPoint[1]);
                        labelTickShape.lineTo(nextLabelPoint[0] + (float)Border.this.labelTickWidth, nextLabelPoint[1] + (float)Border.this.labelTickHeight);
                        float[] nextMinorPoint = this.getNextPoint((float)pixelsPerMinorTick, nextLabelPoint);
                        double tempVal = labelValue;
                        int j = 0;
                        while ((double)j < this.ticksPerDiv - 1.0 && !(tempVal >= Border.this.maxTickValue)) {
                            minorTickShape.moveTo(nextMinorPoint[0], nextMinorPoint[1]);
                            minorTickShape.lineTo(nextMinorPoint[0] + (float)Border.this.tickWidth, nextMinorPoint[1] + (float)Border.this.tickHeight);
                            nextMinorPoint = this.getNextPoint((float)pixelsPerMinorTick, nextMinorPoint);
                            tempVal += labelValPerTick;
                            ++j;
                        }
                    }
                    nextLabelPoint = this.getNextPoint((float)pixelsPerLabelTick, nextLabelPoint);
                    labelValue += this.divSize;
                }
                double[] translation = this.getTranslation(range);
                g2d.translate((int)translation[0], (int)translation[1]);
                g2d.setStroke(DisplayUtils.TWO_PIXEL_STROKE);
                g2d.draw(labelTickShape);
                g2d.setStroke(DisplayUtils.ONE_PIXEL_STROKE);
                g2d.draw(minorTickShape);
                double value = this.getFirstLabelValue(range);
                nextLabelPoint = this.getFirstPoint();
                g2d.setFont(Border.this.getFont());
                for (int i = 0; i < numLabelTicks; ++i) {
                    if (value >= Border.this.minTickValue && value <= Border.this.maxTickValue && value >= range.min_value && value <= range.max_value) {
                        this.label(this.getLabel(value), nextLabelPoint, g2d);
                    }
                    value += this.divSize;
                    nextLabelPoint = this.getNextPoint((float)pixelsPerLabelTick, nextLabelPoint);
                }
                g2d.translate(-((int)translation[0]), -((int)translation[1]));
            }
        }

        private void drawTitle(Graphics2D g2d, TitleProvider tp, int i, int j) {
            if (tp instanceof SelfDrawableTitleProvider) {
                ((SelfDrawableTitleProvider)tp).draw(i, j, g2d);
            } else {
                g2d.drawString(tp.getTitle(), i, j);
            }
        }

        private void label(String label, float[] nextLabelPoint, Graphics2D g2d) {
            float x;
            float y;
            Rectangle2D bounds = g2d.getFontMetrics().getStringBounds(label, g2d);
            double percentageDrawn = 1.0;
            if (Border.this.direction == 0) {
                y = nextLabelPoint[1] + (float)(bounds.getHeight() / 4.0);
                int xMod = Border.this.labelTickLength + 2;
                x = Border.this.side == 0 ? nextLabelPoint[0] - (float)xMod - (float)((int)bounds.getWidth()) : nextLabelPoint[0] + (float)xMod;
                if (y < 0.0f) {
                    percentageDrawn = (bounds.getHeight() + (double)y) / bounds.getHeight();
                } else if ((double)y + bounds.getHeight() > (double)Border.this.getHeight()) {
                    percentageDrawn = (double)((float)Border.this.getHeight() - y) / bounds.getHeight();
                }
            } else {
                x = nextLabelPoint[0] - (float)((int)(bounds.getWidth() / 2.0));
                y = Border.this.side == 2 ? nextLabelPoint[1] - (float)Border.this.labelTickLength - 3.0f : (float)Border.this.labelTickLength + (float)bounds.getHeight() - 3.0f;
            }
            if (percentageDrawn >= 0.6) {
                g2d.drawString(label, x, y);
            }
        }

        protected float[] getFirstPoint() {
            float[] point = new float[2];
            if (Border.this.direction == 0) {
                point[0] = Border.this.side == 0 ? (float)Border.this.getSize().getWidth() : 0.0f;
                point[1] = Border.this.order == 0 ? (float)Border.this.getSize().getHeight() : 0.0f;
            } else {
                point[0] = Border.this.order == 0 ? 0.0f : (float)Border.this.getSize().getWidth();
                point[1] = Border.this.side == 2 ? (float)Border.this.getSize().getHeight() : 0.0f;
            }
            return point;
        }

        protected float[] getNextPoint(float increment, float[] curPoint) {
            float[] nextPoint = new float[]{curPoint[0], curPoint[1]};
            if (Border.this.direction == 0) {
                nextPoint[1] = Border.this.order == 0 ? nextPoint[1] - increment : nextPoint[1] + increment;
            } else {
                nextPoint[0] = Border.this.order == 0 ? nextPoint[0] + increment : nextPoint[0] - increment;
            }
            return nextPoint;
        }

        private double getFirstLabelValue(UnitRangeImpl r) {
            double min = r.min_value;
            double divisions = Math.floor(min / this.divSize);
            return divisions * this.divSize;
        }

        private double[] getTranslation(UnitRangeImpl r) {
            double[] translation = new double[]{0.0, 0.0};
            double range = r.max_value - r.min_value;
            double min = r.min_value;
            double val = this.getFirstLabelValue(r);
            double diff = Math.abs(val - min);
            double percentageDiff = diff / range;
            if (Border.this.direction == 0) {
                double shiftAmount = percentageDiff * Border.this.getSize().getHeight();
                translation[1] = Border.this.order == 0 ? shiftAmount : -shiftAmount;
            } else {
                double shiftAmount = percentageDiff * Border.this.getSize().getWidth();
                translation[0] = Border.this.order == 0 ? -shiftAmount : shiftAmount;
            }
            return translation;
        }

        public double getDivSize() {
            return this.divSize;
        }

        public abstract String getLabel(double var1);
    }
}

