/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.configuration;

import edu.sc.seis.fissuresUtil.display.RecordSectionDisplay;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.borders.AmpBorder;
import edu.sc.seis.fissuresUtil.display.borders.Border;
import edu.sc.seis.fissuresUtil.display.borders.DistanceBorder;
import edu.sc.seis.fissuresUtil.display.borders.TimeBorder;
import edu.sc.seis.fissuresUtil.display.borders.TitleBorder;
import edu.sc.seis.fissuresUtil.display.borders.TitleProvider;
import edu.sc.seis.fissuresUtil.display.borders.TriangleBorder;
import edu.sc.seis.fissuresUtil.display.configuration.BorderTitleConfiguration;
import edu.sc.seis.fissuresUtil.display.configuration.ColorClassConfiguration;
import edu.sc.seis.fissuresUtil.display.configuration.ColorConfiguration;
import edu.sc.seis.fissuresUtil.display.configuration.ConfigDefinitions;
import edu.sc.seis.fissuresUtil.display.configuration.DOMHelper;
import edu.sc.seis.fissuresUtil.display.configuration.FontConfiguration;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BorderConfiguration
implements Cloneable {
    private String type = "title";
    private String order = "ascending";
    private String position = "left";
    private ColorConfiguration background;
    private ColorConfiguration color;
    private ColorConfiguration titleColor;
    private FontConfiguration titleFont;
    private boolean clipTicks = false;
    private double minTickValue = Double.NEGATIVE_INFINITY;
    private double maxTickValue = Double.POSITIVE_INFINITY;
    private static ConfigDefinitions defs = new ConfigDefinitions();
    private static final String LEFT = "left";
    private static final String RIGHT = "right";
    private static final String TOP = "top";
    private static final String BOTTOM = "bottom";
    private static final String AMP = "amp";
    private static final String TIME = "time";
    private static final String DIST = "dist";
    private static final String TITLE = "title";
    private static final String ASCENDING = "ascending";
    private static final String DESCENDING = "descending";
    private static final String TRIANGLE = "triangle";
    private List titles = new ArrayList();
    private Color[] colors = new Color[]{Color.BLACK};

    public void configure(Element element) {
        this.type = DOMHelper.extractText(element, "type", this.type);
        this.order = DOMHelper.extractText(element, "order", this.order);
        this.position = DOMHelper.extractText(element, "position", this.position);
        if (DOMHelper.hasElement(element, "titleFont")) {
            this.titleFont = FontConfiguration.create(DOMHelper.getElement(element, "titleFont"));
        }
        NodeList titleList = DOMHelper.extractNodes(element, TITLE);
        for (int i = 0; i < titleList.getLength(); ++i) {
            this.titles.add(new BorderTitleConfiguration((Element)titleList.item(i)));
        }
        if (DOMHelper.hasElement(element, "titleColor")) {
            this.titleColor = ColorConfiguration.create(DOMHelper.getElement(element, "titleColor"));
        }
        if (DOMHelper.hasElement(element, "clipTicks")) {
            this.clipTicks = true;
            Element tickConfig = DOMHelper.getElement(element, "clipTicks");
            this.minTickValue = new Double(DOMHelper.extractText(tickConfig, "min"));
            this.maxTickValue = new Double(DOMHelper.extractText(tickConfig, "max"));
        }
        if (DOMHelper.hasElement(element, "triangleColors")) {
            this.colors = ColorClassConfiguration.extractColors(DOMHelper.getElement(element, "triangleColors"));
        }
    }

    public static BorderConfiguration create(Element el, ColorConfiguration color, ColorConfiguration background) {
        BorderConfiguration c = null;
        if (defs.referencesDefinition(el)) {
            BorderConfiguration base = (BorderConfiguration)defs.getDefinition(el);
            c = (BorderConfiguration)base.clone();
        } else {
            c = new BorderConfiguration();
        }
        c.configure(el);
        c.color = color;
        c.background = background;
        defs.updateDefinitions(el, c);
        return c;
    }

    public int getPosition() {
        if (this.position.equals(LEFT)) {
            return 3;
        }
        if (this.position.equals(RIGHT)) {
            return 5;
        }
        if (this.position.equals(TOP)) {
            return 1;
        }
        return 7;
    }

    public JComponent createBorder(SeismogramDisplay disp) {
        int side = BorderConfiguration.getSide(this.position);
        Border b = this.type.equals(AMP) ? new AmpBorder(disp, side, false) : (this.type.equals(TIME) ? new TimeBorder(disp) : (this.type.equals(DIST) ? new DistanceBorder((RecordSectionDisplay)disp) : (this.type.equals(TRIANGLE) ? new TriangleBorder((RecordSectionDisplay)disp, BorderConfiguration.getSide(this.position), BorderConfiguration.getOrder(this.order), this.colors) : new TitleBorder(BorderConfiguration.getSide(this.position), BorderConfiguration.getOrder(this.order)))));
        if (b instanceof TitleProvider) {
            if (this.titleFont != null) {
                ((TitleProvider)((Object)b)).setTitleFont(this.titleFont.createFont());
            }
            if (this.titleColor != null) {
                ((TitleProvider)((Object)b)).setTitleColor(this.titleColor.createColor());
            }
        }
        if (this.color != null) {
            b.setTitleAndTickColor(this.color.createColor());
        }
        if (this.background != null) {
            b.setBackground(this.background.createColor());
        }
        b.setSide(side);
        b.setOrder(BorderConfiguration.getOrder(this.order));
        if (this.clipTicks) {
            b.setClipTicks(this.minTickValue, this.maxTickValue);
        }
        Iterator it = this.titles.iterator();
        while (it.hasNext()) {
            b.add(((BorderTitleConfiguration)it.next()).createTitle());
        }
        return b;
    }

    private static int getOrder(String order) {
        if (order.equals(ASCENDING)) {
            return 0;
        }
        return 4;
    }

    private static int getSide(String position) {
        if (position.equals(LEFT)) {
            return 0;
        }
        if (position.equals(RIGHT)) {
            return 1;
        }
        if (position.equals(TOP)) {
            return 2;
        }
        return 3;
    }

    public String toString() {
        return "BorderConfiguration that produces " + this.type + " borders in " + this.order + " order in position " + this.position;
    }

    public Object clone() {
        BorderConfiguration clone = new BorderConfiguration();
        clone.background = this.background;
        clone.color = this.color;
        clone.titleFont = this.titleFont;
        clone.type = this.type;
        clone.order = this.order;
        clone.position = this.position;
        clone.clipTicks = this.clipTicks;
        clone.minTickValue = this.minTickValue;
        clone.maxTickValue = this.maxTickValue;
        clone.titles.addAll(this.titles);
        return clone;
    }
}

