/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.registrar;

import edu.iris.Fissures.model.UnitRangeImpl;
import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.display.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.display.SeismogramContainer;
import edu.sc.seis.fissuresUtil.display.SeismogramContainerFactory;
import edu.sc.seis.fissuresUtil.display.SeismogramContainerListener;
import edu.sc.seis.fissuresUtil.display.SeismogramIterator;
import edu.sc.seis.fissuresUtil.display.registrar.AmpConfig;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import org.apache.log4j.Logger;

public class AmpConfigData
implements SeismogramContainerListener {
    private SeismogramContainer container;
    private UnitRangeImpl cleanRange = DisplayUtils.ONE_RANGE;
    private UnitRangeImpl shaledRange;
    private MicroSecondTimeRange timeRange = DisplayUtils.ZERO_TIME;
    private double shift = 0.0;
    private double scale = 1.0;
    private AmpConfig parent;
    private boolean newData = false;
    private static Logger logger = Logger.getLogger((Class)AmpConfigData.class);

    public AmpConfigData(DataSetSeismogram seismo, AmpConfig parent) {
        this.parent = parent;
        this.container = SeismogramContainerFactory.create(this, seismo);
    }

    public void updateData() {
        this.newData = true;
        this.parent.fireAmpEvent();
    }

    public SeismogramIterator getIterator() {
        return this.container.getIterator(this.timeRange);
    }

    public boolean hasNewData() {
        return this.newData;
    }

    public DataSetSeismogram getDSS() {
        return this.container.getDataSetSeismogram();
    }

    public boolean setRange(UnitRangeImpl newRange) {
        if (this.cleanRange != null && this.cleanRange.equals((Object)newRange)) {
            return false;
        }
        this.cleanRange = newRange;
        this.shaledRange = null;
        this.newData = false;
        return true;
    }

    public UnitRangeImpl shale(double shift, double scale) {
        return this.shale(shift, scale, this.cleanRange);
    }

    public UnitRangeImpl shale(double shift, double scale, UnitRangeImpl range) {
        this.cleanRange = range;
        this.addShift(shift);
        this.addScale(scale);
        this.shaledRange = DisplayUtils.getShaledRange(range, this.shift, this.scale);
        return this.shaledRange;
    }

    public UnitRangeImpl getRange() {
        if (this.shaledRange == null) {
            this.shaledRange = DisplayUtils.getShaledRange(this.cleanRange, this.shift, this.scale);
        }
        return this.shaledRange;
    }

    public MicroSecondTimeRange getTime() {
        return this.timeRange;
    }

    public boolean setTime(MicroSecondTimeRange newRange) {
        if (newRange.equals(this.timeRange) || newRange == DisplayUtils.ONE_TIME) {
            return false;
        }
        this.timeRange = newRange;
        return true;
    }

    public double getShift() {
        return this.shift;
    }

    public void setShift(double newShift) {
        this.shift = newShift;
        this.shaledRange = null;
    }

    public double addShift(double newShift) {
        this.shift += newShift * this.scale;
        this.shaledRange = null;
        return this.shift;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double newScale) {
        this.scale = newScale;
        this.shaledRange = null;
    }

    public double addScale(double newScale) {
        this.scale += newScale * this.scale;
        this.shaledRange = null;
        return this.scale;
    }

    public void reset() {
        this.shift = 0.0;
        this.scale = 1.0;
        this.shaledRange = this.cleanRange;
    }

    public String toString() {
        return "AmpConfigData for " + this.container.getDataSetSeismogram().getName();
    }

    public static DataSetSeismogram[] getSeismograms(AmpConfigData[] ampData) {
        DataSetSeismogram[] seisArray = new DataSetSeismogram[ampData.length];
        for (int i = 0; i < ampData.length; ++i) {
            seisArray[i] = ampData[i].getDSS();
        }
        return seisArray;
    }
}

