/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.registrar;

import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.model.UnitRangeImpl;
import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.display.registrar.LayoutConfig;
import edu.sc.seis.fissuresUtil.display.registrar.LayoutData;
import edu.sc.seis.fissuresUtil.display.registrar.LayoutEvent;
import edu.sc.seis.fissuresUtil.display.registrar.LayoutListener;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BasicLayoutConfig
implements LayoutConfig {
    private LayoutEvent lastEvent = LayoutEvent.EMPTY_EVENT;
    protected Map valueMap = new HashMap();
    private Set listeners = new HashSet();
    protected List seis = new ArrayList();
    private double scale = 1.0;
    private static final Logger logger = Logger.getLogger((Class)BasicLayoutConfig.class);

    public BasicLayoutConfig() {
    }

    public BasicLayoutConfig(DataSetSeismogram[] seismos) {
        this.add(seismos);
    }

    public synchronized void addListener(LayoutListener listener) {
        this.listeners.add(listener);
        this.fireLayoutEvent();
    }

    public synchronized void removeListener(LayoutListener listener) {
        this.listeners.remove(listener);
    }

    public void fireLayoutEvent() {
        this.fireLayoutEvent(this.generateLayoutEvent());
    }

    private synchronized void fireLayoutEvent(LayoutEvent event) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((LayoutListener)it.next()).updateLayout(event);
        }
    }

    public synchronized void add(DataSetSeismogram[] seismos) {
        ArrayList<DataSetSeismogram> noDist = new ArrayList<DataSetSeismogram>();
        boolean someAdded = false;
        for (int i = 0; i < seismos.length; ++i) {
            if (this.valueMap.containsKey(seismos[i])) continue;
            QuantityImpl dist = DisplayUtils.calculateDistance(seismos[i]);
            if (dist == null) {
                noDist.add(seismos[i]);
                continue;
            }
            this.seis.add(seismos[i]);
            this.valueMap.put(seismos[i], dist);
            someAdded = true;
        }
        logger.debug((Object)("Seismograms not plotted becuase distance could not be determined: " + noDist.size()));
        if (someAdded) {
            this.fireLayoutEvent();
        }
    }

    public synchronized void remove(DataSetSeismogram[] seismos) {
        for (int i = 0; i < seismos.length; ++i) {
            if (!this.valueMap.containsKey(seismos[i])) continue;
            this.valueMap.remove(seismos[i]);
        }
        boolean someRemoved = false;
        for (int i = 0; i < seismos.length; ++i) {
            if (!this.seis.remove(seismos[i])) continue;
            someRemoved = true;
        }
        if (someRemoved) {
            this.fireLayoutEvent();
        }
    }

    public synchronized boolean contains(DataSetSeismogram seismo) {
        return this.seis.contains(seismo);
    }

    public synchronized void clear() {
        if (this.seis.size() > 0) {
            this.seis.clear();
            this.fireLayoutEvent();
        }
    }

    public DataSetSeismogram[] getSeismograms() {
        return this.seis.toArray(new DataSetSeismogram[this.seis.size()]);
    }

    public String getLabel() {
        return "Distance (Degrees)";
    }

    public void reset() {
        DataSetSeismogram[] seismograms = this.getSeismograms();
        this.seis.clear();
        this.add(seismograms);
    }

    public void reset(DataSetSeismogram[] seismos) {
        ArrayList<DataSetSeismogram> reset = new ArrayList<DataSetSeismogram>();
        for (int i = 0; i < seismos.length; ++i) {
            if (!this.contains(seismos[i])) continue;
            this.seis.remove(seismos[i]);
            reset.add(seismos[i]);
        }
        this.add(reset.toArray(new DataSetSeismogram[reset.size()]));
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        if (this.scale != scale) {
            this.scale = scale;
            this.fireLayoutEvent();
        }
    }

    public synchronized LayoutEvent generateLayoutEvent() {
        DataSetSeismogram[] seis = this.getSeismograms();
        if (seis.length > 0) {
            ArrayList<DataSetSeismogram> orderedSeis = new ArrayList<DataSetSeismogram>(seis.length);
            orderedSeis.add(seis[0]);
            double minDistBetween = Double.POSITIVE_INFINITY;
            for (int i = 1; i < seis.length; ++i) {
                DataSetSeismogram curSeis = seis[i];
                double curSeisDelt = ((QuantityImpl)this.valueMap.get(curSeis)).getValue();
                ListIterator<DataSetSeismogram> orIt = orderedSeis.listIterator();
                boolean added = false;
                while (orIt.hasNext() && !added) {
                    DataSetSeismogram orSeis = (DataSetSeismogram)orIt.next();
                    double orSeisDelt = ((QuantityImpl)this.valueMap.get(orSeis)).getValue();
                    double distDiff = orSeisDelt - curSeisDelt;
                    if (distDiff > 0.0) {
                        orIt.previous();
                        orIt.add(curSeis);
                        added = true;
                    }
                    if (distDiff == 0.0 || !(Math.abs(distDiff) < minDistBetween)) continue;
                    minDistBetween = Math.abs(distDiff);
                }
                if (added) continue;
                orderedSeis.add(curSeis);
            }
            if (minDistBetween == Double.POSITIVE_INFINITY) {
                LayoutData[] data = new LayoutData[seis.length];
                for (int i = 0; i < data.length; ++i) {
                    data[i] = new LayoutData(seis[i], 0.0, 1.0);
                }
                double dist = ((QuantityImpl)this.valueMap.get(orderedSeis.get(0))).getValue();
                UnitRangeImpl range = new UnitRangeImpl(dist - 2.0, dist + 2.0, (Unit)UnitImpl.DEGREE);
                this.lastEvent = new LayoutEvent(data, range);
                return this.lastEvent;
            }
            double offset = minDistBetween * this.scale / 2.0;
            double startDist = ((QuantityImpl)this.valueMap.get(orderedSeis.get(0))).getValue() - offset;
            double endDist = ((QuantityImpl)this.valueMap.get(orderedSeis.get(orderedSeis.size() - 1))).getValue() + offset;
            double totalDistance = endDist - startDist;
            double percentageOffset = offset / totalDistance;
            LayoutData[] data = new LayoutData[seis.length];
            for (int i = 0; i < data.length; ++i) {
                DataSetSeismogram cur = (DataSetSeismogram)orderedSeis.get(i);
                double curDist = ((QuantityImpl)this.valueMap.get(cur)).getValue();
                double centerPercentage = (curDist - startDist) / totalDistance;
                data[i] = new LayoutData(cur, centerPercentage - percentageOffset, centerPercentage + percentageOffset);
            }
            UnitRangeImpl range = new UnitRangeImpl(startDist, endDist, (Unit)UnitImpl.DEGREE);
            this.lastEvent = new LayoutEvent(data, range);
            return this.lastEvent;
        }
        this.lastEvent = LayoutEvent.EMPTY_EVENT;
        return this.lastEvent;
    }

    public LayoutEvent getLayout() {
        return this.lastEvent;
    }
}

