/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.flow.querier;

import edu.iris.Fissures.Area;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.display.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.flow.tester.ANDTester;
import edu.sc.seis.fissuresUtil.flow.tester.TestResult;
import edu.sc.seis.fissuresUtil.flow.tester.Tester;
import edu.sc.seis.fissuresUtil.flow.tester.event.MagnitudeValueTester;
import edu.sc.seis.fissuresUtil.flow.tester.model.AreaTester;
import edu.sc.seis.fissuresUtil.flow.tester.model.DepthTester;
import edu.sc.seis.fissuresUtil.flow.tester.model.TimeTester;

public class EventFinderQuery
implements Tester {
    private AreaTester areaTester = new AreaTester();
    private DepthTester depth = new DepthTester();
    private TimeTester timeTester = new TimeTester();
    private MagnitudeValueTester magTester = new MagnitudeValueTester();
    private String[] magTypes = new String[]{"%"};
    private String[] catalogs = new String[0];
    private String[] contributors = new String[0];

    public TestResult test(Object o) {
        return new ANDTester(new Tester[]{this.magTester, this.timeTester, this.depth, this.areaTester}).test(o);
    }

    public Area getArea() {
        return this.areaTester.getArea();
    }

    public void setArea(Area a) {
        this.areaTester = new AreaTester(a);
    }

    public float getMinMag() {
        return this.magTester.getMin();
    }

    public void setMinMag(float min) {
        this.magTester = new MagnitudeValueTester(min, this.magTester.getMax());
    }

    public float getMaxMag() {
        return this.magTester.getMax();
    }

    public void setMaxMag(float max) {
        this.magTester = new MagnitudeValueTester(this.magTester.getMin(), max);
    }

    public MicroSecondTimeRange getTime() {
        return this.timeTester.getRange();
    }

    public void setTime(MicroSecondTimeRange range) {
        this.timeTester = new TimeTester(range);
    }

    public Quantity getMinDepthQuantity() {
        return this.depth.getMin();
    }

    public double getMinDepth() {
        return this.depth.getMin().getValue(UnitImpl.KILOMETER);
    }

    public void setMinDepth(double min) {
        this.depth = new DepthTester(new QuantityImpl(min, (Unit)UnitImpl.KILOMETER), this.depth.getMax());
    }

    public Quantity getMaxDepthQuantity() {
        return this.depth.getMax();
    }

    public double getMaxDepth() {
        return this.depth.getMax().getValue(UnitImpl.KILOMETER);
    }

    public void setMaxDepth(double max) {
        this.depth = new DepthTester(this.depth.getMin(), new QuantityImpl(max, (Unit)UnitImpl.KILOMETER));
    }

    public String[] getTypes() {
        return this.magTypes;
    }

    public String[] getCatalogs() {
        return this.catalogs;
    }

    public String[] getContributors() {
        return this.contributors;
    }
}

