/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.flow.tester.event;

import edu.sc.seis.fissuresUtil.flow.extractor.event.MagnitudeValueExtractor;
import edu.sc.seis.fissuresUtil.flow.tester.Fail;
import edu.sc.seis.fissuresUtil.flow.tester.NoTestSubject;
import edu.sc.seis.fissuresUtil.flow.tester.Pass;
import edu.sc.seis.fissuresUtil.flow.tester.TestResult;
import edu.sc.seis.fissuresUtil.flow.tester.Tester;

public class MagnitudeValueTester
implements Tester {
    private MagnitudeValueExtractor mve = new MagnitudeValueExtractor();
    private float min;
    private float max;

    public MagnitudeValueTester() {
        this(0.0f, 10.0f);
    }

    public MagnitudeValueTester(float min, float max) {
        this.min = min;
        this.max = max;
    }

    public TestResult test(Object o) {
        float val = this.mve.extract(o);
        if (val != -1.0f) {
            return this.test(val);
        }
        return new NoTestSubject(o + " did not contain a magnitude value");
    }

    public TestResult test(float f) {
        if (f > this.max) {
            return new Fail(f + " is too large");
        }
        if (f < this.min) {
            return new Fail(f + " is too small");
        }
        return new Pass(f + " is within range");
    }

    public float getMax() {
        return this.max;
    }

    public float getMin() {
        return this.min;
    }
}

