/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.freq;

import edu.sc.seis.fissuresUtil.freq.Cmplx;
import edu.sc.seis.fissuresUtil.freq.FilterException;
import edu.sc.seis.fissuresUtil.freq.FrequencyDomainProcess;
import edu.sc.seis.fissuresUtil.freq.SeisGramText;

public class GaussianFilter
implements FrequencyDomainProcess {
    private SeisGramText localeText;
    public double centFreq;
    public double alpha;
    public String errorMessage;
    private static final double FREQ_MIN = Double.MIN_VALUE;
    private static final double FREQ_MAX = Double.MAX_VALUE;
    private static final double ALPHA_MIN = Double.MIN_VALUE;
    private static final double ALPHA_MAX = Double.MAX_VALUE;

    public GaussianFilter(SeisGramText localeText, double centFreq, double alpha) {
        this.localeText = localeText;
        this.centFreq = centFreq;
        this.alpha = alpha;
        this.errorMessage = " ";
    }

    public void setCentFreq(double freqValue) throws FilterException {
        if (freqValue < Double.MIN_VALUE || freqValue > Double.MAX_VALUE) {
            throw new FilterException(this.localeText.invalid_center_frequency);
        }
        this.centFreq = freqValue;
    }

    public void setCentFreq(String str) throws FilterException {
        double freqValue;
        try {
            freqValue = Double.valueOf(str);
        }
        catch (NumberFormatException e) {
            throw new FilterException(this.localeText.invalid_center_frequency);
        }
        this.setCentFreq(freqValue);
    }

    public void setAlpha(double alphaValue) throws FilterException {
        if (alphaValue < Double.MIN_VALUE || alphaValue > Double.MAX_VALUE) {
            throw new FilterException(this.localeText.invalid_alpha_value);
        }
        this.alpha = alphaValue;
    }

    public void setAlpha(String str) throws FilterException {
        double alphaValue;
        try {
            alphaValue = Double.valueOf(str);
        }
        catch (NumberFormatException e) {
            throw new FilterException(this.localeText.invalid_alpha_value);
        }
        this.setAlpha(alphaValue);
    }

    public void checkSettings() throws FilterException {
        String errMessage = "";
        int badSettings = 0;
        if (this.centFreq < Double.MIN_VALUE || this.centFreq > Double.MAX_VALUE) {
            errMessage = errMessage + ": " + this.localeText.invalid_center_frequency;
            ++badSettings;
        }
        if (this.alpha < Double.MIN_VALUE || this.alpha > Double.MAX_VALUE) {
            errMessage = errMessage + ": " + this.localeText.invalid_alpha_value;
            ++badSettings;
        }
        if (badSettings > 0) {
            throw new FilterException(errMessage + ".");
        }
    }

    public final Cmplx[] apply(double dtime, Cmplx[] cz) {
        double wcent = Math.PI * 2 * this.centFreq;
        double freq0 = Math.PI * 2 / (((double)(cz.length - 1) + 1.0) * dtime);
        int np = cz.length;
        int np2 = cz.length / 2;
        Cmplx chalf = new Cmplx(0.5, 0.0);
        for (int i = 0; i < np2; ++i) {
            double w = freq0 * (double)(i + 1);
            double wdiff = (w - wcent) / wcent;
            Cmplx ctf = new Cmplx(Math.exp(-this.alpha * wdiff * wdiff), 0.0);
            int i1 = i + 1;
            int i2 = np - 1 - i;
            if (i != np2 - 1) {
                cz[i1] = Cmplx.mul(cz[i1], ctf);
                cz[i2] = Cmplx.mul(cz[i2], ctf);
                continue;
            }
            cz[i1] = Cmplx.mul(cz[i1], Cmplx.mul(ctf, chalf));
        }
        cz[0] = new Cmplx(0.0, 0.0);
        return cz;
    }
}

