/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.gmt;

import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.Arc2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class ImageAugmenter {
    private static double TWO_THIRDS_PI = 2.0943951023931953;
    private static double ONE_HALF_PI = 1.5707963267948966;
    private static Logger logger = Logger.getLogger((Class)ImageAugmenter.class);
    private boolean yFromBottom = false;
    private BufferedImage image;

    public ImageAugmenter(String imgFileLoc) throws IOException {
        this(imgFileLoc, false);
    }

    public ImageAugmenter(String imgFileLoc, boolean yFromBottom) throws IOException {
        this.yFromBottom = yFromBottom;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image img = null;
        img = imgFileLoc.startsWith("jar:") ? toolkit.getImage(this.getClass().getClassLoader().getResource(imgFileLoc.substring(4))) : toolkit.getImage(imgFileLoc);
        JPanel panel = new JPanel();
        MediaTracker tracker = new MediaTracker(panel);
        tracker.addImage(img, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException e) {
            GlobalExceptionHandler.handle("problem occurred while waiting for image to load", e);
        }
        this.image = new BufferedImage(img.getWidth(null), img.getHeight(null), 3);
        Graphics2D g2d = this.image.createGraphics();
        ImageAugmenter.setAntialiasingOn(g2d);
        g2d.drawImage(img, 0, 0, null);
    }

    public void drawShape(Shape shape, Paint fill, Paint strokePaint, float strokeWidth) {
        Graphics2D g2d = (Graphics2D)this.image.getGraphics();
        ImageAugmenter.setAntialiasingOn(g2d);
        g2d.setPaint(fill);
        g2d.fill(shape);
        g2d.setPaint(strokePaint);
        BasicStroke stroke = new BasicStroke(strokeWidth);
        g2d.setStroke(stroke);
        g2d.draw(shape);
    }

    public void drawTriangle(int x, int y, int diameter, Paint fill, Paint strokePaint, float strokeWidth) {
        int[] triCoords = ImageAugmenter.getTriangleCoords(new int[]{x, this.translateY(y)}, diameter, strokeWidth);
        Polygon poly = new Polygon(new int[]{triCoords[0], triCoords[2], triCoords[4]}, new int[]{triCoords[1], triCoords[3], triCoords[5]}, 3);
        this.drawShape(poly, fill, strokePaint, strokeWidth);
    }

    public void drawCircle(int x, int y, int diameter, Paint fill, Paint strokePaint, float strokeWidth) {
        int realX = this.translateCoord(x, diameter);
        int realY = this.translateCoord(this.translateY(y), diameter);
        Arc2D.Double shape = new Arc2D.Double(realX, realY, diameter, diameter, 0.0, 360.0, 0);
        this.drawShape(shape, fill, strokePaint, strokeWidth);
    }

    public int translateCoord(int center, int length) {
        return center - length / 2;
    }

    public int translateY(int y) {
        if (this.yFromBottom) {
            return this.image.getHeight() - y;
        }
        return y;
    }

    public void cropImage(int newWidth, int newHeight, int left, int top) {
        BufferedImage oldImage = this.image;
        this.image = new BufferedImage(newWidth, newHeight, 3);
        Graphics2D g2d = this.image.createGraphics();
        ImageAugmenter.setAntialiasingOn(g2d);
        g2d.drawImage(oldImage, null, -left, -top);
        oldImage = null;
    }

    public void outputToPNG(String filename) throws IOException {
        this.outputToPNG(new File(filename));
    }

    public void outputToPNG(File file) throws IOException {
        file.getCanonicalFile().getParentFile().mkdirs();
        File temp = File.createTempFile(file.getName(), null, file.getParentFile());
        this.outputToPNG(new BufferedOutputStream(new FileOutputStream(temp)));
        file.delete();
        temp.renameTo(file);
    }

    public void outputToPNG(OutputStream out) throws IOException {
        ImageIO.write((RenderedImage)this.image, "png", out);
    }

    public int getWidth() {
        return this.image.getWidth();
    }

    public int getHeight() {
        return this.image.getHeight();
    }

    public boolean getYFromBottom() {
        return this.yFromBottom;
    }

    public void setYFromBottom(boolean b) {
        this.yFromBottom = b;
    }

    public static void setAntialiasingOn(Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    public static int[] getTriangleCoords(int[] centerCoords, int staDiameter, float staStrokeWidth) {
        int[] triCoords = new int[6];
        double staRadius = (float)(staDiameter / 2) + staStrokeWidth;
        for (int i = 0; i < 3; ++i) {
            double rads = (double)i * TWO_THIRDS_PI - ONE_HALF_PI;
            triCoords[i * 2] = (int)((double)centerCoords[0] + staRadius * Math.cos(rads));
            triCoords[i * 2 + 1] = (int)((double)centerCoords[1] + staRadius * Math.sin(rads));
        }
        return triCoords;
    }

    public static String printIntArray(int[] ints) {
        StringBuffer buf = new StringBuffer();
        buf.append("[ ");
        for (int i = 0; i < ints.length; ++i) {
            buf.append(ints[i]);
            if (i >= ints.length - 1) continue;
            buf.append(", ");
        }
        buf.append(" ]");
        return buf.toString();
    }

    public static void main(String[] args) {
        try {
            ImageAugmenter imgAug = new ImageAugmenter(args[0], true);
            imgAug.drawCircle(300, 300, 5, Color.YELLOW, Color.BLACK, 1.0f);
            imgAug.drawCircle(300, 300, 50, new Color(0, 0, 0, 0), Color.YELLOW, 2.0f);
            imgAug.drawTriangle(350, 345, 10, new Color(0, 0, 255), Color.WHITE, 1.0f);
            imgAug.cropImage(790, 426, 5, 169);
            imgAug.outputToPNG(args[1]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

