/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.gmt;

import edu.sc.seis.fissuresUtil.gmt.GenericCommandExecute;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class PSXYExecute {
    public static void open(String psFilename, String projection, String region) throws InterruptedException, IOException {
        PSXYExecute.open(new File(psFilename), projection, region);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void open(File psFile, String projection, String region) throws InterruptedException, IOException {
        String command = "psxy /dev/null -V -J" + projection + " -R" + region + " -K";
        FileOutputStream fos = new FileOutputStream(psFile, true);
        try {
            GenericCommandExecute.execute(command, (Reader)new StringReader(""), fos, System.err);
        }
        finally {
            fos.close();
        }
    }

    public static void close(String psFilename, String projection, String region) throws InterruptedException, IOException {
        PSXYExecute.close(new File(psFilename), projection, region);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(File psFile, String projection, String region) throws InterruptedException, IOException {
        String command = "psxy /dev/null -V -J" + projection + " -R" + region + " -O";
        FileOutputStream fos = new FileOutputStream(psFile, true);
        try {
            GenericCommandExecute.execute(command, (Reader)new StringReader(""), fos, System.err);
        }
        finally {
            fos.close();
        }
    }

    public static void addPoints(String psFilename, String projection, String region, String symbol, String fillColor, String outlineColor, double[][] points) throws IOException, InterruptedException {
        PSXYExecute.addPoints(new File(psFilename), projection, region, symbol, fillColor, outlineColor, points);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPoints(File psFilename, String projection, String region, String symbol, String fillColor, String outlineColor, double[][] points) throws IOException, InterruptedException {
        String command = "psxy -J" + projection + " -R" + region + " -S" + symbol + " -O -K";
        if (fillColor != null) {
            command = command + " -G" + fillColor;
        }
        if (outlineColor != null) {
            command = command + " -W" + outlineColor;
        }
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < points.length; ++i) {
            for (int j = 0; j < points[i].length; ++j) {
                buff.append(points[i][j] + "");
                if (j < points[i].length - 1) {
                    buff.append(" ");
                    continue;
                }
                buff.append("\n");
            }
        }
        FileOutputStream fos = new FileOutputStream(psFilename, true);
        try {
            GenericCommandExecute.execute(command, (Reader)new StringReader(buff.toString()), fos, System.err);
        }
        finally {
            fos.close();
        }
    }

    public static void main(String[] args) {
        try {
            PSXYExecute.open("world.ps", "Kf166/10i", "-14/346/-90/90");
            double[][] points = new double[][]{{-180.0, 90.0}, {-135.0, 67.5}, {-90.0, 45.0}, {-45.0, 22.5}, {0.0, 0.0}};
            PSXYExecute.addPoints("world.ps", "Kf166/10i", "-14/346/-90/90", "t0.4", "0/0/255", "5/255", (double[][])points);
            double[][] morePoints = new double[][]{{45.0, -22.5, 0.7}, {90.0, -45.0, 0.5}, {135.0, -67.5, 0.4}, {180.0, -90.0, 1.0}};
            PSXYExecute.addPoints("world.ps", "Kf166/10i", "-14/346/-90/90", "ci", null, "12/255/0/0", (double[][])morePoints);
            PSXYExecute.close("world.ps", "Kf166/10i", "-14/346/-90/90");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

