/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.map.layers;

import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.event.SelectMouseMode;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.cache.EventLoadedListener;
import edu.sc.seis.fissuresUtil.cache.EventLoader;
import edu.sc.seis.fissuresUtil.cache.EventUtil;
import edu.sc.seis.fissuresUtil.cache.ProxyEventAccessOperations;
import edu.sc.seis.fissuresUtil.cache.WorkerThreadPool;
import edu.sc.seis.fissuresUtil.display.EQDataEvent;
import edu.sc.seis.fissuresUtil.display.EQSelectionEvent;
import edu.sc.seis.fissuresUtil.display.EQSelectionListener;
import edu.sc.seis.fissuresUtil.display.EventDataListener;
import edu.sc.seis.fissuresUtil.map.LayerProjectionUpdater;
import edu.sc.seis.fissuresUtil.map.OpenMap;
import edu.sc.seis.fissuresUtil.map.colorizer.event.EventColorizer;
import edu.sc.seis.fissuresUtil.map.graphics.OMEvent;
import edu.sc.seis.fissuresUtil.map.layers.MouseAdapterLayer;
import edu.sc.seis.fissuresUtil.map.layers.StationLayer;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.log4j.Logger;

public class EventLayer
extends MouseAdapterLayer
implements EventDataListener,
EventLoadedListener,
EQSelectionListener {
    private static String[] modeList = new String[]{SelectMouseMode.modeID};
    private OMGraphicList circles = new OMGraphicList();
    private Set events = new HashSet();
    private static Logger logger = Logger.getLogger((Class)EventLayer.class);
    private OpenMap map;
    private EventColorizer colorizer;

    public EventLayer(OpenMap map, EventColorizer colorizer) {
        this.map = map;
        this.colorizer = colorizer;
        this.setName("Event Layer");
        this.circles.setTraverseMode(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        OMGraphicList oMGraphicList = this.circles;
        synchronized (oMGraphicList) {
            this.circles.render(g);
        }
    }

    public void projectionChanged(ProjectionEvent e) {
        LayerProjectionUpdater.update(e, this.circles, this);
    }

    public void eventDataAppended(EQDataEvent eqDataEvent) {
        this.loadEvents(eqDataEvent);
    }

    public void eventDataChanged(EQDataEvent eqDataEvent) {
        this.loadEvents(eqDataEvent);
    }

    protected void loadEvents(EQDataEvent eqDataEvent) {
        EventAccessOperations[] events = eqDataEvent.getEvents();
        for (int i = 0; i < events.length; ++i) {
            EventLoader loader = new EventLoader((CacheEvent)events[i], this);
            WorkerThreadPool.getDefaultPool().invokeLater(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventLoaded(ProxyEventAccessOperations event) {
        OMGraphicList oMGraphicList = this.circles;
        synchronized (oMGraphicList) {
            if (this.events.add(event)) {
                this.circles.add((OMGraphic)new OMEvent(event, this, this.map));
                this.colorizer.colorize(this.circles);
                this.repaint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventDataCleared() {
        OMGraphicList oMGraphicList = this.circles;
        synchronized (oMGraphicList) {
            this.circles.clear();
            this.events.clear();
        }
        this.repaint();
    }

    public void addEQSelectionListener(EQSelectionListener listener) {
        this.listenerList.add(EQSelectionListener.class, listener);
        EventAccessOperations[] selectedEvents = this.getSelectedEvents();
        if (selectedEvents.length > 0) {
            listener.eqSelectionChanged(new EQSelectionEvent(this, this.getSelectedEvents()));
        }
    }

    public void removeEQSelectionListener(EQSelectionListener listener) {
        this.listenerList.remove(EQSelectionListener.class, listener);
    }

    public void fireEQSelectionChanged(EQSelectionEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$edu$sc$seis$fissuresUtil$display$EQSelectionListener == null ? EventLayer.class$("edu.sc.seis.fissuresUtil.display.EQSelectionListener") : class$edu$sc$seis$fissuresUtil$display$EQSelectionListener)) continue;
            ((EQSelectionListener)listeners[i + 1]).eqSelectionChanged(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eqSelectionChanged(EQSelectionEvent eqSelectionEvent) {
        OMEvent selected = null;
        ArrayList<OMEvent> deselected = new ArrayList<OMEvent>();
        OMGraphicList oMGraphicList = this.circles;
        synchronized (oMGraphicList) {
            Iterator it = this.circles.iterator();
            while (it.hasNext()) {
                OMEvent current = (OMEvent)it.next();
                if (current.getEvent().equals(eqSelectionEvent.getEvents()[0])) {
                    selected = current;
                    continue;
                }
                deselected.add(current);
            }
        }
        if (selected != null) {
            selected.select();
            oMGraphicList = this.circles;
            synchronized (oMGraphicList) {
                this.circles.moveIndexedToTop(this.circles.indexOf((OMGraphic)selected));
            }
            Iterator it = deselected.iterator();
            while (it.hasNext()) {
                ((OMEvent)it.next()).deselect();
            }
        }
    }

    public String[] getMouseModeServiceList() {
        return modeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mouseClicked(MouseEvent e) {
        this.maybeKillCurrentPopup();
        OMGraphicList oMGraphicList = this.circles;
        synchronized (oMGraphicList) {
            Iterator it = this.circles.iterator();
            ArrayList<ProxyEventAccessOperations> eventsUnderMouse = new ArrayList<ProxyEventAccessOperations>();
            while (it.hasNext()) {
                OMEvent current = (OMEvent)it.next();
                if (!current.getBigCircle().contains(e.getX(), e.getY())) continue;
                eventsUnderMouse.add(current.getEvent());
            }
            if (eventsUnderMouse.size() > 0) {
                if (eventsUnderMouse.size() == 1) {
                    this.selectEvent((EventAccessOperations)eventsUnderMouse.get(0));
                } else {
                    final JPopupMenu popup = new JPopupMenu();
                    popup.setInvoker((Component)((Object)this));
                    it = eventsUnderMouse.iterator();
                    while (it.hasNext()) {
                        final EventAccessOperations current = (EventAccessOperations)it.next();
                        final JMenuItem menuItem = new JMenuItem(EventUtil.getEventInfo(current));
                        menuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                EventLayer.this.selectEvent(current);
                                popup.setVisible(false);
                            }
                        });
                        menuItem.addMouseListener(new MouseAdapter(){

                            public void mouseEntered(MouseEvent e) {
                                menuItem.setArmed(true);
                            }

                            public void mouseExited(MouseEvent e) {
                                menuItem.setArmed(false);
                            }
                        });
                        popup.add(menuItem);
                    }
                    Point compLocation = e.getComponent().getLocationOnScreen();
                    double[] popupLoc = new double[]{compLocation.getX(), compLocation.getY()};
                    popup.setLocation((int)popupLoc[0] + e.getX(), (int)popupLoc[1] + e.getY());
                    popup.setVisible(true);
                    this.currentPopup = popup;
                }
                return true;
            }
        }
        return false;
    }

    public void selectEvent(EventAccessOperations evo) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mouseMoved(MouseEvent e) {
        this.maybeKillCurrentPopup();
        OMGraphicList oMGraphicList = this.circles;
        synchronized (oMGraphicList) {
            Iterator it = this.circles.iterator();
            while (it.hasNext()) {
                OMEvent current = (OMEvent)it.next();
                try {
                    if (!current.getBigCircle().contains(e.getX(), e.getY())) continue;
                    ProxyEventAccessOperations event = current.getEvent();
                    this.fireRequestInfoLine(EventUtil.getEventInfo(event));
                    return true;
                }
                catch (Exception ex) {
                }
            }
        }
        return false;
    }

    public EventAccessOperations[] getSelectedEvents() {
        return new EventAccessOperations[0];
    }

    public void printCircleLocs() {
        Iterator it = this.circles.iterator();
        int i = 0;
        while (it.hasNext()) {
            OMEvent cur = (OMEvent)it.next();
            int x = cur.getBigCircle().getX();
            int y = cur.getBigCircle().getY();
            int rad = cur.getBigCircle().getHeight() / 2;
            System.out.println("<area href=\"" + i++ + "\" shape=\"circle\" coords=\"" + x + "," + y + "," + rad + "\"/>");
        }
    }

    public void removeEQSelectionListener(StationLayer stl) {
    }
}

