/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.rt130;

import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.rt130.RT130FormatException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class FileNameParser {
    private static Calendar beginParserCal = Calendar.getInstance();

    public static TimeInterval getLengthOfData(String fileName) throws RT130FormatException {
        if (fileName.length() != 18) {
            System.err.println("The file is not 18 characters in length.");
            throw new RT130FormatException();
        }
        String[] hexLengthOfData = new String[]{fileName.substring(17, 18), fileName.substring(16, 17), fileName.substring(15, 16), fileName.substring(14, 15), fileName.substring(13, 14), fileName.substring(12, 13), fileName.substring(11, 12), fileName.substring(10, 11)};
        double milliseconds = 0.0;
        for (int i = 0; i < hexLengthOfData.length; ++i) {
            milliseconds += (double)FileNameParser.convertHexToDecimal(hexLengthOfData[i]) * Math.pow(16.0, i);
        }
        TimeInterval lengthOfData = new TimeInterval(milliseconds, UnitImpl.MILLISECOND);
        return lengthOfData;
    }

    private static int convertHexToDecimal(String a) {
        if (a.equals("F")) {
            return 15;
        }
        if (a.equals("E")) {
            return 14;
        }
        if (a.equals("D")) {
            return 13;
        }
        if (a.equals("C")) {
            return 12;
        }
        if (a.equals("B")) {
            return 11;
        }
        if (a.equals("A")) {
            return 10;
        }
        return Integer.valueOf(a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MicroSecondDate getBeginTime(String yearAndDay, String fileName) {
        Date d;
        int year = Integer.valueOf(yearAndDay.substring(0, 4));
        int dayOfYear = Integer.valueOf(yearAndDay.substring(4, 7));
        int hours = Integer.valueOf(fileName.substring(0, 2));
        int minutes = Integer.valueOf(fileName.substring(2, 4));
        int seconds = Integer.valueOf(fileName.substring(4, 6));
        Calendar calendar = beginParserCal;
        synchronized (calendar) {
            beginParserCal.set(1, year);
            beginParserCal.set(6, dayOfYear);
            beginParserCal.set(11, hours);
            beginParserCal.set(12, minutes);
            beginParserCal.set(13, seconds);
            d = beginParserCal.getTime();
        }
        return new MicroSecondDate(d);
    }

    static {
        beginParserCal.setTimeZone(TimeZone.getTimeZone("GMT"));
        beginParserCal.set(14, 0);
    }
}

