/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.rt130;

import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.display.MicroSecondTimeRange;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class LeapSecondApplier {
    private static Map unitIdToCorrections = new HashMap();
    private static List leapSecondOccurrences = new LinkedList();
    private static SimpleDateFormat format = new SimpleDateFormat("yy:DDD:HH:mm:ss:SSS");
    public static final String LEAP_SECOND_FILE = "leapSecondFile";
    public static final String POWER_UP_TIMES = "powerUpTimes";

    public static void addLeapSeconds(String correctionFileLoc) throws IOException, ParseException {
        String nextLine;
        BufferedReader in = LeapSecondApplier.openReader(correctionFileLoc);
        while ((nextLine = in.readLine()) != null) {
            MicroSecondDate date = LeapSecondApplier.stringToMicroSecondDate(nextLine);
            if (leapSecondOccurrences.contains(date)) continue;
            leapSecondOccurrences.add(date);
        }
    }

    public static void addCorrections(String correctionFileLoc) throws IOException, ParseException {
        String nextLine;
        BufferedReader in = LeapSecondApplier.openReader(correctionFileLoc);
        while ((nextLine = in.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(nextLine, ";");
            String unitId = st.nextToken();
            MicroSecondDate date = LeapSecondApplier.stringToMicroSecondDate(st.nextToken());
            if (unitIdToCorrections.containsKey(unitId)) {
                ((List)unitIdToCorrections.get(unitId)).add(date);
                continue;
            }
            unitIdToCorrections.put(unitId, new LinkedList());
            ((List)unitIdToCorrections.get(unitId)).add(date);
        }
    }

    private static BufferedReader openReader(String loc) throws FileNotFoundException {
        File f = new File(loc);
        if (f.exists()) {
            return new BufferedReader(new FileReader(loc));
        }
        try {
            ClassLoader cl = LeapSecondApplier.class.getClassLoader();
            return new BufferedReader(new InputStreamReader(cl.getResourceAsStream(loc)));
        }
        catch (Throwable t) {
            throw new FileNotFoundException("Unable to find " + loc + " in filesystem or in classpath");
        }
    }

    public static MicroSecondDate applyLeapSecondCorrection(String unitId, MicroSecondDate time) {
        time = unitIdToCorrections.containsKey(unitId) ? time.subtract(new TimeInterval((double)LeapSecondApplier.howManyLeapSeconds(unitId, time), UnitImpl.SECOND)) : time.subtract(new TimeInterval((double)LeapSecondApplier.howManyLeapSeconds(time), UnitImpl.SECOND));
        return time;
    }

    private static int howManyLeapSeconds(String unitId, MicroSecondDate time) {
        int numLeapSeconds = 0;
        List powerOnTimes = (List)unitIdToCorrections.get(unitId);
        MicroSecondTimeRange timeWindow = null;
        Iterator i = leapSecondOccurrences.iterator();
        while (i.hasNext()) {
            MicroSecondDate leapSecondOccurance = (MicroSecondDate)i.next();
            Iterator j = powerOnTimes.iterator();
            while (j.hasNext()) {
                MicroSecondDate powerOnTime = (MicroSecondDate)j.next();
                if (!powerOnTime.after((Date)leapSecondOccurance)) continue;
                MicroSecondTimeRange temp = new MicroSecondTimeRange(leapSecondOccurance, powerOnTime);
                if (timeWindow == null) {
                    timeWindow = temp;
                    continue;
                }
                if (!(temp.getInterval().value < timeWindow.getInterval().value)) continue;
                timeWindow = temp;
            }
            if (timeWindow != null && timeWindow.contains(time)) {
                ++numLeapSeconds;
            }
            timeWindow = null;
        }
        return numLeapSeconds;
    }

    private static int howManyLeapSeconds(MicroSecondDate time) {
        int numLeapSeconds = 0;
        Iterator i = leapSecondOccurrences.iterator();
        while (i.hasNext()) {
            MicroSecondDate leapSecondOccurance = (MicroSecondDate)i.next();
            if (!time.after((Date)leapSecondOccurance)) continue;
            ++numLeapSeconds;
        }
        return numLeapSeconds;
    }

    private static MicroSecondDate stringToMicroSecondDate(String date) throws ParseException {
        return new MicroSecondDate(format.parse(date));
    }

    public static List getLeapSecondOccurances() {
        return leapSecondOccurrences;
    }

    public static List getPowerUpTimes(String unitId) {
        return (List)unitIdToCorrections.get(unitId);
    }

    static {
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

