/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.rt130;

import edu.iris.Fissures.IfTimeSeries.EncodedData;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.sc.seis.fissuresUtil.rt130.BCDRead;
import edu.sc.seis.fissuresUtil.rt130.HexRead;
import edu.sc.seis.fissuresUtil.rt130.RT130FormatException;
import edu.sc.seis.fissuresUtil.rt130.packetTypes.AuxiliaryDataParameterPacket;
import edu.sc.seis.fissuresUtil.rt130.packetTypes.CalibrationParameterPacket;
import edu.sc.seis.fissuresUtil.rt130.packetTypes.DataPacket;
import edu.sc.seis.fissuresUtil.rt130.packetTypes.DataStreamParameterPacket;
import edu.sc.seis.fissuresUtil.rt130.packetTypes.EventHeaderPacket;
import edu.sc.seis.fissuresUtil.rt130.packetTypes.EventTrailerPacket;
import edu.sc.seis.fissuresUtil.rt130.packetTypes.OperatingModeParameterPacket;
import edu.sc.seis.fissuresUtil.rt130.packetTypes.StateOfHealthPacket;
import edu.sc.seis.fissuresUtil.rt130.packetTypes.StationChannelParameterPacket;
import java.io.DataInput;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class PacketType {
    private static DateFormat df = new SimpleDateFormat("yyDDDHHmmssSSS");
    protected String packetType;
    protected String unitIdNumber;
    protected MicroSecondDate time;
    public String[] channel_name;
    public MicroSecondDate begin_time_from_state_of_health_file;
    protected MicroSecondDate begin_time_of_seismogram;
    protected MicroSecondDate begin_time_of_first_packet;
    protected MicroSecondDate end_time_of_last_packet;
    protected int experimentNumber;
    protected int year;
    protected int byteCount;
    protected int packetSequence;
    public int sample_rate;
    protected int number_of_samples;
    protected int channel_number;
    protected int data_stream_number;
    protected int number_of_location_readings = -1;
    protected float latitude_;
    protected float longitude_;
    protected double elevation_;
    public EncodedData[] encoded_data;
    public AuxiliaryDataParameterPacket aDPP;
    public CalibrationParameterPacket cPP;
    public DataStreamParameterPacket dSPP;
    public DataPacket dP;
    public EventHeaderPacket eHP;
    public EventTrailerPacket eTP;
    public OperatingModeParameterPacket oMPP;
    public StationChannelParameterPacket sCPP;
    public StateOfHealthPacket sOHP;

    public PacketType() {
        this.encoded_data = new EncodedData[0];
    }

    public PacketType(DataInput in, boolean processData) throws IOException, RT130FormatException {
        this.encoded_data = new EncodedData[0];
        this.readNextPacket(in, processData);
    }

    public PacketType(PacketType original) throws RT130FormatException {
        this.packetType = original.packetType;
        this.unitIdNumber = original.unitIdNumber;
        this.time = original.time;
        this.begin_time_of_seismogram = original.begin_time_of_seismogram;
        this.begin_time_of_first_packet = original.begin_time_of_first_packet;
        this.end_time_of_last_packet = original.end_time_of_last_packet;
        this.experimentNumber = original.experimentNumber;
        this.year = original.year;
        this.byteCount = original.byteCount;
        this.packetSequence = original.packetSequence;
        this.number_of_samples = original.number_of_samples;
        this.sample_rate = original.sample_rate;
        if (original.encoded_data != null) {
            this.encoded_data = new EncodedData[original.encoded_data.length];
            System.arraycopy(original.encoded_data, 0, this.encoded_data, 0, original.encoded_data.length);
        }
        this.begin_time_from_state_of_health_file = original.begin_time_from_state_of_health_file;
        this.latitude_ = original.latitude_;
        this.longitude_ = original.longitude_;
        this.elevation_ = original.elevation_;
        this.number_of_location_readings = original.number_of_location_readings;
        if (original.channel_name != null) {
            this.channel_name = new String[original.channel_name.length];
            System.arraycopy(original.channel_name, 0, this.channel_name, 0, original.channel_name.length);
        }
        this.channel_number = original.channel_number;
        this.data_stream_number = original.data_stream_number;
        if (original.aDPP != null) {
            this.aDPP = new AuxiliaryDataParameterPacket(original.aDPP);
        }
        if (original.cPP != null) {
            this.cPP = new CalibrationParameterPacket(original.cPP);
        }
        if (original.dSPP != null) {
            this.dSPP = new DataStreamParameterPacket(original.dSPP);
        }
        if (original.dP != null) {
            this.dP = new DataPacket(original.dP);
        }
        if (original.eHP != null) {
            this.eHP = new EventHeaderPacket(original.eHP);
        }
        if (original.eTP != null) {
            this.eTP = new EventTrailerPacket(original.eTP);
        }
        if (original.oMPP != null) {
            this.oMPP = new OperatingModeParameterPacket(original.oMPP);
        }
        if (original.sCPP != null) {
            this.sCPP = new StationChannelParameterPacket(original.sCPP);
        }
        if (original.sOHP != null) {
            this.sOHP = new StateOfHealthPacket(original.sOHP);
        }
    }

    public void readNextPacket(DataInput in, boolean processData) throws IOException, RT130FormatException {
        this.packetType = new String(this.readBytes(in, 2));
        if (!(this.packetType.equals("AD") || this.packetType.equals("CD") || this.packetType.equals("DS") || this.packetType.equals("DT") || this.packetType.equals("EH") || this.packetType.equals("ET") || this.packetType.equals("OM") || this.packetType.equals("SC") || this.packetType.equals("SH"))) {
            throw new RT130FormatException("First two bytes of Packet Header were not formatted correctly, and do not refer to a valid Packet Type.");
        }
        this.experimentNumber = BCDRead.toInt(this.readBytes(in, 1));
        this.year = BCDRead.toInt(this.readBytes(in, 1));
        this.unitIdNumber = HexRead.toString(this.readBytes(in, 2));
        String timeString = BCDRead.toString(this.readBytes(in, 6));
        this.begin_time_of_first_packet = this.time = this.stringToMicroSecondDate(timeString, this.year);
        this.byteCount = BCDRead.toInt(this.readBytes(in, 2));
        this.packetSequence = BCDRead.toInt(this.readBytes(in, 2));
        if (this.packetType.equals("AD")) {
            this.aDPP = new AuxiliaryDataParameterPacket(in);
        } else if (this.packetType.equals("CD")) {
            this.cPP = new CalibrationParameterPacket(in);
        } else if (this.packetType.equals("DS")) {
            this.dSPP = new DataStreamParameterPacket(in);
        } else if (this.packetType.equals("DT")) {
            this.dP = new DataPacket(in, processData);
            if (processData) {
                this.encoded_data = new EncodedData[1];
                this.encoded_data[0] = new EncodedData(10, this.dP.dataFrames, this.dP.numberOfSamples, false);
            } else {
                this.encoded_data = new EncodedData[0];
            }
            this.channel_number = this.dP.channelNumber;
        } else if (this.packetType.equals("EH")) {
            this.eHP = new EventHeaderPacket(in);
            this.begin_time_of_seismogram = this.time;
            this.end_time_of_last_packet = this.time;
            this.sample_rate = Integer.valueOf(this.eHP.sampleRate.trim());
        } else if (this.packetType.equals("ET")) {
            this.eTP = new EventTrailerPacket(in);
            this.sample_rate = Integer.valueOf(this.eTP.sampleRate.trim());
        } else if (this.packetType.equals("OM")) {
            this.oMPP = new OperatingModeParameterPacket(in);
        } else if (this.packetType.equals("SC")) {
            this.sCPP = new StationChannelParameterPacket(in);
            this.channel_name = this.sCPP.channelName;
        } else if (this.packetType.equals("SH")) {
            this.sOHP = new StateOfHealthPacket(in);
        } else {
            throw new RT130FormatException("First two bytes of Packet Header were not formatted correctly, and do not refer to a valid Packet Type.");
        }
    }

    private byte[] readBytes(DataInput in, int numBytes) throws IOException {
        byte[] seqBytes = new byte[numBytes];
        in.readFully(seqBytes);
        return seqBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MicroSecondDate stringToMicroSecondDate(String timeString, int yearInt) throws RT130FormatException {
        timeString = yearInt < 10 ? "0" + yearInt + timeString : yearInt + timeString;
        try {
            Date d;
            DateFormat dateFormat = df;
            synchronized (dateFormat) {
                d = df.parse(timeString);
            }
            return new MicroSecondDate(d);
        }
        catch (ParseException e) {
            throw new RT130FormatException("Couldn't understand time string " + timeString + ".  " + e.getMessage());
        }
    }

    static {
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

