/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.rt130;

import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.xml.UnsupportedFileTypeException;
import java.net.MalformedURLException;
import java.net.URL;

public class RT130FileHandlerFlag {
    public static final RT130FileHandlerFlag SCAN = new RT130FileHandlerFlag("scan", 1);
    public static final RT130FileHandlerFlag FULL = new RT130FileHandlerFlag("full", 2);
    public static final RT130FileHandlerFlag NO_LOGS = new RT130FileHandlerFlag("nologs", 3);
    public static final RT130FileHandlerFlag MAKE_LOGS = new RT130FileHandlerFlag("nologs", 4);
    public static final String URL_PREFIX = "http://www.seis.sc.edu/xml/RT130FileHandlerMode/";
    private String val;
    private int intVal;

    private RT130FileHandlerFlag(String val, int intVal) {
        this.val = val;
        this.intVal = intVal;
    }

    public String toString() {
        return this.getValue();
    }

    public String getValue() {
        return this.val;
    }

    public int getIntValue() {
        return this.intVal;
    }

    public URL getURLValue() {
        try {
            return new URL(URL_PREFIX + this.getValue());
        }
        catch (MalformedURLException e) {
            GlobalExceptionHandler.handle("Trouble creating URL for file type " + this.getValue(), e);
            return null;
        }
    }

    public static RT130FileHandlerFlag fromString(String modeURL) throws UnsupportedFileTypeException {
        if (modeURL.equals(SCAN.getURLValue().toString())) {
            return SCAN;
        }
        if (modeURL.equals(FULL.getURLValue().toString())) {
            return FULL;
        }
        if (modeURL.equals(NO_LOGS.getURLValue().toString())) {
            return NO_LOGS;
        }
        if (modeURL.equals(MAKE_LOGS.getURLValue().toString())) {
            return MAKE_LOGS;
        }
        throw new UnsupportedFileTypeException(modeURL);
    }

    public static RT130FileHandlerFlag fromInt(int type) throws UnsupportedFileTypeException {
        if (type == SCAN.getIntValue()) {
            return SCAN;
        }
        if (type == FULL.getIntValue()) {
            return FULL;
        }
        if (type == NO_LOGS.getIntValue()) {
            return NO_LOGS;
        }
        if (type == MAKE_LOGS.getIntValue()) {
            return MAKE_LOGS;
        }
        throw new UnsupportedFileTypeException("" + type);
    }
}

