/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.rt130;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfNetwork.Site;
import edu.iris.Fissures.IfNetwork.SiteId;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.IfTimeSeries.TimeSeriesDataSel;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.LocationType;
import edu.iris.Fissures.Orientation;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Sampling;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.SamplingImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.TimeUtils;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.SiteImpl;
import edu.iris.Fissures.network.StationImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.database.seismogram.PopulationProperties;
import edu.sc.seis.fissuresUtil.mockFissures.IfNetwork.MockNetworkId;
import edu.sc.seis.fissuresUtil.rt130.LeapSecondApplier;
import edu.sc.seis.fissuresUtil.rt130.NCFile;
import edu.sc.seis.fissuresUtil.rt130.PacketType;
import edu.sc.seis.fissuresUtil.rt130.PropParser;
import edu.sc.seis.fissuresUtil.rt130.XYReader;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class RT130ToLocalSeismogram {
    private NetworkId networkId;
    private Channel[] channel;
    private NetworkAttr networkAttr;
    public static final String DATA_STREAM = "dataStream";
    private NCFile ncFile;
    private Map stationLocations;
    private Map dataStreamToSampleRate;
    private static final Logger logger = Logger.getLogger((Class)RT130ToLocalSeismogram.class);

    public RT130ToLocalSeismogram() {
        this.ncFile = null;
        this.stationLocations = null;
    }

    public static RT130ToLocalSeismogram create(Properties props) throws FileNotFoundException, IOException {
        PropParser pp = new PropParser(props);
        NCFile ncFile = new NCFile(pp.getPath("NCFile"));
        logger.debug((Object)("NC file location: " + ncFile.getCanonicalPath()));
        String xyFileLoc = pp.getPath("XYFile");
        logger.debug((Object)("XY file location: " + xyFileLoc));
        Map stationLocations = XYReader.read(new BufferedReader(new FileReader(xyFileLoc)));
        HashMap<Integer, Integer> dataStreamToSampleRate = new HashMap<Integer, Integer>();
        for (int i = 1; i < 7; ++i) {
            if (!props.containsKey(DATA_STREAM + i)) continue;
            dataStreamToSampleRate.put(new Integer(i - 1), new Integer(pp.getInt("dataStream." + i)));
        }
        NetworkAttrImpl attr = PopulationProperties.getNetworkAttr(props);
        return new RT130ToLocalSeismogram(ncFile, stationLocations, dataStreamToSampleRate, (NetworkAttr)attr);
    }

    public RT130ToLocalSeismogram(NCFile ncFile, Map stationLocations, Map dataStreamToSampleRate, NetworkAttr attr) {
        this.ncFile = ncFile;
        this.stationLocations = stationLocations;
        this.dataStreamToSampleRate = dataStreamToSampleRate;
        this.networkAttr = attr;
    }

    public LocalSeismogramImpl[] ConvertRT130ToLocalSeismogram(PacketType[] seismogramDataPacket) {
        LocalSeismogramImpl[] seismogramDataArray = new LocalSeismogramImpl[seismogramDataPacket.length];
        this.channel = new Channel[seismogramDataPacket.length];
        for (int i = 0; i < seismogramDataPacket.length; ++i) {
            seismogramDataArray[i] = this.ConvertRT130ToLocalSeismogram(seismogramDataPacket[i], i);
        }
        return seismogramDataArray;
    }

    public LocalSeismogramImpl ConvertRT130ToLocalSeismogram(PacketType seismogramData, int i) {
        ChannelId channelId;
        Time mockBeginTimeOfChannel = seismogramData.begin_time_from_state_of_health_file.getFissuresTime();
        int numPoints = seismogramData.number_of_samples;
        if (seismogramData.sample_rate == 0) {
            logger.debug((Object)"A sample rate of 0 samples per second was detected.");
            Integer dataStream = new Integer(seismogramData.data_stream_number);
            if (this.dataStreamToSampleRate.containsKey(dataStream)) {
                seismogramData.sample_rate = (Integer)this.dataStreamToSampleRate.get(dataStream);
                logger.debug((Object)("The sample rate of " + seismogramData.sample_rate + " was found in the props file, and will be used."));
            } else {
                logger.error((Object)"The props file does not contain a sample rate for this data stream, and can not be used to correct the problem.");
            }
        }
        SamplingImpl sampling = new SamplingImpl(seismogramData.sample_rate, new TimeInterval(1.0, UnitImpl.SECOND));
        if (this.ncFile == null) {
            channelId = new ChannelId(MockNetworkId.createNetworkID(), seismogramData.unitIdNumber, "" + seismogramData.data_stream_number, "BH" + seismogramData.channel_name[seismogramData.channel_number], mockBeginTimeOfChannel);
        } else {
            this.channel[i] = this.createChannel(seismogramData, (Sampling)sampling);
            channelId = this.channel[i].get_id();
        }
        String id = channelId.toString();
        TimeSeriesDataSel timeSeriesDataSel = new TimeSeriesDataSel();
        timeSeriesDataSel.encoded_values(seismogramData.encoded_data);
        MicroSecondDate beginTimeOfSeismogram = LeapSecondApplier.applyLeapSecondCorrection(seismogramData.unitIdNumber, seismogramData.begin_time_of_seismogram);
        return new LocalSeismogramImpl(id, beginTimeOfSeismogram.getFissuresTime(), numPoints, (Sampling)sampling, (Unit)UnitImpl.COUNT, channelId, timeSeriesDataSel);
    }

    private Channel createChannel(PacketType seismogramData, Sampling sampling) {
        String stationCode = this.ncFile.getUnitName(seismogramData.begin_time_from_state_of_health_file, seismogramData.unitIdNumber);
        Time networkBeginTime = this.ncFile.network_begin_time.getFissuresTime();
        Time channelBeginTime = seismogramData.begin_time_from_state_of_health_file.getFissuresTime();
        this.networkId.begin_time = networkBeginTime;
        String tempCode = "B";
        if (seismogramData.sample_rate < 10) {
            tempCode = "L";
        }
        ChannelId channelId = new ChannelId(this.networkId, stationCode, "00", tempCode + "H" + seismogramData.channel_name[seismogramData.channel_number], channelBeginTime);
        TimeRange effectiveChannelTime = new TimeRange(channelBeginTime, TimeUtils.timeUnknown);
        SiteId siteId = new SiteId(this.networkId, stationCode, "00", channelBeginTime);
        StationId stationId = new StationId(this.networkId, stationCode, channelBeginTime);
        Location location = new Location(0.0f, 0.0f, (Quantity)new QuantityImpl(0.0, (Unit)UnitImpl.METER), (Quantity)new QuantityImpl(0.0, (Unit)UnitImpl.METER), LocationType.GEOGRAPHIC);
        if (this.stationLocations.containsKey(stationCode)) {
            location = (Location)this.stationLocations.get(stationCode);
        } else {
            logger.error((Object)("XY file did not contain a location for unit " + stationCode + ".\n" + "The location used for the unit will be the Gulf of Guinea (Atlantic Ocean)."));
        }
        StationImpl station = new StationImpl(stationId, stationCode, location, effectiveChannelTime, "", "", "", this.networkAttr);
        SiteImpl site = new SiteImpl(siteId, location, effectiveChannelTime, (Station)station, "");
        ChannelImpl newChannel = new ChannelImpl(channelId, "", new Orientation(0.0f, 0.0f), sampling, effectiveChannelTime, (Site)site);
        if (channelId.channel_code.endsWith("N")) {
            newChannel.an_orientation = new Orientation(0.0f, 0.0f);
        } else if (channelId.channel_code.endsWith("E")) {
            newChannel.an_orientation = new Orientation(90.0f, 0.0f);
        } else if (channelId.channel_code.endsWith("Z")) {
            newChannel.an_orientation = new Orientation(0.0f, -90.0f);
        }
        return newChannel;
    }

    public Channel[] getChannels() {
        return this.channel;
    }
}

