/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.rt130;

import edu.iris.Fissures.Location;
import edu.iris.Fissures.LocationType;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class XYReader {
    public static final String XY_FILE_LOC = "XYFile";
    private static final Logger logger = Logger.getLogger((Class)XYReader.class);

    public static Map read(BufferedReader reader) throws IOException {
        String line;
        HashMap<String, Location> locs = new HashMap<String, Location>();
        while ((line = reader.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(line, " ");
            Location loc = new Location();
            loc.longitude = Float.parseFloat(st.nextToken());
            loc.latitude = Float.parseFloat(st.nextToken());
            loc.elevation = new QuantityImpl((double)Float.parseFloat(st.nextToken()), (Unit)UnitImpl.METER);
            loc.depth = new QuantityImpl(0.0, (Unit)UnitImpl.METER);
            loc.type = LocationType.GEOGRAPHIC;
            String stationCode = st.nextToken();
            locs.put(stationCode, loc);
            logger.debug((Object)("Read in location for " + stationCode + " " + XYReader.toString(loc)));
        }
        return locs;
    }

    public static String toString(Location loc) {
        return "Lat: " + loc.latitude + " Long: " + loc.longitude + " Elev: " + loc.elevation;
    }
}

