/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.sac;

import edu.sc.seis.fissuresUtil.display.TextTable;
import edu.sc.seis.fissuresUtil.freq.Cmplx;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;

public class SacPoleZero {
    Cmplx[] poles;
    Cmplx[] zeros;
    float constant;
    static String POLES = "POLES";
    static String ZEROS = "ZEROS";
    static String CONSTANT = "CONSTANT";
    protected static DecimalFormat formatter = new DecimalFormat("0.0000;-0.0000");

    public SacPoleZero(Cmplx[] poles, Cmplx[] zeros, float constant) {
        this.poles = poles;
        this.zeros = zeros;
        this.constant = constant;
    }

    public float getConstant() {
        return this.constant;
    }

    public Cmplx[] getPoles() {
        return this.poles;
    }

    public Cmplx[] getZeros() {
        return this.zeros;
    }

    public String toString() {
        TextTable textTable = new TextTable(2);
        String[] zeroHeader = new String[]{ZEROS, "" + this.zeros.length};
        SacPoleZero.addToTable(textTable, zeroHeader, this.zeros);
        String[] poleHeader = new String[]{POLES, "" + this.poles.length};
        SacPoleZero.addToTable(textTable, poleHeader, this.poles);
        String[] sensitivityHeader = new String[]{CONSTANT, "" + this.constant};
        textTable.addRow(sensitivityHeader);
        return textTable.toString();
    }

    static void addToTable(TextTable table, String[] header, Cmplx[] values) {
        table.addRow(header);
        for (int cnt = 0; cnt < values.length; ++cnt) {
            if (values[cnt].r == 0.0 && values[cnt].i == 0.0) continue;
            String[] realImg = new String[]{formatter.format(values[cnt].r), formatter.format(values[cnt].i)};
            table.addRow(realImg);
        }
    }

    public static SacPoleZero read(BufferedReader in) throws IOException {
        String s;
        ArrayList<String> lines = new ArrayList<String>();
        while ((s = in.readLine()) != null) {
            lines.add(s.trim());
        }
        Cmplx[] poles = new Cmplx[]{};
        Cmplx[] zeros = new Cmplx[]{};
        float constant = 1.0f;
        Iterator it = lines.iterator();
        String line = SacPoleZero.nextLine(it);
        while (!line.equals("")) {
            int i;
            String num;
            if (line.startsWith(POLES)) {
                num = line.substring(POLES.length()).trim();
                int numPoles = Integer.parseInt(num);
                poles = SacPoleZero.initCmplx(numPoles);
                line = SacPoleZero.nextLine(it);
                for (i = 0; i < poles.length && it.hasNext() && line.matches("^-?\\d+\\.\\d+\\s+-?\\d+\\.\\d+"); ++i) {
                    poles[i] = SacPoleZero.parseCmplx(line);
                    line = SacPoleZero.nextLine(it);
                }
                continue;
            }
            if (line.startsWith(ZEROS)) {
                num = line.substring(ZEROS.length()).trim();
                int numZeros = Integer.parseInt(num);
                zeros = SacPoleZero.initCmplx(numZeros);
                line = SacPoleZero.nextLine(it);
                for (i = 0; i < zeros.length && it.hasNext() && line.matches("^-?\\d+\\.\\d+\\s+-?\\d+\\.\\d+"); ++i) {
                    zeros[i] = SacPoleZero.parseCmplx(line);
                    line = SacPoleZero.nextLine(it);
                }
                continue;
            }
            if (line.startsWith(CONSTANT)) {
                line = line.replaceAll("\\s+", " ");
                String[] sline = line.split(" ");
                constant = Float.parseFloat(sline[1]);
                line = SacPoleZero.nextLine(it);
                continue;
            }
            throw new IOException("Unknown line in SAC polezero file: " + line);
        }
        return new SacPoleZero(poles, zeros, constant);
    }

    private static String nextLine(Iterator it) {
        if (it.hasNext()) {
            return (String)it.next();
        }
        return "";
    }

    static Cmplx[] initCmplx(int length) {
        Cmplx[] out = new Cmplx[length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = new Cmplx(0.0, 0.0);
        }
        return out;
    }

    static Cmplx parseCmplx(String line) throws IOException {
        line = line.trim().replaceAll("\\s+", " ");
        String[] sline = line.split(" ");
        return new Cmplx(Float.parseFloat(sline[0]), Float.parseFloat(sline[1]));
    }

    public boolean close(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof SacPoleZero) {
            SacPoleZero spz = (SacPoleZero)obj;
            if (!SacPoleZero.close(spz.constant, this.constant)) {
                System.out.println("const not close");
                return false;
            }
            return this.closeButConstant(obj);
        }
        return false;
    }

    public boolean closeButConstant(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof SacPoleZero) {
            int i;
            SacPoleZero spz = (SacPoleZero)obj;
            if (spz.poles.length != this.poles.length || spz.zeros.length != this.zeros.length) {
                return false;
            }
            for (i = 0; i < this.poles.length; ++i) {
                if (SacPoleZero.closeFourDigit(spz.poles[i], this.poles[i])) continue;
                System.out.println("pole " + i + " not equal" + spz.poles[i].i + " " + this.poles[i].i + " " + spz.poles[i].r + " " + this.poles[i].r);
                return false;
            }
            for (i = 0; i < this.zeros.length; ++i) {
                if (SacPoleZero.closeFourDigit(spz.zeros[i], this.zeros[i])) continue;
                System.out.println("zero " + i + " not equal");
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean close(double a, double b) {
        if (Math.abs(a - b) / a > 1.0E-4) {
            System.out.println("fail close " + a + " " + b + " " + Math.abs(a - b) / a + " ratio=" + a / b);
            return false;
        }
        return true;
    }

    private static boolean closeFourDigit(Cmplx a, Cmplx b) {
        return SacPoleZero.closeFourDigit(a.r, b.r) && SacPoleZero.closeFourDigit(a.i, b.i);
    }

    private static boolean closeFourDigit(double a, double b) {
        if (Math.abs(a - b) > 1.0E-4) {
            System.out.println("fail closeFourDigit " + a + " " + b + " " + Math.abs(a - b) + " ratio=" + a / b);
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof SacPoleZero) {
            int i;
            SacPoleZero spz = (SacPoleZero)obj;
            if ((double)(Math.abs(spz.constant - this.constant) / this.constant) > 0.001) {
                System.out.println("const not equal");
                return false;
            }
            if (spz.poles.length != this.poles.length || spz.zeros.length != this.zeros.length) {
                return false;
            }
            for (i = 0; i < this.poles.length; ++i) {
                if (spz.poles[i].i == this.poles[i].i && spz.poles[i].r == this.poles[i].r) continue;
                System.out.println("pole " + i + " not equal" + spz.poles[i].i + " " + this.poles[i].i + " " + spz.poles[i].r + " " + this.poles[i].r);
                return false;
            }
            for (i = 0; i < this.zeros.length; ++i) {
                if (spz.zeros[i].i == this.zeros[i].i && spz.zeros[i].r == this.zeros[i].r) continue;
                System.out.println("zero " + i + " not equal");
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        long tmp;
        int j;
        int i = 17;
        i = 37 * i + this.poles.length;
        i = 37 * i + this.zeros.length;
        for (j = 0; j < this.poles.length; ++j) {
            tmp = Double.doubleToLongBits(this.poles[j].i);
            i = 37 * i + (int)(tmp ^ tmp >>> 32);
            tmp = Double.doubleToLongBits(this.poles[j].r);
            i = 37 * i + (int)(tmp ^ tmp >>> 32);
        }
        for (j = 0; j < this.zeros.length; ++j) {
            tmp = Double.doubleToLongBits(this.zeros[j].i);
            i = 37 * i + (int)(tmp ^ tmp >>> 32);
            tmp = Double.doubleToLongBits(this.zeros[j].r);
            i = 37 * i + (int)(tmp ^ tmp >>> 32);
        }
        return i;
    }
}

