/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.simple;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.simple.Initializer;
import edu.sc.seis.fissuresUtil.simple.SimpleSeismogramClient;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.apache.log4j.Logger;

public class SeismogramSpeedCheck
extends SimpleSeismogramClient {
    private static final Logger logger = Logger.getLogger((Class)SeismogramSpeedCheck.class);

    public void exercise() {
        MicroSecondDate start;
        int i;
        TimeInterval oneDay = new TimeInterval(1.0, UnitImpl.DAY);
        TimeInterval oneHour = new TimeInterval(1.0, UnitImpl.HOUR);
        MicroSecondDate now = ClockUtil.now();
        MicroSecondDate yesterday = now.subtract(oneDay);
        TimeInterval[] requestSizes = new TimeInterval[]{new TimeInterval(1.0, UnitImpl.MINUTE), oneHour, (TimeInterval)oneHour.multiplyBy(6.0), oneDay};
        RequestFilter[][] reqs = new RequestFilter[requestSizes.length][];
        for (i = 0; i < reqs.length; ++i) {
            requestSizes[i].setFormat((NumberFormat)new DecimalFormat("0"));
            start = yesterday.subtract((TimeInterval)oneDay.multiplyBy((double)i));
            reqs[i] = SeismogramSpeedCheck.createRF(start, start.add(requestSizes[i]));
        }
        this.retrieve_seismograms(false);
        for (i = 0; i < reqs.length; ++i) {
            start = ClockUtil.now();
            try {
                this.seisDC.retrieve_seismograms(reqs[i]);
            }
            catch (FissuresException e) {
                throw new RuntimeException(e);
            }
            MicroSecondDate end = ClockUtil.now();
            TimeInterval callTime = (TimeInterval)end.subtract(start).convertTo(UnitImpl.SECOND);
            callTime.setFormat((NumberFormat)new DecimalFormat("0.000"));
            System.out.println(requestSizes[i] + " request took " + callTime);
        }
    }

    public static void main(String[] args) {
        Initializer.init(args);
        new SeismogramSpeedCheck().exercise();
    }
}

