/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.simple;

import edu.iris.Fissures.Area;
import edu.iris.Fissures.IfEvent.EventAccess;
import edu.iris.Fissures.IfEvent.EventAttr;
import edu.iris.Fissures.IfEvent.EventDC;
import edu.iris.Fissures.IfEvent.EventFinder;
import edu.iris.Fissures.IfEvent.EventSeqIterHolder;
import edu.iris.Fissures.IfEvent.NoPreferredOrigin;
import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.GlobalAreaImpl;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.simple.Initializer;
import edu.sc.seis.fissuresUtil.simple.TestingClient;
import java.util.Calendar;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;

public class SimpleEventClient
implements TestingClient {
    protected EventFinder finder;
    String serverDNS;
    String serverName;
    private static final TimeInterval ONE_DAY = new TimeInterval(1.0, UnitImpl.DAY);
    private static Logger logger = Logger.getLogger((Class)SimpleEventClient.class);

    public SimpleEventClient() {
        this("edu/iris/dmc", "IRIS_EventDC");
    }

    public SimpleEventClient(String serverDNS, String serverName) {
        try {
            this.serverDNS = serverDNS;
            this.serverName = serverName;
            Initializer.getNS().getEventDCObject(serverDNS, serverName);
            logger.info((Object)"Got EventDC as corba object, the name service is ok");
            EventDC eventDC = Initializer.getNS().getEventDC(serverDNS, serverName);
            logger.info((Object)"got EventDC");
            this.finder = eventDC.a_finder();
            logger.info((Object)"got EventFinder");
        }
        catch (InvalidName e) {
            logger.error((Object)"Problem with name service: ", (Throwable)e);
        }
        catch (NotFound e) {
            logger.error((Object)"Problem with name service: ", (Throwable)e);
        }
        catch (CannotProceed e) {
            logger.error((Object)"Problem with name service: ", (Throwable)e);
        }
    }

    public void exercise() {
        EventAccess[] events = this.query_events(true);
        for (int i = 0; i < events.length; ++i) {
            this.get_attributes(events[i]);
            try {
                this.get_preferred_origin(events[i], true);
                continue;
            }
            catch (NoPreferredOrigin e) {
                logger.warn((Object)("No preferred origin for event " + i), (Throwable)e);
            }
        }
    }

    public EventAccess[] query_events() {
        return this.query_events(false);
    }

    public EventAccess[] query_events(boolean verbose) {
        String[] contributors;
        String[] catalogs;
        String[] magTypes;
        TimeRange timeRange;
        EventAccess[] events;
        EventSeqIterHolder iter = new EventSeqIterHolder();
        MicroSecondDate end = ClockUtil.now();
        MicroSecondDate start = end.subtract(ONE_DAY);
        if (this.serverName.equals("NCSN_EventDC") || this.serverName.equals("Memphis")) {
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            cal.set(2000, 0, 7);
            start = new MicroSecondDate(cal.getTime());
            cal.set(2000, 0, 9);
            end = new MicroSecondDate(cal.getTime());
        }
        if ((events = this.finder.query_events((Area)new GlobalAreaImpl(), (Quantity)new QuantityImpl(0.0, (Unit)UnitImpl.KILOMETER), (Quantity)new QuantityImpl(1000.0, (Unit)UnitImpl.KILOMETER), timeRange = new TimeRange(start.getFissuresTime(), end.getFissuresTime()), magTypes = new String[0], 1.0f, 10.0f, catalogs = new String[0], contributors = new String[0], 500, iter)).length == 0) {
            logger.warn((Object)"*** Warning, no events returned for query. ***");
        }
        if (verbose) {
            logger.info((Object)("Got " + events.length + " events."));
        }
        return events;
    }

    public Origin get_preferred_origin(EventAccess ev) throws NoPreferredOrigin {
        return this.get_preferred_origin(ev, false);
    }

    public Origin get_preferred_origin(EventAccess ev, boolean verbose) throws NoPreferredOrigin {
        Origin o = ev.get_preferred_origin();
        if (o.magnitudes.length == 0) {
            logger.error((Object)("Origin has zero magnitudes: " + o.origin_time.date_time + " at (" + o.my_location.latitude + ", " + o.my_location.longitude + ") " + "with depth of " + o.my_location.depth.value + " " + o.my_location.depth.the_units));
        } else if (verbose) {
            logger.info((Object)("Event occurred at " + o.origin_time.date_time + " mag=" + o.magnitudes[0].type + " " + o.magnitudes[0].value + " at (" + o.my_location.latitude + ", " + o.my_location.longitude + ") " + "with depth of " + o.my_location.depth.value + " " + o.my_location.depth.the_units));
        }
        return o;
    }

    public EventAttr get_attributes(EventAccess ea) {
        return ea.get_attributes();
    }

    public static void main(String[] args) {
        BasicConfigurator.configure();
        Initializer.init(args);
        Properties props = Initializer.getProps();
        try {
            SimpleEventClient client = props.containsKey("serverName") && props.containsKey("serverDNS") ? new SimpleEventClient(props.getProperty("serverDNS"), props.getProperty("serverName")) : new SimpleEventClient();
            client.exercise();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

