/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.simple;

import edu.sc.seis.fissuresUtil.simple.Initializer;
import edu.sc.seis.fissuresUtil.simple.ThreadedEventClient;
import edu.sc.seis.fissuresUtil.simple.ThreadedNetClient;
import edu.sc.seis.fissuresUtil.simple.ThreadedSeisClient;
import java.io.PrintWriter;
import org.apache.log4j.Logger;

public class Tester {
    private static Logger logger = Logger.getLogger((Class)Tester.class);

    public static void runAll(Runnable[] runnables) throws Throwable {
        Tester.runAll(runnables, 10, null);
    }

    public static void runAll(Runnable[] runnables, int runsPerThread, PrintWriter out) throws Throwable {
        Tester t = new Tester();
        for (int i = 0; i < runnables.length; ++i) {
            for (int j = i; j < runnables.length; ++j) {
                Tester tester = t;
                tester.getClass();
                Repeater iRepeater = tester.new Repeater(runnables[i], runsPerThread);
                Tester tester2 = t;
                tester2.getClass();
                Repeater jRepeater = tester2.new Repeater(runnables[j], runsPerThread);
                logger.info((Object)("Starting " + iRepeater + " against " + jRepeater));
                if (out != null) {
                    out.println("Starting <b>" + iRepeater + "</b> against <b>" + jRepeater + "</b><br/>");
                }
                iRepeater.start();
                jRepeater.start();
                boolean joined = false;
                while (!joined) {
                    try {
                        iRepeater.join();
                        if (iRepeater.getThrown() != null) {
                            throw iRepeater.getThrown();
                        }
                        jRepeater.join();
                        if (jRepeater.getThrown() != null) {
                            throw jRepeater.getThrown();
                        }
                        joined = true;
                    }
                    catch (InterruptedException e) {}
                }
                if (out == null) continue;
                out.println("<b>" + iRepeater + "</b> against <b>" + jRepeater + "</b> is successful<br/>");
            }
        }
    }

    private static Repeater[] wrapInRepeaters(Runnable[] runnables, int repeats) {
        Tester t = new Tester();
        Repeater[] threads = new Repeater[runnables.length];
        for (int i = 0; i < runnables.length; ++i) {
            Tester tester = t;
            tester.getClass();
            threads[i] = tester.new Repeater(runnables[i], repeats);
        }
        return threads;
    }

    public static void main(String[] args) {
        Initializer.init(args);
        new ThreadedSeisClient().exercise();
        new ThreadedNetClient().exercise();
        new ThreadedEventClient().exercise();
    }

    private class Repeater
    extends Thread {
        private Throwable t;
        private Runnable r;
        private int repeats;

        public Repeater(Runnable r, int repeats) {
            this.r = r;
            this.repeats = repeats;
        }

        public void run() {
            int i = 0;
            try {
                for (i = 0; i < this.repeats; ++i) {
                    logger.info((Object)("run " + (i + 1) + " of " + this.repeats + " for " + this.r));
                    this.r.run();
                    logger.info((Object)("finished " + (i + 1) + " of " + this.repeats + " for " + this.r));
                }
            }
            catch (Throwable e) {
                this.t = e;
                logger.warn((Object)("fail " + (i + 1) + " of " + this.repeats + " for " + this.r), e);
            }
            logger.info((Object)("leave thread for " + this.r));
        }

        public Throwable getThrown() {
            return this.t;
        }

        public String toString() {
            return "" + this.r;
        }

        public Runnable getRunnable() {
            return this.r;
        }
    }
}

