/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.simple;

import edu.iris.Fissures.IfNetwork.ChannelNotFound;
import edu.iris.Fissures.IfNetwork.NetworkAccessHelper;
import edu.sc.seis.fissuresUtil.simple.Initializer;
import edu.sc.seis.fissuresUtil.simple.SimpleNetworkClient;
import edu.sc.seis.fissuresUtil.simple.Tester;
import java.util.Properties;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.omg.CORBA.Object;

public class ThreadedNetClient
extends SimpleNetworkClient {
    private static Logger logger = Logger.getLogger((Class)ThreadedNetClient.class);

    public ThreadedNetClient() {
    }

    public ThreadedNetClient(String networkCode, String serverDNS, String serverName) {
        super(networkCode, serverDNS, serverName);
    }

    public void exercise() {
        super.exercise();
        try {
            Tester.runAll(this.createRunnables());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public Runnable[] createRunnables() {
        Runnable[] runnables = new Runnable[]{new RetrieveForStation(), new RetrieveStations(), new GetAttributes(), new IORConverter(), new NetworkAccessNarrow(), new RetrieveChannel()};
        return runnables;
    }

    public static void main(String[] args) {
        BasicConfigurator.configure();
        Initializer.init(args);
        Properties props = Initializer.getProps();
        try {
            ThreadedNetClient client = props.containsKey("serverName") && props.containsKey("serverDNS") ? new ThreadedNetClient(props.getProperty("netCode", "II"), props.getProperty("serverDNS"), props.getProperty("serverName")) : new ThreadedNetClient();
            Tester.runAll(client.createRunnables());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private class RetrieveChannel
    implements Runnable {
        private RetrieveChannel() {
        }

        public void run() {
            try {
                ThreadedNetClient.this.net.retrieve_channel(ThreadedNetClient.this.testChannel.get_id());
            }
            catch (ChannelNotFound e) {
                System.err.println("This channel should always be found");
                e.printStackTrace();
                System.exit(1);
            }
        }

        public String toString() {
            return "retrieve_channel";
        }
    }

    private class RetrieveStations
    implements Runnable {
        private RetrieveStations() {
        }

        public void run() {
            ThreadedNetClient.this.retrieve_stations(false);
        }

        public String toString() {
            return "retrieve_stations";
        }
    }

    private class IORConverter
    implements Runnable {
        private IORConverter() {
        }

        public void run() {
            String ior = Initializer.getORB().object_to_string((Object)ThreadedNetClient.this.net);
            Object obj = Initializer.getORB().string_to_object(ior);
            NetworkAccessHelper.narrow((java.lang.Object)obj);
        }

        public String toString() {
            return "IORConverter";
        }
    }

    private class GetAttributes
    implements Runnable {
        private GetAttributes() {
        }

        public void run() {
            ThreadedNetClient.this.get_attributes(false);
        }

        public String toString() {
            return "get_attributes";
        }
    }

    private class RetrieveForStation
    implements Runnable {
        private RetrieveForStation() {
        }

        public void run() {
            ThreadedNetClient.this.net.retrieve_for_station(ThreadedNetClient.this.testStation.get_id());
        }

        public String toString() {
            return "retrieve_for_station";
        }
    }

    private class NetworkAccessNarrow
    implements Runnable {
        private NetworkAccessNarrow() {
        }

        public void run() {
            String ior = Initializer.getORB().object_to_string((Object)ThreadedNetClient.this.net);
            Object obj = Initializer.getORB().string_to_object(ior);
            NetworkAccessHelper.narrow((java.lang.Object)obj);
        }

        public String toString() {
            return "NetworkAccess narrow";
        }
    }
}

