/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.xml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Category;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SimpleXLink {
    protected Element element;
    protected DocumentBuilder docBuilder;
    protected URL base;
    static Category logger = Category.getInstance((String)SimpleXLink.class.getName());

    SimpleXLink(DocumentBuilder docBuilder, Element element) {
        this(docBuilder, element, null);
    }

    SimpleXLink(DocumentBuilder docBuilder, Element element, URL base) {
        this.docBuilder = docBuilder;
        this.element = element;
        this.base = base;
    }

    public Element retrieve() throws MalformedURLException, IOException, SAXException, TransformerException {
        int index;
        String xlink = this.element.getAttribute("xlink:href");
        int sharpIndex = xlink.indexOf("#");
        String fragment = "";
        if (sharpIndex != -1) {
            fragment = xlink.substring(sharpIndex + 1, xlink.length());
        }
        while ((index = fragment.indexOf("%22")) != -1) {
            fragment = fragment.substring(0, index) + '\"' + fragment.substring(index + 3);
        }
        URL url = null;
        if (xlink.startsWith("http") || xlink.startsWith("ftp")) {
            url = new URL(xlink);
        } else if (this.base != null) {
            url = new URL(this.base, xlink);
        }
        if (url != null) {
            InputStream conn = url.openStream();
            BufferedInputStream inStream = new BufferedInputStream(conn);
            Document doc = this.docBuilder.parse(inStream);
            return this.retrieve(doc, fragment);
        }
        return this.retrieve(this.element, fragment);
    }

    public Element retrieve(Node context, String path) throws MalformedURLException, IOException, SAXException, TransformerException {
        NodeList nList;
        Node n;
        logger.debug((Object)("path=" + path));
        if (context instanceof Document && (path == null || path.length() == 0)) {
            return ((Document)context).getDocumentElement();
        }
        XObject xobj = XPathAPI.eval((Node)context, (String)path);
        if (xobj.getType() == 4 && (n = (nList = xobj.nodelist()).item(0)) instanceof Element) {
            return (Element)n;
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        Document doc = docBuilder.parse(args[0]);
        Element docElement = doc.getDocumentElement();
        NodeList nList = docElement.getChildNodes();
        for (int i = 0; i < nList.getLength(); ++i) {
            Node m = nList.item(i);
            NodeList mList = m.getChildNodes();
            for (int j = 0; j < mList.getLength(); ++j) {
                Element nodeElement;
                Node n = mList.item(j);
                if (!(n instanceof Element) || !(nodeElement = (Element)n).getTagName().equals("datasetRef")) continue;
                SimpleXLink sxlink = new SimpleXLink(docBuilder, nodeElement);
                Element e = sxlink.retrieve();
            }
        }
    }
}

