/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.xml;

import edu.sc.seis.fissuresUtil.xml.XMLUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.log4j.Logger;

public class StAXFileWriter {
    private File outFile;
    private File tempFile;
    private boolean isTempFiled = false;
    private boolean isClosed = false;
    private OutputStream fileWriter;
    private XMLStreamWriter xmlWriter;
    private Logger logger = Logger.getLogger((Class)StAXFileWriter.class);

    public StAXFileWriter(File file) throws IOException, XMLStreamException {
        this.outFile = file;
        if (this.outFile.exists()) {
            this.tempFile = File.createTempFile("Temp_" + this.outFile.getName(), null, this.outFile.getAbsoluteFile().getParentFile());
            this.isTempFiled = true;
        } else {
            this.tempFile = this.outFile;
        }
        this.fileWriter = new BufferedOutputStream(new FileOutputStream(this.tempFile));
        this.xmlWriter = XMLUtil.staxOutputFactory.createXMLStreamWriter(this.fileWriter, "UTF-8");
    }

    public XMLStreamWriter getStreamWriter() {
        return this.xmlWriter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void close() throws XMLStreamException, IOException {
        if (this.isClosed) return;
        this.xmlWriter.writeEndDocument();
        this.xmlWriter.close();
        this.fileWriter.close();
        if (this.isTempFiled) {
            if (!this.tempFile.renameTo(this.outFile.getAbsoluteFile())) {
                this.logger.debug((Object)("Unable to rename " + this.tempFile + " to " + this.outFile.getAbsoluteFile()));
                if (this.outFile.delete()) {
                    this.tempFile.renameTo(this.outFile);
                } else {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    if (!this.outFile.delete()) throw new IOException("Unable to move temp file over old file");
                    this.tempFile.renameTo(this.outFile);
                }
            } else {
                this.logger.debug((Object)("Renamed " + this.tempFile + " to " + this.outFile));
            }
        }
        this.isClosed = true;
    }
}

