/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.xml;

import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.fissuresUtil.xml.SeisDataChangeEvent;
import edu.sc.seis.fissuresUtil.xml.SeisDataChangeListener;
import edu.sc.seis.fissuresUtil.xml.SeisDataErrorEvent;
import edu.sc.seis.fissuresUtil.xml.SeismogramFileTypes;
import edu.sc.seis.fissuresUtil.xml.URLDataSetSeismogram;
import java.io.File;
import java.net.URL;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class URLDataSetSeismogramSaver
implements SeisDataChangeListener {
    Throwable error;
    boolean finished = false;
    File directory;
    SeismogramFileTypes fileType;
    DataSetSeismogram inDSS;
    URLDataSetSeismogram urlDSS;
    private static Logger logger = Logger.getLogger((Class)URLDataSetSeismogramSaver.class);

    URLDataSetSeismogramSaver(DataSetSeismogram dss, File directory, SeismogramFileTypes fileType) {
        this.inDSS = dss;
        this.directory = directory;
        this.fileType = fileType;
        this.urlDSS = new URLDataSetSeismogram(new URL[0], new SeismogramFileTypes[0], this.inDSS.getDataSet(), this.inDSS.getName(), this.inDSS.getRequestFilter());
        logger.debug((Object)("req filter chanid=" + ChannelIdUtil.toString((ChannelId)this.urlDSS.getRequestFilter().channel_id)));
        dss.retrieveData(this);
        Iterator it = this.inDSS.getAuxillaryDataKeys().iterator();
        while (it.hasNext()) {
            Object next = it.next();
            this.urlDSS.addAuxillaryData(next, this.inDSS.getAuxillaryData(next));
        }
    }

    public URLDataSetSeismogram getURLDataSetSeismogram() {
        return this.urlDSS;
    }

    public boolean isError() {
        return this.error != null;
    }

    public Throwable getError() {
        return this.error;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void error(SeisDataErrorEvent sdce) {
        if (sdce.getInitiator() != this) {
            return;
        }
        logger.debug((Object)("Got error " + sdce.getCausalException()));
        this.setError(sdce.getCausalException());
    }

    public void finished(SeisDataChangeEvent sdce) {
        if (sdce.getInitiator() != this) {
            return;
        }
        logger.debug((Object)"Got finished");
        this.finished = true;
    }

    public void pushData(SeisDataChangeEvent sdce) {
        if (sdce.getInitiator() != this) {
            return;
        }
        logger.debug((Object)("Got pushData for " + sdce.getSource().getName()));
        LocalSeismogramImpl[] seis = sdce.getSeismograms();
        for (int i = 0; i < seis.length; ++i) {
            try {
                File seisFile = URLDataSetSeismogram.saveAs(seis[i], this.directory, this.inDSS.getDataSet().getChannel(this.inDSS.getRequestFilter().channel_id), this.inDSS.getDataSet().getEvent(), this.fileType);
                this.urlDSS.addToCache(seisFile.toURI().toURL(), this.fileType, seis[i]);
                continue;
            }
            catch (Exception e) {
                this.setError(e);
            }
        }
    }

    private void setError(Throwable problem) {
        if (this.error == null) {
            this.error = problem;
        }
    }
}

