/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.xml;

import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.xml.XMLLocation;
import edu.sc.seis.fissuresUtil.xml.XMLNetworkAttr;
import edu.sc.seis.fissuresUtil.xml.XMLStationId;
import edu.sc.seis.fissuresUtil.xml.XMLTimeRange;
import edu.sc.seis.fissuresUtil.xml.XMLUtil;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLStation {
    public static void insert(XMLStreamWriter writer, Station station) throws XMLStreamException {
        writer.writeStartElement("id");
        XMLStationId.insert(writer, station.get_id());
        XMLUtil.writeEndElementWithNewLine(writer);
        XMLUtil.writeTextElement(writer, "name", station.name);
        writer.writeStartElement("my_location");
        XMLLocation.insert(writer, station.my_location);
        XMLUtil.writeEndElementWithNewLine(writer);
        writer.writeStartElement("effective_time");
        XMLTimeRange.insert(writer, station.effective_time);
        XMLUtil.writeEndElementWithNewLine(writer);
        XMLUtil.writeTextElement(writer, "operator", station.operator);
        XMLUtil.writeTextElement(writer, "description", station.description);
        XMLUtil.writeTextElement(writer, "comment", station.comment);
        writer.writeStartElement("my_network");
        XMLNetworkAttr.insert(writer, station.my_network);
        XMLUtil.writeEndElementWithNewLine(writer);
    }

    public static void insert(Element element, Station station) {
        Document doc = element.getOwnerDocument();
        Element id = doc.createElement("id");
        XMLStationId.insert(id, station.get_id());
        element.appendChild(id);
        element.appendChild(XMLUtil.createTextElement(doc, "name", station.name));
        Element my_location = doc.createElement("my_location");
        XMLLocation.insert(my_location, station.my_location);
        element.appendChild(my_location);
        Element effective_time = doc.createElement("effective_time");
        XMLTimeRange.insert(effective_time, station.effective_time);
        element.appendChild(effective_time);
        element.appendChild(XMLUtil.createTextElement(doc, "operator", station.operator));
        element.appendChild(XMLUtil.createTextElement(doc, "description", station.description));
        element.appendChild(XMLUtil.createTextElement(doc, "comment", station.comment));
        Element my_network = doc.createElement("my_network");
        XMLNetworkAttr.insert(my_network, station.my_network);
        element.appendChild(my_network);
    }

    public static Station getStation(Element base) {
        Element id_node = XMLUtil.getElement(base, "id");
        StationId id = XMLStationId.getStationId(id_node);
        String name = XMLUtil.getText(XMLUtil.getElement(base, "name"));
        Element my_location_node = XMLUtil.getElement(base, "my_location");
        Location my_location = XMLLocation.getLocation(my_location_node);
        Element effective_time_node = XMLUtil.getElement(base, "effective_time");
        TimeRange effective_time = XMLTimeRange.getTimeRange(effective_time_node);
        String operator = XMLUtil.getText(XMLUtil.getElement(base, "operator"));
        String description = XMLUtil.getText(XMLUtil.getElement(base, "description"));
        String comment = XMLUtil.getText(XMLUtil.getElement(base, "comment"));
        Element my_network_node = XMLUtil.getElement(base, "my_network");
        NetworkAttr my_network = XMLNetworkAttr.getNetworkAttr(my_network_node);
        return new StationImpl(id, name, my_location, effective_time, operator, description, comment, my_network);
    }

    public static Station getStation(XMLStreamReader parser) throws XMLStreamException {
        XMLUtil.gotoNextStartElement(parser, "id");
        StationId id = XMLStationId.getStationId(parser);
        XMLUtil.gotoNextStartElement(parser, "name");
        String name = parser.getElementText();
        XMLUtil.gotoNextStartElement(parser, "my_location");
        Location my_location = XMLLocation.getLocation(parser);
        XMLUtil.gotoNextStartElement(parser, "effective_time");
        TimeRange effective_time = XMLTimeRange.getTimeRange(parser);
        XMLUtil.gotoNextStartElement(parser, "operator");
        String operator = parser.getElementText();
        XMLUtil.gotoNextStartElement(parser, "description");
        String description = parser.getElementText();
        XMLUtil.gotoNextStartElement(parser, "comment");
        String comment = parser.getElementText();
        XMLUtil.gotoNextStartElement(parser, "my_network");
        NetworkAttr my_network = XMLNetworkAttr.getNetworkAttr(parser);
        return new StationImpl(id, name, my_location, effective_time, operator, description, comment, my_network);
    }
}

