/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.dataSelectWS;

import edu.sc.seis.seisFile.BuildVersion;
import edu.sc.seis.seisFile.dataSelectWS.DataSelectReader;
import edu.sc.seis.seisFile.mseed.DataRecord;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;

public class Client {
    public static void main(String[] args) throws Exception {
        String network = "IU";
        String station = "ANMO";
        String location = null;
        String channel = null;
        String outFile = null;
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        cal.add(12, -10);
        Date begin = cal.getTime();
        Float duration = Float.valueOf(600.0f);
        DataSelectReader dsReader = new DataSelectReader();
        int maxRecords = 10;
        boolean verbose = false;
        FilterOutputStream dos = null;
        PrintWriter out = new PrintWriter(System.out, true);
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-n")) {
                network = args[i + 1];
                continue;
            }
            if (args[i].equals("-s")) {
                station = args[i + 1];
                continue;
            }
            if (args[i].equals("-l")) {
                location = args[i + 1];
                continue;
            }
            if (args[i].equals("-c")) {
                channel = args[i + 1];
                continue;
            }
            if (args[i].equals("-u")) {
                dsReader = new DataSelectReader(args[i + 1]);
                continue;
            }
            if (args[i].equals("-b")) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
                begin = dateFormat.parse(args[i + 1]);
                continue;
            }
            if (args[i].equals("-d")) {
                duration = Float.valueOf(Float.parseFloat(args[i + 1]));
                continue;
            }
            if (args[i].equals("-o")) {
                outFile = args[i + 1];
                dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outFile)));
                continue;
            }
            if (args[i].equals("-m")) {
                maxRecords = Integer.parseInt(args[i + 1]);
                if (maxRecords >= -1) continue;
                maxRecords = -1;
                continue;
            }
            if (args[i].equals("--verbose")) {
                verbose = true;
                continue;
            }
            if (args[i].equals("--version")) {
                out.println(BuildVersion.getDetailedVersion());
                System.exit(0);
                continue;
            }
            if (!args[i].equals("--help")) continue;
            out.println("java " + Client.class.getName() + " [-n net][-s sta][-l loc][-c chan][-b yyyy-MM-ddTHH:mm:ss.SSS][-d seconds][-u url][-o outfile][-m maxpackets][--verbose][--version][--help]");
            System.exit(0);
        }
        URL requestURL = dsReader.createQuery(network, station, location, channel, begin, duration.floatValue());
        List<DataRecord> data = dsReader.read(requestURL);
        for (DataRecord dr : data) {
            if (dos != null) {
                dr.write((DataOutputStream)dos);
            }
            if (dos != null && !verbose) continue;
            dr.writeASCII(out, "    ");
            out.flush();
        }
        if (dos != null) {
            dos.close();
        }
        out.println("Finished: " + new Date());
    }
}

