/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed;

import edu.sc.seis.seisFile.mseed.DataBlockette;
import edu.sc.seis.seisFile.mseed.Utility;
import java.io.IOException;
import java.io.PrintWriter;

public class Blockette100
extends DataBlockette {
    public static final int B100_SIZE = 12;

    public Blockette100() {
        super(12);
    }

    public Blockette100(byte[] info, boolean swapBytes) {
        super(info, swapBytes);
        this.trimToSize(12);
    }

    public void setActualSampleRate(float actualSampleRate) {
        Utility.insertFloat(actualSampleRate, this.info, 4);
    }

    public float getActualSampleRate() {
        int bits = Utility.bytesToInt(this.info[4], this.info[5], this.info[6], this.info[7], false);
        return Float.intBitsToFloat(bits);
    }

    public int getType() {
        return 100;
    }

    public int getSize() {
        return 12;
    }

    public String getName() {
        return "Sample Rate Blockette";
    }

    public void writeASCII(PrintWriter out) throws IOException {
        out.println("Blockette100 " + this.getActualSampleRate());
    }
}

