/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.psn;

import edu.sc.seis.seisFile.psn.PSNDataFile;
import edu.sc.seis.seisFile.psn.PSNDateTime;
import edu.sc.seis.seisFile.sac.SacTimeSeries;
import java.io.DataInputStream;
import java.io.IOException;

public class PSNPhasePick {
    private DataInputStream dis;
    private byte[] eightBytes = new byte[8];
    private byte[] sixteenBytes = new byte[16];
    private PSNDateTime startTime;
    private String phase;
    private short flags;
    private short dispYPosition;
    private String travelTimeFileName;
    private short tableDepth;

    public PSNPhasePick(DataInputStream data) throws IOException {
        this.dis = data;
        this.startTime = new PSNDateTime(this.dis);
        this.dis.readFully(this.eightBytes);
        this.phase = new String(PSNDataFile.chopToLength(this.eightBytes));
        this.flags = SacTimeSeries.swapBytes((short)this.dis.readUnsignedShort());
        this.dispYPosition = SacTimeSeries.swapBytes(this.dis.readShort());
        this.dis.readFully(this.sixteenBytes);
        this.travelTimeFileName = new String(PSNDataFile.chopToLength(this.sixteenBytes));
        this.tableDepth = SacTimeSeries.swapBytes(this.dis.readShort());
    }

    public PSNDateTime getStartTime() {
        return this.startTime;
    }

    public String getPhase() {
        return this.phase;
    }

    public short getFlags() {
        return this.flags;
    }

    public short getDispYPosition() {
        return this.dispYPosition;
    }

    public String getTravelTimeFileName() {
        return this.travelTimeFileName;
    }

    public short getTableDepth() {
        return this.tableDepth;
    }
}

