/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.psn;

import edu.sc.seis.seisFile.sac.SacTimeSeries;
import java.io.DataInputStream;
import java.io.IOException;

public class PSNPolesAndZeros {
    private DataInputStream dis;
    short numZeros;
    short numPoles;
    double[][] zeros;
    double[][] poles;

    public PSNPolesAndZeros(DataInputStream data) throws IOException {
        int j;
        int i;
        this.dis = data;
        this.numZeros = SacTimeSeries.swapBytes(this.dis.readShort());
        this.numPoles = SacTimeSeries.swapBytes(this.dis.readShort());
        this.zeros = new double[this.numZeros][2];
        for (i = 0; i < this.numZeros; ++i) {
            for (j = 0; j < 2; ++j) {
                this.zeros[i][j] = Double.longBitsToDouble(SacTimeSeries.swapBytes(this.dis.readLong()));
            }
        }
        this.poles = new double[this.numPoles][2];
        for (i = 0; i < this.numZeros; ++i) {
            for (j = 0; j < 2; ++j) {
                this.poles[i][j] = Double.longBitsToDouble(SacTimeSeries.swapBytes(this.dis.readLong()));
            }
        }
    }

    public short getNumZeros() {
        return this.numZeros;
    }

    public short getNumPoles() {
        return this.numPoles;
    }

    public double[][] getZeros() {
        return this.zeros;
    }

    public double[][] getPoles() {
        return this.poles;
    }
}

