/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.sac;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;

public class SacTimeSeries {
    public float delta = FLOAT_UNDEF;
    public float depmin = FLOAT_UNDEF;
    public float depmax = FLOAT_UNDEF;
    public float scale = FLOAT_UNDEF;
    public float odelta = FLOAT_UNDEF;
    public float b = FLOAT_UNDEF;
    public float e = FLOAT_UNDEF;
    public float o = FLOAT_UNDEF;
    public float a = FLOAT_UNDEF;
    public float fmt = FLOAT_UNDEF;
    public float t0 = FLOAT_UNDEF;
    public float t1 = FLOAT_UNDEF;
    public float t2 = FLOAT_UNDEF;
    public float t3 = FLOAT_UNDEF;
    public float t4 = FLOAT_UNDEF;
    public float t5 = FLOAT_UNDEF;
    public float t6 = FLOAT_UNDEF;
    public float t7 = FLOAT_UNDEF;
    public float t8 = FLOAT_UNDEF;
    public float t9 = FLOAT_UNDEF;
    public float f = FLOAT_UNDEF;
    public float resp0 = FLOAT_UNDEF;
    public float resp1 = FLOAT_UNDEF;
    public float resp2 = FLOAT_UNDEF;
    public float resp3 = FLOAT_UNDEF;
    public float resp4 = FLOAT_UNDEF;
    public float resp5 = FLOAT_UNDEF;
    public float resp6 = FLOAT_UNDEF;
    public float resp7 = FLOAT_UNDEF;
    public float resp8 = FLOAT_UNDEF;
    public float resp9 = FLOAT_UNDEF;
    public float stla = FLOAT_UNDEF;
    public float stlo = FLOAT_UNDEF;
    public float stel = FLOAT_UNDEF;
    public float stdp = FLOAT_UNDEF;
    public float evla = FLOAT_UNDEF;
    public float evlo = FLOAT_UNDEF;
    public float evel = FLOAT_UNDEF;
    public float evdp = FLOAT_UNDEF;
    public float mag = FLOAT_UNDEF;
    public float user0 = FLOAT_UNDEF;
    public float user1 = FLOAT_UNDEF;
    public float user2 = FLOAT_UNDEF;
    public float user3 = FLOAT_UNDEF;
    public float user4 = FLOAT_UNDEF;
    public float user5 = FLOAT_UNDEF;
    public float user6 = FLOAT_UNDEF;
    public float user7 = FLOAT_UNDEF;
    public float user8 = FLOAT_UNDEF;
    public float user9 = FLOAT_UNDEF;
    public float dist = FLOAT_UNDEF;
    public float az = FLOAT_UNDEF;
    public float baz = FLOAT_UNDEF;
    public float gcarc = FLOAT_UNDEF;
    public float sb = FLOAT_UNDEF;
    public float sdelta = FLOAT_UNDEF;
    public float depmen = FLOAT_UNDEF;
    public float cmpaz = FLOAT_UNDEF;
    public float cmpinc = FLOAT_UNDEF;
    public float xminimum = FLOAT_UNDEF;
    public float xmaximum = FLOAT_UNDEF;
    public float yminimum = FLOAT_UNDEF;
    public float ymaximum = FLOAT_UNDEF;
    public float unused6 = FLOAT_UNDEF;
    public float unused7 = FLOAT_UNDEF;
    public float unused8 = FLOAT_UNDEF;
    public float unused9 = FLOAT_UNDEF;
    public float unused10 = FLOAT_UNDEF;
    public float unused11 = FLOAT_UNDEF;
    public float unused12 = FLOAT_UNDEF;
    public int nzyear = INT_UNDEF;
    public int nzjday = INT_UNDEF;
    public int nzhour = INT_UNDEF;
    public int nzmin = INT_UNDEF;
    public int nzsec = INT_UNDEF;
    public int nzmsec = INT_UNDEF;
    public int nvhdr = 6;
    public int norid = INT_UNDEF;
    public int nevid = INT_UNDEF;
    public int npts = INT_UNDEF;
    public int nsnpts = INT_UNDEF;
    public int nwfid = INT_UNDEF;
    public int nxsize = INT_UNDEF;
    public int nysize = INT_UNDEF;
    public int unused15 = INT_UNDEF;
    public int iftype = INT_UNDEF;
    public int idep = INT_UNDEF;
    public int iztype = INT_UNDEF;
    public int unused16 = INT_UNDEF;
    public int iinst = INT_UNDEF;
    public int istreg = INT_UNDEF;
    public int ievreg = INT_UNDEF;
    public int ievtyp = INT_UNDEF;
    public int iqual = INT_UNDEF;
    public int isynth = INT_UNDEF;
    public int imagtyp = INT_UNDEF;
    public int imagsrc = INT_UNDEF;
    public int unused19 = INT_UNDEF;
    public int unused20 = INT_UNDEF;
    public int unused21 = INT_UNDEF;
    public int unused22 = INT_UNDEF;
    public int unused23 = INT_UNDEF;
    public int unused24 = INT_UNDEF;
    public int unused25 = INT_UNDEF;
    public int unused26 = INT_UNDEF;
    public int leven = INT_UNDEF;
    public int lpspol = INT_UNDEF;
    public int lovrok = INT_UNDEF;
    public int lcalda = INT_UNDEF;
    public int unused27 = INT_UNDEF;
    public String kstnm = STRING8_UNDEF;
    public String kevnm = STRING16_UNDEF;
    public String khole = STRING8_UNDEF;
    public String ko = STRING8_UNDEF;
    public String ka = STRING8_UNDEF;
    public String kt0 = STRING8_UNDEF;
    public String kt1 = STRING8_UNDEF;
    public String kt2 = STRING8_UNDEF;
    public String kt3 = STRING8_UNDEF;
    public String kt4 = STRING8_UNDEF;
    public String kt5 = STRING8_UNDEF;
    public String kt6 = STRING8_UNDEF;
    public String kt7 = STRING8_UNDEF;
    public String kt8 = STRING8_UNDEF;
    public String kt9 = STRING8_UNDEF;
    public String kf = STRING8_UNDEF;
    public String kuser0 = STRING8_UNDEF;
    public String kuser1 = STRING8_UNDEF;
    public String kuser2 = STRING8_UNDEF;
    public String kcmpnm = STRING8_UNDEF;
    public String knetwk = STRING8_UNDEF;
    public String kdatrd = STRING8_UNDEF;
    public String kinst = STRING8_UNDEF;
    public float[] y;
    public float[] x;
    public float[] real;
    public float[] imaginary;
    public float[] amp;
    public float[] phase;
    public static float FLOAT_UNDEF = -12345.0f;
    public static int INT_UNDEF = -12345;
    public static String STRING8_UNDEF = "-12345  ";
    public static String STRING16_UNDEF = "-12345          ";
    public static final int DEFAULT_NVHDR = 6;
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    public static final int IREAL = 0;
    public static final int ITIME = 1;
    public static final int IRLIM = 2;
    public static final int IAMPH = 3;
    public static final int IXY = 4;
    public static final int IUNKN = 5;
    public static final int IDISP = 6;
    public static final int IVEL = 7;
    public static final int IACC = 8;
    public static final int IB = 9;
    public static final int IDAY = 10;
    public static final int IO = 11;
    public static final int IA = 12;
    public static final int IT0 = 13;
    public static final int IT1 = 14;
    public static final int IT2 = 15;
    public static final int IT3 = 16;
    public static final int IT4 = 17;
    public static final int IT5 = 18;
    public static final int IT6 = 19;
    public static final int IT7 = 20;
    public static final int IT8 = 21;
    public static final int IT9 = 22;
    public static final int IRADNV = 23;
    public static final int ITANNV = 24;
    public static final int IRADEV = 25;
    public static final int ITANEV = 26;
    public static final int INORTH = 27;
    public static final int IEAST = 28;
    public static final int IHORZA = 29;
    public static final int IDOWN = 30;
    public static final int IUP = 31;
    public static final int ILLLBB = 32;
    public static final int IWWSN1 = 33;
    public static final int IWWSN2 = 34;
    public static final int IHGLP = 35;
    public static final int ISRO = 36;
    public static final int INUCL = 37;
    public static final int IPREN = 38;
    public static final int IPOSTN = 39;
    public static final int IQUAKE = 40;
    public static final int IPREQ = 41;
    public static final int IPOSTQ = 42;
    public static final int ICHEM = 43;
    public static final int IOTHER = 44;
    public static final int IGOOD = 45;
    public static final int IGLCH = 46;
    public static final int IDROP = 47;
    public static final int ILOWSN = 48;
    public static final int IRLDTA = 49;
    public static final int IVOLTS = 50;
    public static final int IXYZ = 51;
    public static final int IMB = 52;
    public static final int IMS = 53;
    public static final int IML = 54;
    public static final int IMW = 55;
    public static final int IMD = 56;
    public static final int IMX = 57;
    public static final int INEIC = 58;
    public static final int IPDEQ = 59;
    public static final int IPDEW = 60;
    public static final int IPDE = 61;
    public static final int IISC = 62;
    public static final int IREB = 63;
    public static final int IUSGS = 64;
    public static final int IBRK = 65;
    public static final int ICALTECH = 66;
    public static final int ILLNL = 67;
    public static final int IEVLOC = 68;
    public static final int IJSOP = 69;
    public static final int IUSER = 70;
    public static final int IUNKNOWN = 71;
    public static final int IQB = 72;
    public static final int IQB1 = 73;
    public static final int IQB2 = 74;
    public static final int IQBX = 75;
    public static final int IQMT = 76;
    public static final int IEQ = 77;
    public static final int IEQ1 = 78;
    public static final int IEQ2 = 79;
    public static final int IME = 80;
    public static final int IEX = 81;
    public static final int INU = 82;
    public static final int INC = 83;
    public static final int IO_ = 84;
    public static final int IL = 85;
    public static final int IR = 86;
    public static final int IT = 87;
    public static final int IU = 88;
    public static final int IEQ3 = 89;
    public static final int IEQ0 = 90;
    public static final int IEX0 = 91;
    public static final int IQC = 92;
    public static final int IQB0 = 93;
    public static final int IGEY = 94;
    public static final int ILIT = 95;
    public static final int IMET = 96;
    public static final int IODOR = 97;
    public static final int data_offset = 632;
    public static final int NVHDR_OFFSET = 304;
    public static final int NPTS_OFFSET = 316;
    boolean byteOrder = true;
    public static final boolean SunByteOrder = true;
    public static final boolean IntelByteOrder = false;
    public static final DecimalFormat decimalFormat = new DecimalFormat("#####.####");

    public SacTimeSeries() {
    }

    public SacTimeSeries(File file) throws FileNotFoundException, IOException {
        this.read(file);
    }

    public SacTimeSeries(String filename) throws FileNotFoundException, IOException {
        this.read(filename);
    }

    public SacTimeSeries(DataInput inStream) throws IOException {
        this.read(inStream);
    }

    public boolean getByteOrder() {
        return this.byteOrder;
    }

    public void read(String filename) throws FileNotFoundException, IOException {
        File sacFile = new File(filename);
        this.read(sacFile);
    }

    public void read(File sacFile) throws FileNotFoundException, IOException {
        if (sacFile.length() < 632L) {
            throw new IOException(sacFile.getName() + " does not appear to be a sac file! File size (" + sacFile.length() + " is less than sac's header size (" + 632 + ")");
        }
        FileInputStream fis = new FileInputStream(sacFile);
        BufferedInputStream buf = new BufferedInputStream(fis);
        DataInputStream dis = new DataInputStream(buf);
        this.readHeader(dis);
        if (this.leven == 1 && sacFile.length() != (long)(this.npts * 4 + 632)) {
            throw new IOException(sacFile.getName() + " does not appear to be a sac file! npts(" + this.npts + ") * 4 + header(" + 632 + ") !=  file length=" + sacFile.length() + "\n  as linux: npts(" + SacTimeSeries.swapBytes(this.npts) + ")*4 + header(" + 632 + ") !=  file length=" + sacFile.length());
        }
        if (this.leven == 0 && sacFile.length() != (long)(this.npts * 4 * 2 + 632)) {
            throw new IOException(sacFile.getName() + " does not appear to be a uneven sac file! npts(" + this.npts + ") * 4 *2 + header(" + 632 + ") !=  file length=" + sacFile.length() + "\n  as linux: npts(" + SacTimeSeries.swapBytes(this.npts) + ")*4*2 + header(" + 632 + ") !=  file length=" + sacFile.length());
        }
        this.readData(dis);
        dis.close();
    }

    public final void setLittleEndian() {
        this.byteOrder = false;
    }

    public final void setBigEndian() {
        this.byteOrder = true;
    }

    public static final short swapBytes(short val) {
        return (short)(((val & 0xFF00) >> 8) + ((val & 0xFF) << 8));
    }

    public static final int swapBytes(int val) {
        return ((val & 0xFF000000) >>> 24) + ((val & 0xFF0000) >> 8) + ((val & 0xFF00) << 8) + ((val & 0xFF) << 24);
    }

    public static final long swapBytes(long val) {
        return ((val & 0xFF00000000000000L) >>> 56) + ((val & 0xFF000000000000L) >> 40) + ((val & 0xFF0000000000L) >> 24) + ((val & 0xFF00000000L) >> 8) + ((val & 0xFF000000L) << 8) + ((val & 0xFF0000L) << 24) + ((val & 0xFF00L) << 40) + ((val & 0xFFL) << 56);
    }

    public void read(DataInput dis) throws IOException {
        this.readHeader(dis);
        this.readData(dis);
    }

    public void readHeader(String filename) throws FileNotFoundException, IOException {
        DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(filename)));
        this.readHeader(dis);
        dis.close();
    }

    public void readHeader(DataInput indis) throws FileNotFoundException, IOException {
        byte[] headerBuf = new byte[632];
        indis.readFully(headerBuf);
        if (headerBuf[304] == 6 && headerBuf[305] == 0 && headerBuf[306] == 0 && headerBuf[307] == 0) {
            this.byteOrder = false;
            for (int i = 0; i < 440; i += 4) {
                byte tmp = headerBuf[i];
                headerBuf[i] = headerBuf[i + 3];
                headerBuf[i + 3] = tmp;
                tmp = headerBuf[i + 1];
                headerBuf[i + 1] = headerBuf[i + 2];
                headerBuf[i + 2] = tmp;
            }
        }
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(headerBuf));
        this.delta = dis.readFloat();
        this.depmin = dis.readFloat();
        this.depmax = dis.readFloat();
        this.scale = dis.readFloat();
        this.odelta = dis.readFloat();
        this.b = dis.readFloat();
        this.e = dis.readFloat();
        this.o = dis.readFloat();
        this.a = dis.readFloat();
        this.fmt = dis.readFloat();
        this.t0 = dis.readFloat();
        this.t1 = dis.readFloat();
        this.t2 = dis.readFloat();
        this.t3 = dis.readFloat();
        this.t4 = dis.readFloat();
        this.t5 = dis.readFloat();
        this.t6 = dis.readFloat();
        this.t7 = dis.readFloat();
        this.t8 = dis.readFloat();
        this.t9 = dis.readFloat();
        this.f = dis.readFloat();
        this.resp0 = dis.readFloat();
        this.resp1 = dis.readFloat();
        this.resp2 = dis.readFloat();
        this.resp3 = dis.readFloat();
        this.resp4 = dis.readFloat();
        this.resp5 = dis.readFloat();
        this.resp6 = dis.readFloat();
        this.resp7 = dis.readFloat();
        this.resp8 = dis.readFloat();
        this.resp9 = dis.readFloat();
        this.stla = dis.readFloat();
        this.stlo = dis.readFloat();
        this.stel = dis.readFloat();
        this.stdp = dis.readFloat();
        this.evla = dis.readFloat();
        this.evlo = dis.readFloat();
        this.evel = dis.readFloat();
        this.evdp = dis.readFloat();
        this.mag = dis.readFloat();
        this.user0 = dis.readFloat();
        this.user1 = dis.readFloat();
        this.user2 = dis.readFloat();
        this.user3 = dis.readFloat();
        this.user4 = dis.readFloat();
        this.user5 = dis.readFloat();
        this.user6 = dis.readFloat();
        this.user7 = dis.readFloat();
        this.user8 = dis.readFloat();
        this.user9 = dis.readFloat();
        this.dist = dis.readFloat();
        this.az = dis.readFloat();
        this.baz = dis.readFloat();
        this.gcarc = dis.readFloat();
        this.sb = dis.readFloat();
        this.sdelta = dis.readFloat();
        this.depmen = dis.readFloat();
        this.cmpaz = dis.readFloat();
        this.cmpinc = dis.readFloat();
        this.xminimum = dis.readFloat();
        this.xmaximum = dis.readFloat();
        this.yminimum = dis.readFloat();
        this.ymaximum = dis.readFloat();
        this.unused6 = dis.readFloat();
        this.unused7 = dis.readFloat();
        this.unused8 = dis.readFloat();
        this.unused9 = dis.readFloat();
        this.unused10 = dis.readFloat();
        this.unused11 = dis.readFloat();
        this.unused12 = dis.readFloat();
        this.nzyear = dis.readInt();
        this.nzjday = dis.readInt();
        this.nzhour = dis.readInt();
        this.nzmin = dis.readInt();
        this.nzsec = dis.readInt();
        this.nzmsec = dis.readInt();
        this.nvhdr = dis.readInt();
        this.norid = dis.readInt();
        this.nevid = dis.readInt();
        this.npts = dis.readInt();
        this.nsnpts = dis.readInt();
        this.nwfid = dis.readInt();
        this.nxsize = dis.readInt();
        this.nysize = dis.readInt();
        this.unused15 = dis.readInt();
        this.iftype = dis.readInt();
        this.idep = dis.readInt();
        this.iztype = dis.readInt();
        this.unused16 = dis.readInt();
        this.iinst = dis.readInt();
        this.istreg = dis.readInt();
        this.ievreg = dis.readInt();
        this.ievtyp = dis.readInt();
        this.iqual = dis.readInt();
        this.isynth = dis.readInt();
        this.imagtyp = dis.readInt();
        this.imagsrc = dis.readInt();
        this.unused19 = dis.readInt();
        this.unused20 = dis.readInt();
        this.unused21 = dis.readInt();
        this.unused22 = dis.readInt();
        this.unused23 = dis.readInt();
        this.unused24 = dis.readInt();
        this.unused25 = dis.readInt();
        this.unused26 = dis.readInt();
        this.leven = dis.readInt();
        this.lpspol = dis.readInt();
        this.lovrok = dis.readInt();
        this.lcalda = dis.readInt();
        this.unused27 = dis.readInt();
        byte[] eightBytes = new byte[8];
        byte[] sixteenBytes = new byte[16];
        dis.readFully(eightBytes);
        this.kstnm = new String(eightBytes);
        dis.readFully(sixteenBytes);
        this.kevnm = new String(sixteenBytes);
        dis.readFully(eightBytes);
        this.khole = new String(eightBytes);
        dis.readFully(eightBytes);
        this.ko = new String(eightBytes);
        dis.readFully(eightBytes);
        this.ka = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kt0 = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kt1 = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kt2 = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kt3 = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kt4 = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kt5 = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kt6 = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kt7 = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kt8 = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kt9 = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kf = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kuser0 = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kuser1 = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kuser2 = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kcmpnm = new String(eightBytes);
        dis.readFully(eightBytes);
        this.knetwk = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kdatrd = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kinst = new String(eightBytes);
    }

    public void readData(DataInput fis) throws IOException {
        this.y = new float[this.npts];
        this.readDataArray(fis, this.y);
        if (this.leven == 0 || this.iftype == 2 || this.iftype == 3) {
            this.x = new float[this.npts];
            this.readDataArray(fis, this.x);
            if (this.iftype == 2) {
                this.real = this.y;
                this.imaginary = this.x;
            }
            if (this.iftype == 3) {
                this.amp = this.y;
                this.phase = this.x;
            }
        }
    }

    private void readDataArray(DataInput fis, float[] d) throws IOException {
        byte[] dataBytes = new byte[d.length * 4];
        int numAdded = 0;
        int i = 0;
        fis.readFully(dataBytes);
        while (numAdded < d.length) {
            if (!this.byteOrder) {
                this.y[numAdded++] = Float.intBitsToFloat(((dataBytes[i++] & 0xFF) << 0) + ((dataBytes[i++] & 0xFF) << 8) + ((dataBytes[i++] & 0xFF) << 16) + ((dataBytes[i++] & 0xFF) << 24));
                continue;
            }
            this.y[numAdded++] = Float.intBitsToFloat(((dataBytes[i++] & 0xFF) << 24) + ((dataBytes[i++] & 0xFF) << 16) + ((dataBytes[i++] & 0xFF) << 8) + ((dataBytes[i++] & 0xFF) << 0));
        }
    }

    public void write(String filename) throws FileNotFoundException, IOException {
        File f = new File(filename);
        this.write(f);
    }

    public void write(File file) throws FileNotFoundException, IOException {
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        this.writeHeader(dos);
        this.writeData(dos);
        dos.close();
    }

    private final void writeFloat(DataOutput dos, float val) throws IOException {
        if (!this.byteOrder) {
            dos.writeInt(SacTimeSeries.swapBytes(Float.floatToRawIntBits(val)));
        } else {
            dos.writeFloat(val);
        }
    }

    private final void writeInt(DataOutput dos, int val) throws IOException {
        if (!this.byteOrder) {
            dos.writeInt(SacTimeSeries.swapBytes(val));
        } else {
            dos.writeInt(val);
        }
    }

    public void writeHeader(DataOutput dos) throws IOException {
        this.writeFloat(dos, this.delta);
        this.writeFloat(dos, this.depmin);
        this.writeFloat(dos, this.depmax);
        this.writeFloat(dos, this.scale);
        this.writeFloat(dos, this.odelta);
        this.writeFloat(dos, this.b);
        this.writeFloat(dos, this.e);
        this.writeFloat(dos, this.o);
        this.writeFloat(dos, this.a);
        this.writeFloat(dos, this.fmt);
        this.writeFloat(dos, this.t0);
        this.writeFloat(dos, this.t1);
        this.writeFloat(dos, this.t2);
        this.writeFloat(dos, this.t3);
        this.writeFloat(dos, this.t4);
        this.writeFloat(dos, this.t5);
        this.writeFloat(dos, this.t6);
        this.writeFloat(dos, this.t7);
        this.writeFloat(dos, this.t8);
        this.writeFloat(dos, this.t9);
        this.writeFloat(dos, this.f);
        this.writeFloat(dos, this.resp0);
        this.writeFloat(dos, this.resp1);
        this.writeFloat(dos, this.resp2);
        this.writeFloat(dos, this.resp3);
        this.writeFloat(dos, this.resp4);
        this.writeFloat(dos, this.resp5);
        this.writeFloat(dos, this.resp6);
        this.writeFloat(dos, this.resp7);
        this.writeFloat(dos, this.resp8);
        this.writeFloat(dos, this.resp9);
        this.writeFloat(dos, this.stla);
        this.writeFloat(dos, this.stlo);
        this.writeFloat(dos, this.stel);
        this.writeFloat(dos, this.stdp);
        this.writeFloat(dos, this.evla);
        this.writeFloat(dos, this.evlo);
        this.writeFloat(dos, this.evel);
        this.writeFloat(dos, this.evdp);
        this.writeFloat(dos, this.mag);
        this.writeFloat(dos, this.user0);
        this.writeFloat(dos, this.user1);
        this.writeFloat(dos, this.user2);
        this.writeFloat(dos, this.user3);
        this.writeFloat(dos, this.user4);
        this.writeFloat(dos, this.user5);
        this.writeFloat(dos, this.user6);
        this.writeFloat(dos, this.user7);
        this.writeFloat(dos, this.user8);
        this.writeFloat(dos, this.user9);
        this.writeFloat(dos, this.dist);
        this.writeFloat(dos, this.az);
        this.writeFloat(dos, this.baz);
        this.writeFloat(dos, this.gcarc);
        this.writeFloat(dos, this.sb);
        this.writeFloat(dos, this.sdelta);
        this.writeFloat(dos, this.depmen);
        this.writeFloat(dos, this.cmpaz);
        this.writeFloat(dos, this.cmpinc);
        this.writeFloat(dos, this.xminimum);
        this.writeFloat(dos, this.xmaximum);
        this.writeFloat(dos, this.yminimum);
        this.writeFloat(dos, this.ymaximum);
        this.writeFloat(dos, this.unused6);
        this.writeFloat(dos, this.unused7);
        this.writeFloat(dos, this.unused8);
        this.writeFloat(dos, this.unused9);
        this.writeFloat(dos, this.unused10);
        this.writeFloat(dos, this.unused11);
        this.writeFloat(dos, this.unused12);
        this.writeInt(dos, this.nzyear);
        this.writeInt(dos, this.nzjday);
        this.writeInt(dos, this.nzhour);
        this.writeInt(dos, this.nzmin);
        this.writeInt(dos, this.nzsec);
        this.writeInt(dos, this.nzmsec);
        this.writeInt(dos, this.nvhdr);
        this.writeInt(dos, this.norid);
        this.writeInt(dos, this.nevid);
        this.writeInt(dos, this.npts);
        this.writeInt(dos, this.nsnpts);
        this.writeInt(dos, this.nwfid);
        this.writeInt(dos, this.nxsize);
        this.writeInt(dos, this.nysize);
        this.writeInt(dos, this.unused15);
        this.writeInt(dos, this.iftype);
        this.writeInt(dos, this.idep);
        this.writeInt(dos, this.iztype);
        this.writeInt(dos, this.unused16);
        this.writeInt(dos, this.iinst);
        this.writeInt(dos, this.istreg);
        this.writeInt(dos, this.ievreg);
        this.writeInt(dos, this.ievtyp);
        this.writeInt(dos, this.iqual);
        this.writeInt(dos, this.isynth);
        this.writeInt(dos, this.imagtyp);
        this.writeInt(dos, this.imagsrc);
        this.writeInt(dos, this.unused19);
        this.writeInt(dos, this.unused20);
        this.writeInt(dos, this.unused21);
        this.writeInt(dos, this.unused22);
        this.writeInt(dos, this.unused23);
        this.writeInt(dos, this.unused24);
        this.writeInt(dos, this.unused25);
        this.writeInt(dos, this.unused26);
        this.writeInt(dos, this.leven);
        this.writeInt(dos, this.lpspol);
        this.writeInt(dos, this.lovrok);
        this.writeInt(dos, this.lcalda);
        this.writeInt(dos, this.unused27);
        dos.writeBytes(SacTimeSeries.trimLen(this.kstnm, 8));
        dos.writeBytes(SacTimeSeries.trimLen(this.kevnm, 16));
        dos.writeBytes(SacTimeSeries.trimLen(this.khole, 8));
        dos.writeBytes(SacTimeSeries.trimLen(this.ko, 8));
        dos.writeBytes(SacTimeSeries.trimLen(this.ka, 8));
        dos.writeBytes(SacTimeSeries.trimLen(this.kt0, 8));
        dos.writeBytes(SacTimeSeries.trimLen(this.kt1, 8));
        dos.writeBytes(SacTimeSeries.trimLen(this.kt2, 8));
        dos.writeBytes(SacTimeSeries.trimLen(this.kt3, 8));
        dos.writeBytes(SacTimeSeries.trimLen(this.kt4, 8));
        dos.writeBytes(SacTimeSeries.trimLen(this.kt5, 8));
        dos.writeBytes(SacTimeSeries.trimLen(this.kt6, 8));
        dos.writeBytes(SacTimeSeries.trimLen(this.kt7, 8));
        dos.writeBytes(SacTimeSeries.trimLen(this.kt8, 8));
        dos.writeBytes(SacTimeSeries.trimLen(this.kt9, 8));
        dos.writeBytes(SacTimeSeries.trimLen(this.kf, 8));
        dos.writeBytes(SacTimeSeries.trimLen(this.kuser0, 8));
        dos.writeBytes(SacTimeSeries.trimLen(this.kuser1, 8));
        dos.writeBytes(SacTimeSeries.trimLen(this.kuser2, 8));
        dos.writeBytes(SacTimeSeries.trimLen(this.kcmpnm, 8));
        dos.writeBytes(SacTimeSeries.trimLen(this.knetwk, 8));
        dos.writeBytes(SacTimeSeries.trimLen(this.kdatrd, 8));
        dos.writeBytes(SacTimeSeries.trimLen(this.kinst, 8));
    }

    public void writeData(DataOutput dos) throws IOException {
        int i;
        for (i = 0; i < this.npts; ++i) {
            this.writeFloat(dos, this.y[i]);
        }
        if (this.leven == 0 || this.iftype == 2 || this.iftype == 3) {
            for (i = 0; i < this.npts; ++i) {
                this.writeFloat(dos, this.x[i]);
            }
        }
    }

    public static String trimLen(String s, int len) {
        if (s.length() > len) {
            s = s.substring(0, len - 1);
        }
        while (s.length() < len) {
            s = s + " ";
        }
        return s;
    }

    public static String format(String label, float f) {
        return SacTimeSeries.format(label, decimalFormat.format(f), 10, 8);
    }

    public static String format(String label, String val, int labelWidth, int valWidth) {
        while (label.length() < labelWidth) {
            label = " " + label;
        }
        while (val.length() < valWidth) {
            val = " " + val;
        }
        return label + " = " + val;
    }

    public static String formatLine(String s1, float f1, String s2, float f2, String s3, float f3, String s4, float f4, String s5, float f5) {
        return SacTimeSeries.format(s1, f1) + SacTimeSeries.format(s2, f2) + SacTimeSeries.format(s3, f3) + SacTimeSeries.format(s4, f4) + SacTimeSeries.format(s5, f5);
    }

    public void printHeader() {
        this.printHeader(new PrintWriter(System.out, true));
    }

    public void printHeader(PrintWriter out) {
        out.println(SacTimeSeries.formatLine("delta", this.delta, "depmin", this.depmin, "depmax", this.depmax, "scale", this.scale, "odelta", this.odelta));
        out.println(SacTimeSeries.formatLine("b", this.b, "e", this.e, "o", this.o, "a", this.a, "fmt", this.fmt));
        out.println(SacTimeSeries.formatLine("t0", this.t0, "t1", this.t1, "t2", this.t2, "t3", this.t3, "t4", this.t4));
        out.println(SacTimeSeries.formatLine("t5", this.t5, "t6", this.t6, "t7", this.t7, "t8", this.t8, "t9", this.t9));
        out.println(SacTimeSeries.formatLine("f", this.f, "resp0", this.resp0, "resp1", this.resp1, "resp2", this.resp2, "resp3", this.resp3));
        out.println(SacTimeSeries.formatLine("resp4", this.resp4, "resp5", this.resp5, "resp6", this.resp6, "resp7", this.resp7, "resp8", this.resp8));
        out.println(SacTimeSeries.formatLine("resp9", this.resp9, "stla", this.stla, "stlo", this.stlo, "stel", this.stel, "stdp", this.stdp));
        out.println(SacTimeSeries.formatLine("evla", this.evla, "evlo", this.evlo, "evel", this.evel, "evdp", this.evdp, "mag", this.mag));
        out.println(SacTimeSeries.formatLine("user0", this.user0, "user1", this.user1, "user2", this.user2, "user3", this.user3, "user4", this.user4));
        out.println(SacTimeSeries.formatLine("user5", this.user5, "user6", this.user6, "user7", this.user7, "user8", this.user8, "user9", this.user9));
        out.println(SacTimeSeries.formatLine("dist", this.dist, "az", this.az, "baz", this.baz, "gcarc", this.gcarc, "sb", this.sb));
        out.println(SacTimeSeries.formatLine("sdelta", this.sdelta, "depmen", this.depmen, "cmpaz", this.cmpaz, "cmpinc", this.cmpinc, "xminimum", this.xminimum));
        out.println(SacTimeSeries.formatLine("xmaximum", this.xmaximum, "yminimum", this.yminimum, "ymaximum", this.ymaximum, "unused6", this.unused6, "unused7", this.unused7));
        out.println(SacTimeSeries.formatLine("unused8", this.unused8, "unused9", this.unused9, "unused10", this.unused10, "unused11", this.unused11, "unused12", this.unused12));
        out.println(SacTimeSeries.formatLine("nzyear", this.nzyear, "nzjday", this.nzjday, "nzhour", this.nzhour, "nzmin", this.nzmin, "nzsec", this.nzsec));
        out.println(SacTimeSeries.formatLine("nzmsec", this.nzmsec, "nvhdr", this.nvhdr, "norid", this.norid, "nevid", this.nevid, "npts", this.npts));
        out.println(SacTimeSeries.formatLine("nsnpts", this.nsnpts, "nwfid", this.nwfid, "nxsize", this.nxsize, "nysize", this.nysize, "unused15", this.unused15));
        out.println(SacTimeSeries.formatLine("iftype", this.iftype, "idep", this.idep, "iztype", this.iztype, "unused16", this.unused16, "iinst", this.iinst));
        out.println(SacTimeSeries.formatLine("istreg", this.istreg, "ievreg", this.ievreg, "ievtyp", this.ievtyp, "iqual", this.iqual, "isynth", this.isynth));
        out.println(SacTimeSeries.formatLine("imagtyp", this.imagtyp, "imagsrc", this.imagsrc, "unused19", this.unused19, "unused20", this.unused20, "unused21", this.unused21));
        out.println(SacTimeSeries.formatLine("unused22", this.unused22, "unused23", this.unused23, "unused24", this.unused24, "unused25", this.unused25, "unused26", this.unused26));
        out.println(SacTimeSeries.formatLine("leven", this.leven, "lpspol", this.lpspol, "lovrok", this.lovrok, "lcalda", this.lcalda, "unused27", this.unused27));
        int labelWidth = 10;
        int wideValWidth = 31;
        int valWidth = 10;
        out.println(SacTimeSeries.format("kstnm", this.kstnm, labelWidth, valWidth) + SacTimeSeries.format("kevnm", this.kevnm, labelWidth, wideValWidth) + SacTimeSeries.format("khole", this.khole, labelWidth + 2, valWidth));
        out.println(SacTimeSeries.format("ko", this.ko, labelWidth, valWidth) + SacTimeSeries.format("ka = ", this.ka, labelWidth, valWidth) + SacTimeSeries.format("kt0", this.kt0, labelWidth, valWidth) + SacTimeSeries.format("kt1", this.kt1, labelWidth, valWidth));
        out.println(SacTimeSeries.format("kt2", this.kt2, labelWidth, valWidth) + SacTimeSeries.format("kt3 = ", this.kt3, labelWidth, valWidth) + SacTimeSeries.format("kt4", this.kt4, labelWidth, valWidth) + SacTimeSeries.format("kt5", this.kt5, labelWidth, valWidth));
        out.println(SacTimeSeries.format("kt6", this.kt6, labelWidth, valWidth) + SacTimeSeries.format("kt7 = ", this.kt7, labelWidth, valWidth) + SacTimeSeries.format("kt8", this.kt8, labelWidth, valWidth) + SacTimeSeries.format("kt9", this.kt9, labelWidth, valWidth));
        out.println(SacTimeSeries.format("kf", this.kf, labelWidth, valWidth) + SacTimeSeries.format("kuser0 = ", this.kuser0, labelWidth, valWidth) + SacTimeSeries.format("kuser1", this.kuser1, labelWidth, valWidth) + SacTimeSeries.format("kuser2", this.kuser2, labelWidth, valWidth));
        out.println(SacTimeSeries.format("kcmpnm", this.kcmpnm, labelWidth, valWidth) + SacTimeSeries.format("knetwk = ", this.knetwk, labelWidth, valWidth) + SacTimeSeries.format("kdatrd", this.kdatrd, labelWidth, valWidth) + SacTimeSeries.format("kinst", this.kinst, labelWidth, valWidth));
    }

    public static void main(String[] args) {
        SacTimeSeries data = new SacTimeSeries();
        if (args.length != 1) {
            System.out.println("Usage: java SacTimeSeries sacsourcefile ");
            return;
        }
        try {
            data.read(args[0]);
            System.out.println("stla original: " + data.stla + " npts=" + data.npts);
            data.write("outsacfile");
            data.read("outsacfile");
            System.out.println("stla after read little endian: " + data.stla + " npts=" + data.npts);
            System.out.println("Done writing");
        }
        catch (FileNotFoundException e) {
            System.out.println("File " + args[0] + " doesn't exist.");
        }
        catch (IOException e) {
            System.out.println("IOException: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

