/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.seedlink;

import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.seedlink.SeedlinkException;
import edu.sc.seis.seisFile.seedlink.SeedlinkPacket;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.PushbackInputStream;
import java.net.Socket;
import java.net.UnknownHostException;

public class SeedlinkReader {
    PushbackInputStream in;
    DataInputStream inData;
    BufferedOutputStream out;
    private Socket socket;
    boolean verbose = false;
    String host;
    int port;
    private PrintWriter verboseWriter;
    public static final String DEFAULT_HOST = "rtserve.iris.washington.edu";
    public static final int DEFAULT_PORT = 18000;
    public static final String INFO_ID = "ID";
    public static final String INFO_CAPABILITIES = "CAPABILITIES";
    public static final String INFO_STATIONS = "STATIONS";
    public static final String INFO_STREAMS = "STREAMS";
    public static final String INFO_GAPS = "GAPS";
    public static final String INFO_CONNECTIONS = "CONNECTIONS";
    public static final String INFO_ALL = "ALL";

    public SeedlinkReader(String host) throws UnknownHostException, IOException, SeedlinkException {
        this(host, 18000);
    }

    public SeedlinkReader(String host, int port) throws UnknownHostException, IOException, SeedlinkException {
        this(host, port, false);
    }

    public SeedlinkReader(String host, int port, boolean verbose) throws UnknownHostException, IOException, SeedlinkException {
        this.host = host;
        this.port = port;
        this.verbose = verbose;
        this.socket = new Socket(host, port);
        this.out = new BufferedOutputStream(this.socket.getOutputStream());
        this.in = new PushbackInputStream(new BufferedInputStream(this.socket.getInputStream()), 3);
        this.inData = new DataInputStream(this.in);
    }

    public boolean hasNext() throws IOException {
        if (!this.isConnected()) {
            return false;
        }
        byte[] startBits = new byte[]{(byte)this.in.read(), (byte)this.in.read(), (byte)this.in.read()};
        String start = new String(startBits);
        if (start.equals("END")) {
            return false;
        }
        this.in.unread(startBits);
        return true;
    }

    public SeedlinkPacket next() throws IOException, SeedlinkException {
        if (this.isVerbose()) {
            this.verboseWriter.println("next(): blocking read for 520 bytes, available=" + this.in.available());
        }
        if (!this.hasNext()) {
            throw new SeedlinkException("no more seed link packets from last command");
        }
        byte[] bits = new byte[520];
        this.inData.readFully(bits);
        SeedlinkPacket slp = new SeedlinkPacket(bits);
        if (this.isVerbose()) {
            String packetString = "";
            try {
                DataRecord dr = slp.getMiniSeed();
                packetString = " Got a packet: " + slp.getSeqNum() + "  " + dr.getHeader().getNetworkCode() + "  " + dr.getHeader().getStationIdentifier() + "  " + dr.getHeader().getLocationIdentifier() + "  " + dr.getHeader().getChannelIdentifier() + "  " + dr.getHeader().getStartTime();
            }
            catch (SeedFormatException e) {
                packetString = "SeedFormatExcpetion parsing packet: " + slp.getSeqNum() + e.getMessage();
            }
            this.verboseWriter.println(packetString);
        }
        return slp;
    }

    public void info(String level) throws IOException {
        this.send("INFO " + level);
    }

    public void endHandshake() throws IOException {
        this.send("END");
    }

    public void close() throws IOException {
        this.send("BYE");
        this.in.close();
        this.out.close();
        this.socket.close();
    }

    public boolean isConnected() {
        return this.socket.isConnected();
    }

    String[] sendHello() throws IOException, SeedlinkException {
        this.send("HELLO");
        String[] lines = new String[]{this.readLine(), this.readLine()};
        return lines;
    }

    String readLine() throws IOException, SeedlinkException {
        StringBuffer buf = new StringBuffer();
        int next = this.in.read();
        while (next != 13) {
            while (next != 13 && this.in.available() > 0) {
                buf.append((char)next);
                next = this.in.read();
                if (next != -1) continue;
                throw new SeedlinkException("read returned -1, socket closed???");
            }
            if (!this.isVerbose()) continue;
            this.verboseWriter.println(buf);
        }
        next = this.in.read();
        if (next != 10) {
            throw new SeedlinkException("Got \r but not followed by \n :" + next);
        }
        return buf.toString();
    }

    void sendCmd(String cmd) throws IOException, SeedlinkException {
        this.send(cmd);
        String line = this.readLine();
        if (!line.equals("OK")) {
            throw new SeedlinkException("Command " + cmd + " did not return OK");
        }
    }

    void send(String cmd) throws IOException {
        if (this.isVerbose()) {
            this.verboseWriter.println("send '" + cmd + "'");
        }
        this.out.write((cmd + "\r").getBytes());
        this.out.flush();
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public PrintWriter getVerboseWriter() {
        return this.verboseWriter;
    }

    public void setVerboseWriter(PrintWriter verboseWriter) {
        this.verboseWriter = verboseWriter;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

