/*
 * Decompiled with CFR 0.152.
 */
package pickewanalysis;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Persister;
import pickewanalysis.AddSourceDialog;
import pickewanalysis.ConfigStationsListTableModel;
import pickewanalysis.ErrorDialog;
import pickewanalysis.SourcesListTableModel;
import pickewanalysis.wavesources.WaveSource;

@Root(name="PickEWAnalysisConfiguration")
public class Configuration
extends JDialog {
    private JButton addButton;
    private JButton browseButton;
    private JButton cancelButton;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JButton monveDownButton;
    private JButton moveUpButton;
    private JButton okButton;
    private JButton rmvButton;
    private JTable sourcesTable;
    private JTextField stationsFileField;
    private JLabel stationsFileLabel;
    private JTable stationsTable;
    @Element(required=false)
    public String StationsFile = "";
    @Element
    public int RestartLength = 100;
    @Element
    public int MaxGap = 15;
    @Element
    public int NoCoda = 0;
    @Element(required=false)
    public Date endtime = new Date(System.currentTimeMillis() / 1000L * 1000L);
    @Element(required=false)
    public Date starttime = new Date(this.endtime.getTime() - 60000L);
    @ElementList(entry="WaveSource", inline=true, required=false)
    public List<WaveSource> sources = new ArrayList<WaveSource>();
    String configFile;
    WaveSource curSource = null;
    String tempStationsFile;

    public Configuration() {
        this.initComponents();
    }

    private void initComponents() {
        this.stationsFileLabel = new JLabel();
        this.stationsFileField = new JTextField();
        this.browseButton = new JButton();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.sourcesTable = new JTable();
        this.moveUpButton = new JButton();
        this.monveDownButton = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.stationsTable = new JTable();
        this.addButton = new JButton();
        this.rmvButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("PickEWAnalysis Settings");
        this.setModal(true);
        this.setResizable(false);
        this.stationsFileLabel.setText("Stations File");
        this.stationsFileField.setText(" ");
        this.browseButton.setText("Browse");
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Configuration.this.browseButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Configuration.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Configuration.this.okButtonActionPerformed(evt);
            }
        });
        this.sourcesTable.setAutoCreateRowSorter(true);
        this.sourcesTable.setFont(new Font("Tahoma", 0, 10));
        this.sourcesTable.setModel(new SourcesListTableModel(this.sources));
        this.sourcesTable.setSelectionMode(0);
        this.sourcesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                Configuration.this.sourcesTableMouseReleased(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.sourcesTable);
        this.moveUpButton.setText("Move Up");
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Configuration.this.moveUpButtonActionPerformed(evt);
            }
        });
        this.monveDownButton.setText("Move Down");
        this.monveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Configuration.this.monveDownButtonActionPerformed(evt);
            }
        });
        this.stationsTable.setAutoCreateRowSorter(true);
        this.stationsTable.setFont(new Font("Tahoma", 0, 10));
        this.stationsTable.setModel(new ConfigStationsListTableModel(this.curSource));
        this.stationsTable.setSelectionMode(0);
        this.jScrollPane2.setViewportView(this.stationsTable);
        this.addButton.setText("Add");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Configuration.this.addButtonActionPerformed(evt);
            }
        });
        this.rmvButton.setText("Remove");
        this.rmvButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Configuration.this.rmvButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.stationsFileLabel).addGap(18, 18, 18).addComponent(this.stationsFileField).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.browseButton, -2, 81, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.okButton, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton, -2, 80, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 246, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.rmvButton, -1, -1, Short.MAX_VALUE).addComponent(this.addButton, -1, -1, Short.MAX_VALUE).addComponent(this.moveUpButton, -1, -1, Short.MAX_VALUE).addComponent(this.monveDownButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 350, Short.MAX_VALUE))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.stationsFileLabel).addComponent(this.stationsFileField, -2, -1, -2).addComponent(this.browseButton)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.moveUpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.monveDownButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rmvButton)).addComponent(this.jScrollPane1, -2, 339, -2).addComponent(this.jScrollPane2, -2, 339, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
        this.pack();
    }

    private void sourcesTableMouseReleased(MouseEvent evt) {
        int rowIndex = this.sourcesTable.convertRowIndexToModel(this.sourcesTable.getSelectedRow());
        this.curSource = (WaveSource)((SourcesListTableModel)this.sourcesTable.getModel()).getValueAt(rowIndex, 1);
        this.stationsTable.setModel(new ConfigStationsListTableModel(this.curSource));
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        AddSourceDialog sourcediag = new AddSourceDialog((Frame)new JFrame(), true);
        sourcediag.setLocationRelativeTo(this);
        sourcediag.setVisible(true);
        if (sourcediag.getSource() != null) {
            SourcesListTableModel sourcesModel = (SourcesListTableModel)this.sourcesTable.getModel();
            sourcesModel.getSources().add(sourcediag.getSource());
            sourcesModel.fireTableDataChanged();
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.updateTables();
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.sources = ((SourcesListTableModel)this.sourcesTable.getModel()).getSources();
        this.updateTables();
        if (this.tempStationsFile != null) {
            this.StationsFile = this.tempStationsFile;
        }
        try {
            this.save(this.configFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.dispose();
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        File selectedfile;
        JFileChooser filechooser = new JFileChooser();
        filechooser.setCurrentDirectory(new File("./"));
        int aux = filechooser.showOpenDialog(null);
        if (aux == 0 && (selectedfile = filechooser.getSelectedFile()) != null) {
            this.tempStationsFile = selectedfile.getAbsolutePath();
            this.stationsFileField.setText(selectedfile.getAbsolutePath());
        }
    }

    private void rmvButtonActionPerformed(ActionEvent evt) {
        int rowIndex = this.sourcesTable.convertRowIndexToModel(this.sourcesTable.getSelectedRow());
        if (rowIndex == -1) {
            return;
        }
        SourcesListTableModel sourcesModel = (SourcesListTableModel)this.sourcesTable.getModel();
        sourcesModel.getSources().remove(rowIndex);
        sourcesModel.fireTableDataChanged();
        this.curSource = null;
        ((ConfigStationsListTableModel)this.stationsTable.getModel()).fireTableDataChanged();
    }

    private void moveUpButtonActionPerformed(ActionEvent evt) {
        int rowIndex = this.sourcesTable.convertRowIndexToModel(this.sourcesTable.getSelectedRow());
        if (rowIndex <= 0) {
            return;
        }
        SourcesListTableModel sourcesModel = (SourcesListTableModel)this.sourcesTable.getModel();
        List<WaveSource> xsources = sourcesModel.getSources();
        WaveSource selected = xsources.get(rowIndex);
        xsources.remove(rowIndex);
        xsources.add(rowIndex - 1, selected);
        sourcesModel.fireTableDataChanged();
        this.sourcesTable.setRowSelectionInterval(rowIndex - 1, rowIndex - 1);
    }

    private void monveDownButtonActionPerformed(ActionEvent evt) {
        int rowIndex = this.sourcesTable.convertRowIndexToModel(this.sourcesTable.getSelectedRow());
        if (rowIndex == this.sourcesTable.getRowCount() - 1) {
            return;
        }
        SourcesListTableModel sourcesModel = (SourcesListTableModel)this.sourcesTable.getModel();
        List<WaveSource> xsources = sourcesModel.getSources();
        WaveSource selected = xsources.get(rowIndex);
        xsources.remove(rowIndex);
        xsources.add(rowIndex + 1, selected);
        sourcesModel.fireTableDataChanged();
        this.sourcesTable.setRowSelectionInterval(rowIndex + 1, rowIndex + 1);
    }

    public static Configuration load(String filename) throws Exception {
        Persister serializer = new Persister();
        Configuration newConfig = (Configuration)((Object)serializer.read(Configuration.class, new File(filename)));
        newConfig.updateSources();
        newConfig.configFile = filename;
        return newConfig;
    }

    public void save(String filename) throws Exception {
        Persister serializer = new Persister();
        serializer.write((Object)this, new File(filename));
    }

    public void updateSources() {
        for (WaveSource source : this.sources) {
            try {
                source.update();
            }
            catch (Exception e) {
                new ErrorDialog("Unable to update source: " + e.getMessage(), "Error", null, true).setVisible(true);
                e.printStackTrace();
            }
        }
        if (!this.sources.isEmpty()) {
            this.curSource = this.sources.get(0);
        }
    }

    public void updateTables() {
        this.sourcesTable.setModel(new SourcesListTableModel(this.sources));
        this.curSource = !this.sources.isEmpty() ? this.sources.get(0) : null;
        this.stationsTable.setModel(new ConfigStationsListTableModel(this.curSource));
    }

    @Override
    public void setVisible(boolean b) {
        this.stationsFileField.setText(this.StationsFile);
        this.updateSources();
        this.updateTables();
        super.setVisible(b);
    }
}

