/*
 * Decompiled with CFR 0.152.
 */
package pickewanalysis;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import pickewanalysis.PickEWAnalysis;
import pickewanalysis.TracePanel;

public class TracePanelMouseListener
implements MouseListener,
MouseMotionListener {
    private TracePanel panel;
    private int startX = -1;
    private int endX = -1;
    private boolean inDrag = false;

    public TracePanelMouseListener(TracePanel aThis) {
        this.panel = aThis;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2 && e.getButton() == 3) {
            ((PickEWAnalysis)this.panel.getTopLevelAncestor()).zoom(1.5);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        Point p = e.getPoint();
        this.startX = p.x;
        this.inDrag = true;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        Point p = e.getPoint();
        this.endX = p.x;
        this.inDrag = false;
        this.panel.repaint();
        int[] box = this.getDrawBox();
        if (box[2] > 5 && box[3] > 5) {
            long endtime;
            double timeSpan = this.panel.endtime - this.panel.starttime;
            if (timeSpan <= 0.0) {
                return;
            }
            long starttime = this.panel.starttime + (long)((double)this.startX / (double)this.panel.getWidth() * timeSpan + 0.5);
            if (starttime > (endtime = this.panel.starttime + (long)((double)this.endX / (double)this.panel.getWidth() * timeSpan + 0.5))) {
                ((PickEWAnalysis)this.panel.getTopLevelAncestor()).zoom(endtime, starttime);
            } else {
                ((PickEWAnalysis)this.panel.getTopLevelAncestor()).zoom(starttime, endtime);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Point p = e.getPoint();
        this.endX = p.x;
        this.panel.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Point p = e.getPoint();
        String tip = this.panel.isPick(p.x, p.y);
        if (tip == null) {
            this.panel.setToolTipText(null);
            return;
        }
        this.panel.setToolTipText(tip);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void drawBox(Graphics2D g) {
        if (!this.inDrag) {
            return;
        }
        int[] box = this.getDrawBox();
        Rectangle rect = new Rectangle(box[0], box[1], box[2], box[3]);
        Composite originalComposite = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, 0.2f));
        g.setPaint(new Color(230, 230, 100));
        g.fill(rect);
        g.setComposite(originalComposite);
        g.drawRect(box[0], box[1], box[2], box[3]);
    }

    private int[] getDrawBox() {
        int x = 0;
        int y = 0;
        int w = 0;
        int h = 0;
        if (this.startX < this.endX) {
            x = this.startX;
            w = this.endX - this.startX;
        } else {
            x = this.endX;
            w = this.startX - this.endX;
        }
        y = 1;
        h = this.panel.getHeight() - 3;
        return new int[]{x, y, w, h};
    }
}

