/*
 * Decompiled with CFR 0.152.
 */
package pickewanalysis.ewmessages;

import pickewanalysis.ewmessages.EWMessage;

public class CodaSCNL
extends EWMessage {
    public final int msgType = 9;
    public int instID;
    public int modID;
    public int seqNo;
    public String SCNL;
    public double time;
    public int[] peaks;
    public int duration;

    public CodaSCNL(String rawMsg) throws Exception {
        this.parseRawMsg(rawMsg);
    }

    public CodaSCNL(int modID, int instID, int seqNo, String SCNL, int[] peaks, int duration, double time) {
        this.instID = instID;
        this.modID = modID;
        this.seqNo = seqNo;
        this.SCNL = SCNL;
        this.peaks = peaks;
        this.duration = duration;
        this.time = time;
    }

    @Override
    public int getType() {
        return 9;
    }

    public String getRawMsg() {
        return this.getRawMsg(this.seqNo);
    }

    public String toString() {
        return this.getRawMsg(this.seqNo);
    }

    public String getRawMsg(int customSeqNo) {
        return String.valueOf(9) + " " + String.valueOf(this.modID) + " " + String.valueOf(this.instID) + " " + String.valueOf(customSeqNo) + " " + this.SCNL.replace(' ', '.') + " " + String.valueOf(this.peaks[0]) + " " + String.valueOf(this.peaks[1]) + " " + String.valueOf(this.peaks[2]) + " " + String.valueOf(this.peaks[3]) + " " + String.valueOf(this.peaks[4]) + " " + String.valueOf(this.peaks[5]) + " " + String.valueOf(this.duration);
    }

    public boolean parseRawMsg(String rawMsg) throws Exception {
        String[] parts = rawMsg.split("[\\s]+");
        int candidateType = Integer.valueOf(parts[0]);
        if (candidateType != this.msgType) {
            throw new Exception("Wrong message type.");
        }
        this.instID = Integer.valueOf(parts[2]);
        this.modID = Integer.valueOf(parts[1]);
        this.seqNo = Integer.valueOf(parts[3]);
        this.SCNL = parts[4].replace('.', ' ');
        this.peaks = new int[]{Integer.valueOf(parts[5]), Integer.valueOf(parts[6]), Integer.valueOf(parts[7]), Integer.valueOf(parts[8]), Integer.valueOf(parts[9]), Integer.valueOf(parts[10])};
        this.duration = Integer.valueOf(parts[11]);
        this.time = 0.0;
        return true;
    }

    public byte[] getBytes() {
        return this.getRawMsg().getBytes();
    }
}

