/*
 * Decompiled with CFR 0.152.
 */
package pickewanalysis.ewpicker;

import java.math.BigDecimal;
import pickewanalysis.ewmessages.CodaSCNL;
import pickewanalysis.ewmessages.EWMessageGroup;
import pickewanalysis.ewmessages.PickSCNL;
import pickewanalysis.ewpicker.Coda;
import pickewanalysis.ewpicker.EWPickerParameters;
import pickewanalysis.ewpicker.Pick;
import pickewanalysis.ewpicker.PickEWDebugMsg;
import pickewanalysis.ewpicker.PickEWStation;
import pickewanalysis.waveform.WaveForm;
import pickewanalysis.waveform.WaveFormGroup;

public class EWPicker {
    private EWPickerParameters Gparm;
    private PickEWStation Sta;
    public WaveFormGroup rdatGroup = new WaveFormGroup();
    public WaveFormGroup charGroup = new WaveFormGroup();
    public WaveFormGroup ltaGroup = new WaveFormGroup();
    public WaveFormGroup staGroup = new WaveFormGroup();
    public WaveFormGroup staltaGroup = new WaveFormGroup();
    private WaveForm curRdat;
    private WaveForm curChar;
    private WaveForm curLta;
    private WaveForm curSta;
    private WaveForm curStaLta;
    public EWMessageGroup messages = new EWMessageGroup();
    int sample_index;
    int SeqNo = 0;

    public EWPicker(PickEWStation station, EWPickerParameters parameters) {
        this.Gparm = parameters;
        this.Sta = station;
        this.Sta.initVar();
        this.rdatGroup = new WaveFormGroup();
        this.charGroup = new WaveFormGroup();
        this.ltaGroup = new WaveFormGroup();
        this.staGroup = new WaveFormGroup();
        this.staltaGroup = new WaveFormGroup();
    }

    public EWMessageGroup analyze(WaveFormGroup wfg) {
        for (WaveForm tracebuf : wfg) {
            if (!tracebuf.isSCNL(this.Sta.stat, this.Sta.chan, this.Sta.net, this.Sta.loc)) continue;
            if (this.Sta.first == 1) {
                this.Sta.endtime = (double)tracebuf.getEndTime() / 1000.0;
                this.Sta.first = 0;
                continue;
            }
            this.curRdat = this.rdatGroup.addEmptyWaveForm(this.Sta.stat, this.Sta.chan, this.Sta.net, this.Sta.loc, tracebuf.getStartTime(), tracebuf.getSamplingRate(), tracebuf.getSampleCount());
            this.curChar = this.charGroup.addEmptyWaveForm(this.Sta.stat, this.Sta.chan, this.Sta.net, this.Sta.loc, tracebuf.getStartTime(), tracebuf.getSamplingRate(), tracebuf.getSampleCount());
            this.curSta = this.staGroup.addEmptyWaveForm(this.Sta.stat, this.Sta.chan, this.Sta.net, this.Sta.loc, tracebuf.getStartTime(), tracebuf.getSamplingRate(), tracebuf.getSampleCount());
            this.curLta = this.ltaGroup.addEmptyWaveForm(this.Sta.stat, this.Sta.chan, this.Sta.net, this.Sta.loc, tracebuf.getStartTime(), tracebuf.getSamplingRate(), tracebuf.getSampleCount());
            this.curStaLta = this.staltaGroup.addEmptyWaveForm(this.Sta.stat, this.Sta.chan, this.Sta.net, this.Sta.loc, tracebuf.getStartTime(), tracebuf.getSamplingRate(), tracebuf.getSampleCount());
            double GapSizeD = tracebuf.getSamplingRate() * ((double)tracebuf.getStartTime() / 1000.0 - this.Sta.endtime);
            int GapSize = GapSizeD < 0.0 ? 0 : (int)(GapSizeD + 0.5);
            if (GapSize > 1 && GapSize <= this.Gparm.MaxGap) {
                System.err.println("Interpolation required but not yet supported.");
            }
            if (GapSize > this.Gparm.MaxGap) {
                System.err.println("Large gap detected.");
            }
            if (this.Restart(tracebuf.getSampleCount(), GapSize) == 1) {
                for (int i = 0; i < tracebuf.getSampleCount(); ++i) {
                    this.Sample(tracebuf.getIntSample(i));
                }
            } else {
                this.PickRA(tracebuf);
            }
            this.Sta.enddata = tracebuf.getIntSample(tracebuf.getSampleCount() - 1);
            this.Sta.endtime = (double)tracebuf.getEndTime() / 1000.0;
        }
        return this.messages;
    }

    private int Restart(int nsamp, int GapSize) {
        if (GapSize > this.Gparm.MaxGap) {
            this.Sta.initVar();
            this.Sta.ns_restart = nsamp;
            return 1;
        }
        if (this.Sta.ns_restart >= this.Gparm.RestartLength) {
            return 0;
        }
        this.Sta.ns_restart += nsamp;
        return 1;
    }

    private void Sample(int LongSample) {
        double small_double = 1.0E-10;
        this.Sta.rold = this.Sta.rdat;
        this.Sta.rdat = this.Sta.rdat * this.Sta.RawDataFilt + (double)(LongSample - this.Sta.old_sample) + 1.0E-10;
        double rdif = this.Sta.rdat - this.Sta.rold;
        this.Sta.old_sample = LongSample;
        double edat = this.Sta.rdat * this.Sta.rdat + this.Sta.CharFuncFilt * rdif * rdif;
        this.Sta.esta += this.Sta.StaFilt * (edat - this.Sta.esta);
        this.Sta.elta += this.Sta.LtaFilt * (edat - this.Sta.elta);
        this.Sta.eref = this.Sta.elta * this.Sta.EventThresh;
        this.Sta.eabs = this.Sta.RmavFilt * this.Sta.eabs + (1.0 - this.Sta.RmavFilt) * Math.abs(this.Sta.rdat);
        this.curRdat.addSample(this.Sta.rdat);
        this.curChar.addSample(edat);
        this.curSta.addSample(this.Sta.esta);
        this.curLta.addSample(this.Sta.elta);
        this.curStaLta.addSample(this.Sta.esta / this.Sta.elta);
    }

    private void PickRA(WaveForm WaveBuf) {
        int event_active;
        this.sample_index = -1;
        Pick Pick2 = this.Sta.pick;
        Coda Coda2 = this.Sta.coda;
        if (Pick2.status > 0 || Coda2.status > 0) {
            event_active = this.EventActive(WaveBuf);
            if (event_active == 1) {
                return;
            }
            if (event_active <= 0) {
                this.messages.add(new PickEWDebugMsg((long)(this.Sta.pick.time * 1000.0), event_active));
            }
        }
        int event_found;
        while ((event_found = this.ScanForEvent(WaveBuf)) != 0) {
            event_active = this.EventActive(WaveBuf);
            if (event_active == 1) {
                return;
            }
            if (event_active > 0) continue;
            this.messages.add(new PickEWDebugMsg((long)(this.Sta.pick.time * 1000.0), event_active));
        }
        return;
    }

    private int ScanForEvent(WaveForm WaveBuf) {
        Pick Pick2 = this.Sta.pick;
        Coda Coda2 = this.Sta.coda;
        Coda2.status = 0;
        Pick2.status = 0;
        while (++this.sample_index < WaveBuf.getSampleCount()) {
            int new_sample = WaveBuf.getIntSample(this.sample_index);
            int old_sample = this.Sta.old_sample;
            double old_eref = this.Sta.eref;
            this.Sample(new_sample);
            if (this.Sta.eabs > this.Sta.DeadSta || !(this.Sta.esta > this.Sta.eref)) continue;
            Pick2.time = (double)WaveBuf.getStartTime() / 1000.0 + (double)this.sample_index / WaveBuf.getSamplingRate();
            Coda2.len_win = 0;
            Coda2.len_sec = 0;
            for (int wi = 0; wi < 6; ++wi) {
                Coda2.aav[wi] = 0;
            }
            this.Sta.crtinc = this.Sta.eref / this.Sta.Erefs;
            this.Sta.ecrit = old_eref;
            this.Sta.evlen = 0;
            this.Sta.isml = 0;
            this.Sta.k = 0;
            this.Sta.m = 1;
            this.Sta.mint = 0;
            this.Sta.ndrt = 0;
            this.Sta.next = 0;
            this.Sta.nzero = 0;
            this.Sta.rlast = this.Sta.rdat;
            this.Sta.rsrdat = 0.0;
            this.Sta.sarray[0] = new_sample;
            this.Sta.tmax = Math.abs(this.Sta.rdat);
            this.Sta.xfrz = 1.6 * this.Sta.eabs;
            this.Sta.xdot = new_sample - old_sample;
            this.Sta.rbig = (this.Sta.xdot < 0 ? -this.Sta.xdot : this.Sta.xdot) / 3;
            double d = this.Sta.rbig = this.Sta.eabs > this.Sta.rbig ? this.Sta.eabs : this.Sta.rbig;
            if (this.Sta.eabs > this.Sta.AltCoda * this.Sta.CodaTerm) {
                this.Sta.cocrit = this.Sta.PreEvent * this.Sta.eabs;
                Coda2.len_out = -1;
            } else {
                this.Sta.cocrit = this.Sta.CodaTerm;
                Coda2.len_out = 1;
            }
            Coda2.status = 1;
            Pick2.status = 1;
            return 1;
        }
        return 0;
    }

    private int EventActive(WaveForm WaveBuf) {
        Pick Pick2 = this.Sta.pick;
        Coda Coda2 = this.Sta.coda;
        while (++this.sample_index < WaveBuf.getSampleCount()) {
            int new_sample = WaveBuf.getIntSample(this.sample_index);
            this.Sample(new_sample);
            if (Coda2.status == 1) {
                int lwindow = (int)(WaveBuf.getSamplingRate() + 0.5);
                if (Coda2.len_win != 72) {
                    lwindow *= 2;
                }
                this.Sta.rsrdat += Math.abs(this.Sta.rdat);
                if (++this.Sta.ndrt >= lwindow) {
                    int[] pwin = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 10, 12, 16, 20, 24, 28, 32, 36, 40, 44, 48, 56, 64, 70, 73};
                    if (Coda2.len_win++ == pwin[this.Sta.k]) {
                        for (int i = 5; i > 0; --i) {
                            Coda2.aav[i] = Coda2.aav[i - 1];
                        }
                        ++this.Sta.k;
                    }
                    Coda2.len_sec = 2 * Coda2.len_win - 1;
                    if (Coda2.len_sec == 145) {
                        Coda2.len_sec = 144;
                    }
                    if (Pick2.status == 2 && Coda2.len_sec >= this.Sta.MinCodaLen) {
                        this.ReportPick();
                        Pick2.status = 0;
                        if (this.Gparm.NoCoda == 1) {
                            Coda2.status = 0;
                        }
                    }
                    double ave_abs_val = this.Sta.rsrdat / (double)lwindow;
                    Coda2.aav[0] = (int)(ave_abs_val + 0.5);
                    this.Sta.ndrt = 0;
                    this.Sta.rsrdat = 0.0;
                    if (Coda2.len_win == 73 || ave_abs_val < this.Sta.cocrit) {
                        if (Coda2.len_sec < this.Sta.MinCodaLen) {
                            return -1;
                        }
                        Coda2.len_out *= Coda2.len_sec;
                        Coda2.status = 2;
                    }
                }
            }
            if (Coda2.status == 2) {
                if (Pick2.status == 0) {
                    this.ReportCoda();
                    Coda2.status = 0;
                }
                if (Pick2.status == 2) {
                    this.ReportPick();
                    this.ReportCoda();
                    Coda2.status = 0;
                    Pick2.status = 0;
                }
            }
            if (Pick2.status == 1) {
                double adata;
                if (++this.Sta.evlen < 10) {
                    this.Sta.sarray[this.Sta.evlen] = new_sample;
                }
                if (this.Sta.next < 3 && (adata = Math.abs(this.Sta.rdat)) > this.Sta.tmax) {
                    this.Sta.tmax = adata;
                }
                if (Math.abs(this.Sta.rdat) >= this.Sta.rbig && this.Sign(this.Sta.rdat, this.Sta.rlast) != this.Sta.rdat) {
                    ++this.Sta.nzero;
                    this.Sta.rlast = this.Sta.rdat;
                }
                if (++this.Sta.mint > this.Sta.MaxMint) {
                    return -2;
                }
                if (this.Sign(this.Sta.rdat, this.Sta.rold) == this.Sta.rdat) continue;
                this.Sta.mint = 0;
                this.Sta.ecrit += this.Sta.crtinc;
                ++this.Sta.isml;
                if (this.Sta.esta > this.Sta.ecrit) {
                    this.Sta.isml = 0;
                }
                if (this.Sta.next < 3) {
                    Pick2.xpk[this.Sta.next++] = this.Sta.tmax;
                    if (this.Sta.next == 1) {
                        double vt3 = this.Sta.tmax / 3.0;
                        this.Sta.rbig = vt3 > this.Sta.rbig ? vt3 : this.Sta.rbig;
                    }
                    this.Sta.tmax = 0.0;
                }
                int itrm = this.Sta.Itr1 + this.Sta.m / this.Sta.Itr1;
                if (this.Sta.m > 150) {
                    itrm = 50;
                }
                if (++this.Sta.m != this.Sta.MinSmallZC && this.Sta.isml < itrm) continue;
                boolean noise = true;
                for (int i = 0; i < 3; ++i) {
                    if (!(Pick2.xpk[i] >= (double)this.Sta.MinPeakSize)) continue;
                    if (this.Sta.m != this.Sta.MinSmallZC || this.Sta.nzero < this.Sta.MinBigZC) break;
                    noise = false;
                    break;
                }
                if (noise) {
                    return -3;
                }
                Pick2.FirstMotion = (char)32;
                int k = 0;
                while (true) {
                    if (this.Sta.xdot <= 0) {
                        if (this.Sta.sarray[k + 1] > this.Sta.sarray[k] || k == 8) {
                            if (k == 0) break;
                            Pick2.FirstMotion = (char)68;
                            break;
                        }
                    } else if (this.Sta.sarray[k + 1] < this.Sta.sarray[k] || k == 8) {
                        if (k == 0) break;
                        Pick2.FirstMotion = (char)85;
                        break;
                    }
                    ++k;
                }
                double xpc = Pick2.xpk[0] > Math.abs((double)this.Sta.sarray[0]) ? Pick2.xpk[0] : Pick2.xpk[1];
                double xon = Math.abs((double)this.Sta.xdot / this.Sta.xfrz);
                double xp0 = Pick2.xpk[0] / this.Sta.xfrz;
                double xp1 = Pick2.xpk[1] / this.Sta.xfrz;
                double xp2 = Pick2.xpk[2] / this.Sta.xfrz;
                Pick2.weight = 3;
                if (xp0 > 2.0 && xon > 0.5 && xpc > 25.0) {
                    Pick2.weight = 2;
                }
                if (xp0 > 3.0 && (xp1 > 3.0 || xp2 > 3.0) && xon > 0.5 && xpc > 100.0) {
                    Pick2.weight = 1;
                }
                if (xp0 > 4.0 && (xp1 > 6.0 || xp2 > 6.0) & xon > 0.5 && xpc > 200.0) {
                    Pick2.weight = 0;
                }
                Pick2.status = 2;
                if (Coda2.status == 2) {
                    this.ReportPick();
                    this.ReportCoda();
                    Coda2.status = 0;
                    Pick2.status = 0;
                }
            }
            if (Pick2.status != 0 || Coda2.status != 0) continue;
            return 0;
        }
        return 1;
    }

    private void ReportPick() {
        BigDecimal bd = new BigDecimal(this.Sta.pick.time).setScale(2, 5);
        PickSCNL newPick = new PickSCNL(1, 255, this.SeqNo += this.Gparm.NoCoda, this.Sta.getSCNLStr(), this.Sta.pick.FirstMotion, this.Sta.pick.weight, bd.doubleValue(), new int[]{(int)(this.Sta.pick.xpk[0] + 0.5), (int)(this.Sta.pick.xpk[1] + 0.5), (int)(this.Sta.pick.xpk[2] + 0.5)});
        this.messages.add(newPick);
    }

    private void ReportCoda() {
        if (this.Gparm.NoCoda == 1) {
            return;
        }
        CodaSCNL newCoda = new CodaSCNL(1, 255, this.SeqNo++, this.Sta.getSCNLStr(), new int[]{this.Sta.coda.aav[0], this.Sta.coda.aav[1], this.Sta.coda.aav[2], this.Sta.coda.aav[3], this.Sta.coda.aav[4], this.Sta.coda.aav[5]}, this.Sta.coda.len_out, (double)this.curRdat.getStartTime() / 1000.0 + (double)this.sample_index / (double)this.curRdat.getSampleCount());
        this.messages.add(newCoda);
    }

    private double Sign(double x, double y) {
        if (x == 0.0) {
            return 0.0;
        }
        if (x < 0.0) {
            if (y < 0.0) {
                return x;
            }
            return -x;
        }
        if (y < 0.0) {
            return -x;
        }
        return x;
    }
}

