/*
 * Decompiled with CFR 0.152.
 */
package pickewanalysis.ewpicker;

import java.util.Locale;
import pickewanalysis.ewpicker.Coda;
import pickewanalysis.ewpicker.Pick;

public class PickEWStation {
    public int flag = 1;
    public int pinno = 0;
    public int Itr1 = 3;
    public int MinSmallZC = 40;
    public int MinBigZC = 3;
    public int MinPeakSize = 25;
    public int MaxMint = 500;
    public int ClipCount = 32768000;
    public int MinCodaLen = 3;
    public double RawDataFilt = 0.988;
    public double CharFuncFilt = 3.0;
    public double StaFilt = 0.4;
    public double LtaFilt = 0.015;
    public double EventThresh = 2.5;
    public double RmavFilt = 0.9961;
    public double DeadSta = 19200.0;
    public double CodaTerm = 15.0;
    public double AltCoda = 0.8;
    public double PreEvent = 1.5;
    public double Erefs = 50000.0;
    public String stat = "";
    public String chan = "";
    public String net = "";
    public String loc = "";
    public Coda coda = new Coda();
    public Pick pick = new Pick();
    public double cocrit = 0.0;
    public double crtinc = 0.0;
    public double eabs = 0.0;
    public double ecrit = 0.0;
    public double elta = 0.0;
    public int enddata = 0;
    public double endtime = 0.0;
    public double eref = 0.0;
    public double esta = 0.0;
    public int evlen = 0;
    public int first = 0;
    public int isml = 0;
    public int k = 0;
    public int m = 0;
    public int mint;
    public int ndrt = 0;
    public int next = 0;
    public int nzero = 0;
    public int old_sample = 0;
    public int ns_restart;
    public double rdat = 0.0;
    public double rbig = 0.0;
    public double rlast = 0.0;
    public double rold = 0.0;
    public double rsrdat = 0.0;
    public int[] sarray = new int[10];
    public double tmax;
    public int xdot = 0;
    public double xfrz = 0.0;

    public void initVar() {
        int i;
        this.cocrit = 0.0;
        this.crtinc = 0.0;
        this.eabs = 0.0;
        this.ecrit = 0.0;
        this.elta = 0.0;
        this.enddata = 0;
        this.endtime = 0.0;
        this.eref = 0.0;
        this.esta = 0.0;
        this.evlen = 0;
        this.first = 1;
        this.isml = 0;
        this.k = 0;
        this.m = 0;
        this.ndrt = 0;
        this.next = 0;
        this.nzero = 0;
        this.old_sample = 0;
        this.ns_restart = 0;
        this.rdat = 0.0;
        this.rbig = 0.0;
        this.rlast = 0.0;
        this.rold = 0.0;
        this.rsrdat = 0.0;
        this.tmax = 0.0;
        this.xdot = 0;
        this.xfrz = 0.0;
        for (i = 0; i < 10; ++i) {
            this.sarray[i] = 0;
        }
        this.pick.time = 0.0;
        for (i = 0; i < 3; ++i) {
            this.pick.xpk[i] = 0.0;
        }
        this.pick.FirstMotion = (char)63;
        this.pick.weight = 0;
        this.pick.status = 0;
        for (i = 0; i < 6; ++i) {
            this.coda.aav[i] = 0;
        }
        this.coda.len_sec = 0;
        this.coda.len_out = 0;
        this.coda.len_win = 0;
        this.coda.status = 0;
    }

    protected PickEWStation(String line) throws Exception {
        String[] parts = line.split("[\\s]+");
        this.flag = Integer.valueOf(parts[0]);
        this.pinno = Integer.valueOf(parts[1]);
        this.stat = parts[2];
        this.chan = parts[3];
        this.net = parts[4];
        this.loc = parts[5];
        this.Itr1 = Integer.valueOf(parts[6]);
        this.MinSmallZC = Integer.valueOf(parts[7]);
        this.MinBigZC = Integer.valueOf(parts[8]);
        this.MinPeakSize = Integer.valueOf(parts[9]);
        this.MaxMint = Integer.valueOf(parts[10]);
        this.MinCodaLen = Integer.valueOf(parts[11]);
        this.RawDataFilt = Double.valueOf(parts[12]);
        this.CharFuncFilt = Double.valueOf(parts[13]);
        this.StaFilt = Double.valueOf(parts[14]);
        this.LtaFilt = Double.valueOf(parts[15]);
        this.EventThresh = Double.valueOf(parts[16]);
        this.RmavFilt = Double.valueOf(parts[17]);
        this.DeadSta = Double.valueOf(parts[18]);
        this.CodaTerm = Double.valueOf(parts[19]);
        this.AltCoda = Double.valueOf(parts[20]);
        this.PreEvent = Double.valueOf(parts[21]);
        this.Erefs = Double.valueOf(parts[22]);
        this.ClipCount = parts.length >= 24 ? Integer.valueOf(parts[23]) : Integer.MAX_VALUE;
    }

    public String[] getSCNL() {
        return new String[]{this.stat, this.chan, this.net, this.loc};
    }

    public String getSCNLStr() {
        return this.stat + " " + this.chan + " " + this.net + " " + this.loc;
    }

    public String toString() {
        return this.getSCNLStr();
    }

    public String toStationLine() {
        String stationLine = String.format(Locale.UK, "  %4d  %4d %5s %3s %2s %2s %2d %3d %2d %4d %4d %2d %4.3f %3.1f %4.3f %4.3f %3.1f %6.4f %5.0f %5.1f %3.1f %3.1f %6.0f %8d", this.flag, this.pinno, this.stat, this.chan, this.net, this.loc.replace(' ', '-'), this.Itr1, this.MinSmallZC, this.MinBigZC, this.MinPeakSize, this.MaxMint, this.MinCodaLen, this.RawDataFilt, this.CharFuncFilt, this.StaFilt, this.LtaFilt, this.EventThresh, this.RmavFilt, this.DeadSta, this.CodaTerm, this.AltCoda, this.PreEvent, this.Erefs, this.ClipCount);
        return stationLine;
    }
}

