/*
 * Decompiled with CFR 0.152.
 */
package pickewanalysis.waveform;

import java.text.SimpleDateFormat;
import java.util.Locale;

public class WaveForm {
    SimpleDateFormat humanDate = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.SSS");
    protected long starttime;
    protected long endtime;
    protected int nsamp;
    protected double samprate;
    protected double average;
    protected double[] samples;
    protected String stat;
    protected String chan;
    protected String net;
    protected String loc;
    private int addSamplePos = 0;

    public WaveForm(String stat, String chan, String net, String loc, long starttime, double samprate, double[] samples) {
        this.stat = stat;
        this.chan = chan;
        this.net = net;
        this.loc = loc;
        this.starttime = starttime;
        this.samprate = samprate;
        this.samples = samples;
        this.nsamp = samples.length;
        this.endtime = starttime + (long)((double)(this.nsamp - 1) * 1000.0 / samprate);
        this.average = 0.0;
        for (int i = 0; i < this.nsamp; ++i) {
            this.average += samples[i];
        }
        this.average /= (double)this.nsamp;
    }

    protected WaveForm() {
    }

    public long getStartTime() {
        return this.starttime;
    }

    public long getEndTime() {
        return this.endtime;
    }

    public double[] getSamples() {
        return this.samples;
    }

    public int getIntSample(int i) {
        return (int)this.samples[i];
    }

    public void addSample(double sample) {
        this.samples[this.addSamplePos++] = sample;
        if (this.addSamplePos == this.samples.length) {
            this.addSamplePos = 0;
        }
    }

    public double[] removeAverage() {
        return this.removeAverage(this.average);
    }

    public double[] removeAverage(double newaverage) {
        double[] output = new double[this.nsamp];
        for (int i = 0; i < this.nsamp; ++i) {
            output[i] = this.samples[i] - newaverage;
        }
        return output;
    }

    public double getSamplingRate() {
        return this.samprate;
    }

    public int getSampleCount() {
        return this.nsamp;
    }

    public boolean isSCNL(String stat, String chan, String net, String loc) {
        return this.stat.equals(stat) && this.chan.equals(chan) && this.net.equals(net) && this.loc.equals(loc);
    }

    public String getStation() {
        return this.stat;
    }

    public String getChannel() {
        return this.chan;
    }

    public String getNetwork() {
        return this.net;
    }

    public String getLocation() {
        return this.loc;
    }

    public String toString() {
        return String.format(Locale.UK, "%5s.%3s.%2s.%2s %23s %23s %5d", this.stat, this.chan, this.net, this.loc, this.humanDate.format(this.starttime), this.humanDate.format(this.endtime), this.nsamp);
    }
}

